// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.services.directconnect.model.CreateBgpPeerResponse
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.VirtualInterface
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateBGPPeerOperationDeserializer: HttpDeserialize<CreateBgpPeerResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateBgpPeerResponse {
        if (!response.status.isSuccess()) {
            throwCreateBgpPeerError(context, response)
        }
        val builder = CreateBgpPeerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateBGPPeerOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateBgpPeerError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateBGPPeerOperationBody(builder: CreateBgpPeerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val VIRTUALINTERFACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("virtualInterface"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(VIRTUALINTERFACE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                VIRTUALINTERFACE_DESCRIPTOR.index -> builder.virtualInterface = deserializeVirtualInterfaceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
