// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



/**
 * Information about a BGP peer.
 */
public class BgpPeer private constructor(builder: Builder) {
    /**
     * The address family for the BGP peer.
     */
    public val addressFamily: aws.sdk.kotlin.services.directconnect.model.AddressFamily? = builder.addressFamily
    /**
     * The IP address assigned to the Amazon interface.
     */
    public val amazonAddress: kotlin.String? = builder.amazonAddress
    /**
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    public val asn: kotlin.Int = builder.asn
    /**
     * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.
     */
    public val authKey: kotlin.String? = builder.authKey
    /**
     * The Direct Connect endpoint that terminates the BGP peer.
     */
    public val awsDeviceV2: kotlin.String? = builder.awsDeviceV2
    /**
     * The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.
     */
    public val awsLogicalDeviceId: kotlin.String? = builder.awsLogicalDeviceId
    /**
     * The ID of the BGP peer.
     */
    public val bgpPeerId: kotlin.String? = builder.bgpPeerId
    /**
     * The state of the BGP peer. The following are the possible values:
     * + `verifying`: The BGP peering addresses or ASN require validation before the BGP peer can be created. This state applies only to public virtual interfaces.
     * + `pending`: The BGP peer is created, and remains in this state until it is ready to be established.
     * + `available`: The BGP peer is ready to be established.
     * + `deleting`: The BGP peer is being deleted.
     * + `deleted`: The BGP peer is deleted and cannot be established.
     */
    public val bgpPeerState: aws.sdk.kotlin.services.directconnect.model.BgpPeerState? = builder.bgpPeerState
    /**
     * The status of the BGP peer. The following are the possible values:
     * + `up`: The BGP peer is established. This state does not indicate the state of the routing function. Ensure that you are receiving routes over the BGP session.
     * + `down`: The BGP peer is down.
     * + `unknown`: The BGP peer status is not available.
     */
    public val bgpStatus: aws.sdk.kotlin.services.directconnect.model.BgpStatus? = builder.bgpStatus
    /**
     * The IP address assigned to the customer interface.
     */
    public val customerAddress: kotlin.String? = builder.customerAddress

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.BgpPeer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BgpPeer(")
        append("addressFamily=$addressFamily,")
        append("amazonAddress=$amazonAddress,")
        append("asn=$asn,")
        append("authKey=$authKey,")
        append("awsDeviceV2=$awsDeviceV2,")
        append("awsLogicalDeviceId=$awsLogicalDeviceId,")
        append("bgpPeerId=$bgpPeerId,")
        append("bgpPeerState=$bgpPeerState,")
        append("bgpStatus=$bgpStatus,")
        append("customerAddress=$customerAddress")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressFamily?.hashCode() ?: 0
        result = 31 * result + (amazonAddress?.hashCode() ?: 0)
        result = 31 * result + (asn)
        result = 31 * result + (authKey?.hashCode() ?: 0)
        result = 31 * result + (awsDeviceV2?.hashCode() ?: 0)
        result = 31 * result + (awsLogicalDeviceId?.hashCode() ?: 0)
        result = 31 * result + (bgpPeerId?.hashCode() ?: 0)
        result = 31 * result + (bgpPeerState?.hashCode() ?: 0)
        result = 31 * result + (bgpStatus?.hashCode() ?: 0)
        result = 31 * result + (customerAddress?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BgpPeer

        if (addressFamily != other.addressFamily) return false
        if (amazonAddress != other.amazonAddress) return false
        if (asn != other.asn) return false
        if (authKey != other.authKey) return false
        if (awsDeviceV2 != other.awsDeviceV2) return false
        if (awsLogicalDeviceId != other.awsLogicalDeviceId) return false
        if (bgpPeerId != other.bgpPeerId) return false
        if (bgpPeerState != other.bgpPeerState) return false
        if (bgpStatus != other.bgpStatus) return false
        if (customerAddress != other.customerAddress) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.BgpPeer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The address family for the BGP peer.
         */
        public var addressFamily: aws.sdk.kotlin.services.directconnect.model.AddressFamily? = null
        /**
         * The IP address assigned to the Amazon interface.
         */
        public var amazonAddress: kotlin.String? = null
        /**
         * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
         */
        public var asn: kotlin.Int = 0
        /**
         * The authentication key for BGP configuration. This string has a minimum length of 6 characters and and a maximun lenth of 80 characters.
         */
        public var authKey: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the BGP peer.
         */
        public var awsDeviceV2: kotlin.String? = null
        /**
         * The Direct Connect endpoint that terminates the logical connection. This device might be different than the device that terminates the physical connection.
         */
        public var awsLogicalDeviceId: kotlin.String? = null
        /**
         * The ID of the BGP peer.
         */
        public var bgpPeerId: kotlin.String? = null
        /**
         * The state of the BGP peer. The following are the possible values:
         * + `verifying`: The BGP peering addresses or ASN require validation before the BGP peer can be created. This state applies only to public virtual interfaces.
         * + `pending`: The BGP peer is created, and remains in this state until it is ready to be established.
         * + `available`: The BGP peer is ready to be established.
         * + `deleting`: The BGP peer is being deleted.
         * + `deleted`: The BGP peer is deleted and cannot be established.
         */
        public var bgpPeerState: aws.sdk.kotlin.services.directconnect.model.BgpPeerState? = null
        /**
         * The status of the BGP peer. The following are the possible values:
         * + `up`: The BGP peer is established. This state does not indicate the state of the routing function. Ensure that you are receiving routes over the BGP session.
         * + `down`: The BGP peer is down.
         * + `unknown`: The BGP peer status is not available.
         */
        public var bgpStatus: aws.sdk.kotlin.services.directconnect.model.BgpStatus? = null
        /**
         * The IP address assigned to the customer interface.
         */
        public var customerAddress: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.BgpPeer) : this() {
            this.addressFamily = x.addressFamily
            this.amazonAddress = x.amazonAddress
            this.asn = x.asn
            this.authKey = x.authKey
            this.awsDeviceV2 = x.awsDeviceV2
            this.awsLogicalDeviceId = x.awsLogicalDeviceId
            this.bgpPeerId = x.bgpPeerId
            this.bgpPeerState = x.bgpPeerState
            this.bgpStatus = x.bgpStatus
            this.customerAddress = x.customerAddress
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.BgpPeer = BgpPeer(this)
    }
}
