// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.directconnect.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.directconnect.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.directconnect.model.*
import aws.sdk.kotlin.services.directconnect.model.AcceptDirectConnectGatewayAssociationProposalRequest
import aws.sdk.kotlin.services.directconnect.model.AllocateConnectionOnInterconnectRequest
import aws.sdk.kotlin.services.directconnect.model.AllocateHostedConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.AllocatePublicVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.AllocateTransitVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.AssociateConnectionWithLagRequest
import aws.sdk.kotlin.services.directconnect.model.AssociateHostedConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.AssociateMacSecKeyRequest
import aws.sdk.kotlin.services.directconnect.model.AssociateVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.ConfirmConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.ConfirmCustomerAgreementRequest
import aws.sdk.kotlin.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.ConfirmTransitVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.CreateBgpPeerRequest
import aws.sdk.kotlin.services.directconnect.model.CreateConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.CreateDirectConnectGatewayAssociationProposalRequest
import aws.sdk.kotlin.services.directconnect.model.CreateDirectConnectGatewayAssociationRequest
import aws.sdk.kotlin.services.directconnect.model.CreateDirectConnectGatewayRequest
import aws.sdk.kotlin.services.directconnect.model.CreateInterconnectRequest
import aws.sdk.kotlin.services.directconnect.model.CreateLagRequest
import aws.sdk.kotlin.services.directconnect.model.CreatePrivateVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.CreatePublicVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.CreateTransitVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteBgpPeerRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteDirectConnectGatewayAssociationProposalRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteDirectConnectGatewayAssociationRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteDirectConnectGatewayRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteInterconnectRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteLagRequest
import aws.sdk.kotlin.services.directconnect.model.DeleteVirtualInterfaceRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeConnectionLoaRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeConnectionsOnInterconnectRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeConnectionsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeCustomerMetadataRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewayAssociationProposalsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewayAssociationsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewayAttachmentsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeDirectConnectGatewaysRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeHostedConnectionsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeInterconnectLoaRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeInterconnectsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeLagsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeLoaRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeLocationsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeRouterConfigurationRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeTagsRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeVirtualGatewaysRequest
import aws.sdk.kotlin.services.directconnect.model.DescribeVirtualInterfacesRequest
import aws.sdk.kotlin.services.directconnect.model.DisassociateConnectionFromLagRequest
import aws.sdk.kotlin.services.directconnect.model.DisassociateMacSecKeyRequest
import aws.sdk.kotlin.services.directconnect.model.ListVirtualInterfaceTestHistoryRequest
import aws.sdk.kotlin.services.directconnect.model.StartBgpFailoverTestRequest
import aws.sdk.kotlin.services.directconnect.model.StopBgpFailoverTestRequest
import aws.sdk.kotlin.services.directconnect.model.TagResourceRequest
import aws.sdk.kotlin.services.directconnect.model.UntagResourceRequest
import aws.sdk.kotlin.services.directconnect.model.UpdateConnectionRequest
import aws.sdk.kotlin.services.directconnect.model.UpdateDirectConnectGatewayAssociationRequest
import aws.sdk.kotlin.services.directconnect.model.UpdateDirectConnectGatewayRequest
import aws.sdk.kotlin.services.directconnect.model.UpdateLagRequest
import aws.sdk.kotlin.services.directconnect.model.UpdateVirtualInterfaceAttributesRequest
import aws.sdk.kotlin.services.directconnect.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Direct Connect"
public const val ServiceApiVersion: String = "2012-10-25"
public const val SdkVersion: String = "0.21.3-beta"

internal class DefaultDirectConnectClient(override val config: DirectConnectClient.Config) : DirectConnectClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Accepts a proposal request to attach a virtual private gateway or transit gateway to a Direct Connect gateway.
     */
    override suspend fun acceptDirectConnectGatewayAssociationProposal(input: AcceptDirectConnectGatewayAssociationProposalRequest): AcceptDirectConnectGatewayAssociationProposalResponse {
        val op = SdkHttpOperation.build<AcceptDirectConnectGatewayAssociationProposalRequest, AcceptDirectConnectGatewayAssociationProposalResponse> {
            serializer = AcceptDirectConnectGatewayAssociationProposalOperationSerializer()
            deserializer = AcceptDirectConnectGatewayAssociationProposalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AcceptDirectConnectGatewayAssociationProposal"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AcceptDirectConnectGatewayAssociationProposalRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AcceptDirectConnectGatewayAssociationProposal-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deprecated. Use AllocateHostedConnection instead.
     *
     * Creates a hosted connection on an interconnect.
     *
     * Allocates a VLAN number and a specified amount of bandwidth for use by a hosted connection on the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun allocateConnectionOnInterconnect(input: AllocateConnectionOnInterconnectRequest): AllocateConnectionOnInterconnectResponse {
        val op = SdkHttpOperation.build<AllocateConnectionOnInterconnectRequest, AllocateConnectionOnInterconnectResponse> {
            serializer = AllocateConnectionOnInterconnectOperationSerializer()
            deserializer = AllocateConnectionOnInterconnectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AllocateConnectionOnInterconnect"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AllocateConnectionOnInterconnectRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AllocateConnectionOnInterconnect-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.
     *
     * Allocates a VLAN number and a specified amount of capacity (bandwidth) for use by a hosted connection on the specified interconnect or LAG of interconnects. Amazon Web Services polices the hosted connection for the specified capacity and the Direct Connect Partner must also police the hosted connection for the specified capacity.
     *
     * Intended for use by Direct Connect Partners only.
     */
    override suspend fun allocateHostedConnection(input: AllocateHostedConnectionRequest): AllocateHostedConnectionResponse {
        val op = SdkHttpOperation.build<AllocateHostedConnectionRequest, AllocateHostedConnectionResponse> {
            serializer = AllocateHostedConnectionOperationSerializer()
            deserializer = AllocateHostedConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AllocateHostedConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AllocateHostedConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AllocateHostedConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provisions a private virtual interface to be owned by the specified Amazon Web Services account.
     *
     * Virtual interfaces created using this action must be confirmed by the owner using ConfirmPrivateVirtualInterface. Until then, the virtual interface is in the `Confirming` state and is not available to handle traffic.
     */
    override suspend fun allocatePrivateVirtualInterface(input: AllocatePrivateVirtualInterfaceRequest): AllocatePrivateVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<AllocatePrivateVirtualInterfaceRequest, AllocatePrivateVirtualInterfaceResponse> {
            serializer = AllocatePrivateVirtualInterfaceOperationSerializer()
            deserializer = AllocatePrivateVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AllocatePrivateVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AllocatePrivateVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AllocatePrivateVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provisions a public virtual interface to be owned by the specified Amazon Web Services account.
     *
     * The owner of a connection calls this function to provision a public virtual interface to be owned by the specified Amazon Web Services account.
     *
     * Virtual interfaces created using this function must be confirmed by the owner using ConfirmPublicVirtualInterface. Until this step has been completed, the virtual interface is in the `confirming` state and is not available to handle traffic.
     *
     * When creating an IPv6 public virtual interface, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     */
    override suspend fun allocatePublicVirtualInterface(input: AllocatePublicVirtualInterfaceRequest): AllocatePublicVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<AllocatePublicVirtualInterfaceRequest, AllocatePublicVirtualInterfaceResponse> {
            serializer = AllocatePublicVirtualInterfaceOperationSerializer()
            deserializer = AllocatePublicVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AllocatePublicVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AllocatePublicVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AllocatePublicVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provisions a transit virtual interface to be owned by the specified Amazon Web Services account. Use this type of interface to connect a transit gateway to your Direct Connect gateway.
     *
     * The owner of a connection provisions a transit virtual interface to be owned by the specified Amazon Web Services account.
     *
     * After you create a transit virtual interface, it must be confirmed by the owner using ConfirmTransitVirtualInterface. Until this step has been completed, the transit virtual interface is in the `requested` state and is not available to handle traffic.
     */
    override suspend fun allocateTransitVirtualInterface(input: AllocateTransitVirtualInterfaceRequest): AllocateTransitVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<AllocateTransitVirtualInterfaceRequest, AllocateTransitVirtualInterfaceResponse> {
            serializer = AllocateTransitVirtualInterfaceOperationSerializer()
            deserializer = AllocateTransitVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AllocateTransitVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AllocateTransitVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AllocateTransitVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates an existing connection with a link aggregation group (LAG). The connection is interrupted and re-established as a member of the LAG (connectivity to Amazon Web Services is interrupted). The connection must be hosted on the same Direct Connect endpoint as the LAG, and its bandwidth must match the bandwidth for the LAG. You can re-associate a connection that's currently associated with a different LAG; however, if removing the connection would cause the original LAG to fall below its setting for minimum number of operational connections, the request fails.
     *
     * Any virtual interfaces that are directly associated with the connection are automatically re-associated with the LAG. If the connection was originally associated with a different LAG, the virtual interfaces remain associated with the original LAG.
     *
     * For interconnects, any hosted connections are automatically re-associated with the LAG. If the interconnect was originally associated with a different LAG, the hosted connections remain associated with the original LAG.
     */
    override suspend fun associateConnectionWithLag(input: AssociateConnectionWithLagRequest): AssociateConnectionWithLagResponse {
        val op = SdkHttpOperation.build<AssociateConnectionWithLagRequest, AssociateConnectionWithLagResponse> {
            serializer = AssociateConnectionWithLagOperationSerializer()
            deserializer = AssociateConnectionWithLagOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateConnectionWithLag"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateConnectionWithLagRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateConnectionWithLag-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect. If the target interconnect or LAG has an existing hosted connection with a conflicting VLAN number or IP address, the operation fails. This action temporarily interrupts the hosted connection's connectivity to Amazon Web Services as it is being migrated.
     *
     * Intended for use by Direct Connect Partners only.
     */
    override suspend fun associateHostedConnection(input: AssociateHostedConnectionRequest): AssociateHostedConnectionResponse {
        val op = SdkHttpOperation.build<AssociateHostedConnectionRequest, AssociateHostedConnectionResponse> {
            serializer = AssociateHostedConnectionOperationSerializer()
            deserializer = AssociateHostedConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateHostedConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateHostedConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateHostedConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an Direct Connect dedicated connection.
     *
     * You must supply either the `secretARN,` or the CKN/CAK (`ckn` and `cak`) pair in the request.
     *
     * For information about MAC Security (MACsec) key considerations, see [MACsec pre-shared CKN/CAK key considerations ](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-key-consideration) in the *Direct Connect User Guide*.
     */
    override suspend fun associateMacSecKey(input: AssociateMacSecKeyRequest): AssociateMacSecKeyResponse {
        val op = SdkHttpOperation.build<AssociateMacSecKeyRequest, AssociateMacSecKeyResponse> {
            serializer = AssociateMacSecKeyOperationSerializer()
            deserializer = AssociateMacSecKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateMacSecKey"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateMacSecKeyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateMacSecKey-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates a virtual interface with a specified link aggregation group (LAG) or connection. Connectivity to Amazon Web Services is temporarily interrupted as the virtual interface is being migrated. If the target connection or LAG has an associated virtual interface with a conflicting VLAN number or a conflicting IP address, the operation fails.
     *
     * Virtual interfaces associated with a hosted connection cannot be associated with a LAG; hosted connections must be migrated along with their virtual interfaces using AssociateHostedConnection.
     *
     * To reassociate a virtual interface to a new connection or LAG, the requester must own either the virtual interface itself or the connection to which the virtual interface is currently associated. Additionally, the requester must own the connection or LAG for the association.
     */
    override suspend fun associateVirtualInterface(input: AssociateVirtualInterfaceRequest): AssociateVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<AssociateVirtualInterfaceRequest, AssociateVirtualInterfaceResponse> {
            serializer = AssociateVirtualInterfaceOperationSerializer()
            deserializer = AssociateVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "AssociateVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AssociateVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AssociateVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Confirms the creation of the specified hosted connection on an interconnect.
     *
     * Upon creation, the hosted connection is initially in the `Ordering` state, and remains in this state until the owner confirms creation of the hosted connection.
     */
    override suspend fun confirmConnection(input: ConfirmConnectionRequest): ConfirmConnectionResponse {
        val op = SdkHttpOperation.build<ConfirmConnectionRequest, ConfirmConnectionResponse> {
            serializer = ConfirmConnectionOperationSerializer()
            deserializer = ConfirmConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ConfirmConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ConfirmConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ConfirmConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * The confirmation of the terms of agreement when creating the connection/link aggregation group (LAG).
     */
    override suspend fun confirmCustomerAgreement(input: ConfirmCustomerAgreementRequest): ConfirmCustomerAgreementResponse {
        val op = SdkHttpOperation.build<ConfirmCustomerAgreementRequest, ConfirmCustomerAgreementResponse> {
            serializer = ConfirmCustomerAgreementOperationSerializer()
            deserializer = ConfirmCustomerAgreementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ConfirmCustomerAgreement"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ConfirmCustomerAgreementRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ConfirmCustomerAgreement-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Accepts ownership of a private virtual interface created by another Amazon Web Services account.
     *
     * After the virtual interface owner makes this call, the virtual interface is created and attached to the specified virtual private gateway or Direct Connect gateway, and is made available to handle traffic.
     */
    override suspend fun confirmPrivateVirtualInterface(input: ConfirmPrivateVirtualInterfaceRequest): ConfirmPrivateVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<ConfirmPrivateVirtualInterfaceRequest, ConfirmPrivateVirtualInterfaceResponse> {
            serializer = ConfirmPrivateVirtualInterfaceOperationSerializer()
            deserializer = ConfirmPrivateVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ConfirmPrivateVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ConfirmPrivateVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ConfirmPrivateVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Accepts ownership of a public virtual interface created by another Amazon Web Services account.
     *
     * After the virtual interface owner makes this call, the specified virtual interface is created and made available to handle traffic.
     */
    override suspend fun confirmPublicVirtualInterface(input: ConfirmPublicVirtualInterfaceRequest): ConfirmPublicVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<ConfirmPublicVirtualInterfaceRequest, ConfirmPublicVirtualInterfaceResponse> {
            serializer = ConfirmPublicVirtualInterfaceOperationSerializer()
            deserializer = ConfirmPublicVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ConfirmPublicVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ConfirmPublicVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ConfirmPublicVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Accepts ownership of a transit virtual interface created by another Amazon Web Services account.
     *
     *  After the owner of the transit virtual interface makes this call, the specified transit virtual interface is created and made available to handle traffic.
     */
    override suspend fun confirmTransitVirtualInterface(input: ConfirmTransitVirtualInterfaceRequest): ConfirmTransitVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<ConfirmTransitVirtualInterfaceRequest, ConfirmTransitVirtualInterfaceResponse> {
            serializer = ConfirmTransitVirtualInterfaceOperationSerializer()
            deserializer = ConfirmTransitVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ConfirmTransitVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ConfirmTransitVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ConfirmTransitVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a BGP peer on the specified virtual interface.
     *
     * You must create a BGP peer for the corresponding address family (IPv4/IPv6) in order to access Amazon Web Services resources that also use that address family.
     *
     * If logical redundancy is not supported by the connection, interconnect, or LAG, the BGP peer cannot be in the same address family as an existing BGP peer on the virtual interface.
     *
     * When creating a IPv6 BGP peer, omit the Amazon address and customer address. IPv6 addresses are automatically assigned from the Amazon pool of IPv6 addresses; you cannot specify custom IPv6 addresses.
     *
     * If you let Amazon Web Services auto-assign IPv4 addresses, a /30 CIDR will be allocated from 169.254.0.0/16. Amazon Web Services does not recommend this option if you intend to use the customer router peer IP address as the source and destination for traffic. Instead you should use RFC 1918 or other addressing, and specify the address yourself. For more information about RFC 1918 see [ Address Allocation for Private Internets](https://datatracker.ietf.org/doc/html/rfc1918).
     *
     * For a public virtual interface, the Autonomous System Number (ASN) must be private or already on the allow list for the virtual interface.
     */
    override suspend fun createBgpPeer(input: CreateBgpPeerRequest): CreateBgpPeerResponse {
        val op = SdkHttpOperation.build<CreateBgpPeerRequest, CreateBgpPeerResponse> {
            serializer = CreateBGPPeerOperationSerializer()
            deserializer = CreateBGPPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateBGPPeer"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateBgpPeerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateBGPPeer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a connection between a customer network and a specific Direct Connect location.
     *
     * A connection links your internal network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end of the cable is connected to your router, the other to an Direct Connect router.
     *
     * To find the locations for your Region, use DescribeLocations.
     *
     * You can automatically add the new connection to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new connection is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no connection is created.
     */
    override suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse {
        val op = SdkHttpOperation.build<CreateConnectionRequest, CreateConnectionResponse> {
            serializer = CreateConnectionOperationSerializer()
            deserializer = CreateConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual interfaces and virtual private gateways. A Direct Connect gateway is global and visible in any Amazon Web Services Region after it is created. The virtual interfaces and virtual private gateways that are connected through a Direct Connect gateway can be in different Amazon Web Services Regions. This enables you to connect to a VPC in any Region, regardless of the Region in which the virtual interfaces are located, and pass traffic between them.
     */
    override suspend fun createDirectConnectGateway(input: CreateDirectConnectGatewayRequest): CreateDirectConnectGatewayResponse {
        val op = SdkHttpOperation.build<CreateDirectConnectGatewayRequest, CreateDirectConnectGatewayResponse> {
            serializer = CreateDirectConnectGatewayOperationSerializer()
            deserializer = CreateDirectConnectGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateDirectConnectGateway"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateDirectConnectGatewayRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDirectConnectGateway-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.
     */
    override suspend fun createDirectConnectGatewayAssociation(input: CreateDirectConnectGatewayAssociationRequest): CreateDirectConnectGatewayAssociationResponse {
        val op = SdkHttpOperation.build<CreateDirectConnectGatewayAssociationRequest, CreateDirectConnectGatewayAssociationResponse> {
            serializer = CreateDirectConnectGatewayAssociationOperationSerializer()
            deserializer = CreateDirectConnectGatewayAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateDirectConnectGatewayAssociation"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateDirectConnectGatewayAssociationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDirectConnectGatewayAssociation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a proposal to associate the specified virtual private gateway or transit gateway with the specified Direct Connect gateway.
     *
     * You can associate a Direct Connect gateway and virtual private gateway or transit gateway that is owned by any Amazon Web Services account.
     */
    override suspend fun createDirectConnectGatewayAssociationProposal(input: CreateDirectConnectGatewayAssociationProposalRequest): CreateDirectConnectGatewayAssociationProposalResponse {
        val op = SdkHttpOperation.build<CreateDirectConnectGatewayAssociationProposalRequest, CreateDirectConnectGatewayAssociationProposalResponse> {
            serializer = CreateDirectConnectGatewayAssociationProposalOperationSerializer()
            deserializer = CreateDirectConnectGatewayAssociationProposalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateDirectConnectGatewayAssociationProposal"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateDirectConnectGatewayAssociationProposalRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDirectConnectGatewayAssociationProposal-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an interconnect between an Direct Connect Partner's network and a specific Direct Connect location.
     *
     * An interconnect is a connection that is capable of hosting other connections. The Direct Connect Partner can use an interconnect to provide Direct Connect hosted connections to customers through their own network services. Like a standard connection, an interconnect links the partner's network to an Direct Connect location over a standard Ethernet fiber-optic cable. One end is connected to the partner's router, the other to an Direct Connect router.
     *
     * You can automatically add the new interconnect to a link aggregation group (LAG) by specifying a LAG ID in the request. This ensures that the new interconnect is allocated on the same Direct Connect endpoint that hosts the specified LAG. If there are no available ports on the endpoint, the request fails and no interconnect is created.
     *
     * For each end customer, the Direct Connect Partner provisions a connection on their interconnect by calling AllocateHostedConnection. The end customer can then connect to Amazon Web Services resources by creating a virtual interface on their connection, using the VLAN assigned to them by the Direct Connect Partner.
     *
     * Intended for use by Direct Connect Partners only.
     */
    override suspend fun createInterconnect(input: CreateInterconnectRequest): CreateInterconnectResponse {
        val op = SdkHttpOperation.build<CreateInterconnectRequest, CreateInterconnectResponse> {
            serializer = CreateInterconnectOperationSerializer()
            deserializer = CreateInterconnectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateInterconnect"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateInterconnectRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateInterconnect-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a link aggregation group (LAG) with the specified number of bundled physical dedicated connections between the customer network and a specific Direct Connect location. A LAG is a logical interface that uses the Link Aggregation Control Protocol (LACP) to aggregate multiple interfaces, enabling you to treat them as a single interface.
     *
     * All connections in a LAG must use the same bandwidth (either 1Gbps or 10Gbps) and must terminate at the same Direct Connect endpoint.
     *
     * You can have up to 10 dedicated connections per LAG. Regardless of this limit, if you request more connections for the LAG than Direct Connect can allocate on a single endpoint, no LAG is created.
     *
     * You can specify an existing physical dedicated connection or interconnect to include in the LAG (which counts towards the total number of connections). Doing so interrupts the current physical dedicated connection, and re-establishes them as a member of the LAG. The LAG will be created on the same Direct Connect endpoint to which the dedicated connection terminates. Any virtual interfaces associated with the dedicated connection are automatically disassociated and re-associated with the LAG. The connection ID does not change.
     *
     * If the Amazon Web Services account used to create a LAG is a registered Direct Connect Partner, the LAG is automatically enabled to host sub-connections. For a LAG owned by a partner, any associated virtual interfaces cannot be directly configured.
     */
    override suspend fun createLag(input: CreateLagRequest): CreateLagResponse {
        val op = SdkHttpOperation.build<CreateLagRequest, CreateLagResponse> {
            serializer = CreateLagOperationSerializer()
            deserializer = CreateLagOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateLag"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateLagRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateLag-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a private virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A private virtual interface can be connected to either a Direct Connect gateway or a Virtual Private Gateway (VGW). Connecting the private virtual interface to a Direct Connect gateway enables the possibility for connecting to multiple VPCs, including VPCs in different Amazon Web Services Regions. Connecting the private virtual interface to a VGW only provides access to a single VPC within the same Region.
     *
     * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    override suspend fun createPrivateVirtualInterface(input: CreatePrivateVirtualInterfaceRequest): CreatePrivateVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<CreatePrivateVirtualInterfaceRequest, CreatePrivateVirtualInterfaceResponse> {
            serializer = CreatePrivateVirtualInterfaceOperationSerializer()
            deserializer = CreatePrivateVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreatePrivateVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreatePrivateVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreatePrivateVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a public virtual interface. A virtual interface is the VLAN that transports Direct Connect traffic. A public virtual interface supports sending traffic to public services of Amazon Web Services such as Amazon S3.
     *
     * When creating an IPv6 public virtual interface (`addressFamily` is `ipv6`), leave the `customer` and `amazon` address fields blank to use auto-assigned IPv6 space. Custom IPv6 addresses are not supported.
     */
    override suspend fun createPublicVirtualInterface(input: CreatePublicVirtualInterfaceRequest): CreatePublicVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<CreatePublicVirtualInterfaceRequest, CreatePublicVirtualInterfaceResponse> {
            serializer = CreatePublicVirtualInterfaceOperationSerializer()
            deserializer = CreatePublicVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreatePublicVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreatePublicVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreatePublicVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a transit virtual interface. A transit virtual interface should be used to access one or more transit gateways associated with Direct Connect gateways. A transit virtual interface enables the connection of multiple VPCs attached to a transit gateway to a Direct Connect gateway.
     *
     * If you associate your transit gateway with one or more Direct Connect gateways, the Autonomous System Number (ASN) used by the transit gateway and the Direct Connect gateway must be different. For example, if you use the default ASN 64512 for both your the transit gateway and Direct Connect gateway, the association request fails.
     *
     * A jumbo MTU value must be either 1500 or 8500. No other values will be accepted. Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    override suspend fun createTransitVirtualInterface(input: CreateTransitVirtualInterfaceRequest): CreateTransitVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<CreateTransitVirtualInterfaceRequest, CreateTransitVirtualInterfaceResponse> {
            serializer = CreateTransitVirtualInterfaceOperationSerializer()
            deserializer = CreateTransitVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateTransitVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateTransitVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateTransitVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
     *
     * You cannot delete the last BGP peer from a virtual interface.
     */
    override suspend fun deleteBgpPeer(input: DeleteBgpPeerRequest): DeleteBgpPeerResponse {
        val op = SdkHttpOperation.build<DeleteBgpPeerRequest, DeleteBgpPeerResponse> {
            serializer = DeleteBGPPeerOperationSerializer()
            deserializer = DeleteBGPPeerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteBGPPeer"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteBgpPeerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteBGPPeer-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified connection.
     *
     * Deleting a connection only stops the Direct Connect port hour and data transfer charges. If you are partnering with any third parties to connect with the Direct Connect location, you must cancel your service with them separately.
     */
    override suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse {
        val op = SdkHttpOperation.build<DeleteConnectionRequest, DeleteConnectionResponse> {
            serializer = DeleteConnectionOperationSerializer()
            deserializer = DeleteConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified Direct Connect gateway. You must first delete all virtual interfaces that are attached to the Direct Connect gateway and disassociate all virtual private gateways associated with the Direct Connect gateway.
     */
    override suspend fun deleteDirectConnectGateway(input: DeleteDirectConnectGatewayRequest): DeleteDirectConnectGatewayResponse {
        val op = SdkHttpOperation.build<DeleteDirectConnectGatewayRequest, DeleteDirectConnectGatewayResponse> {
            serializer = DeleteDirectConnectGatewayOperationSerializer()
            deserializer = DeleteDirectConnectGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteDirectConnectGateway"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteDirectConnectGatewayRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDirectConnectGateway-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the association between the specified Direct Connect gateway and virtual private gateway.
     *
     * We recommend that you specify the `associationID` to delete the association. Alternatively, if you own virtual gateway and a Direct Connect gateway association, you can specify the `virtualGatewayId` and `directConnectGatewayId` to delete an association.
     */
    override suspend fun deleteDirectConnectGatewayAssociation(input: DeleteDirectConnectGatewayAssociationRequest): DeleteDirectConnectGatewayAssociationResponse {
        val op = SdkHttpOperation.build<DeleteDirectConnectGatewayAssociationRequest, DeleteDirectConnectGatewayAssociationResponse> {
            serializer = DeleteDirectConnectGatewayAssociationOperationSerializer()
            deserializer = DeleteDirectConnectGatewayAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteDirectConnectGatewayAssociation"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteDirectConnectGatewayAssociationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDirectConnectGatewayAssociation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the association proposal request between the specified Direct Connect gateway and virtual private gateway or transit gateway.
     */
    override suspend fun deleteDirectConnectGatewayAssociationProposal(input: DeleteDirectConnectGatewayAssociationProposalRequest): DeleteDirectConnectGatewayAssociationProposalResponse {
        val op = SdkHttpOperation.build<DeleteDirectConnectGatewayAssociationProposalRequest, DeleteDirectConnectGatewayAssociationProposalResponse> {
            serializer = DeleteDirectConnectGatewayAssociationProposalOperationSerializer()
            deserializer = DeleteDirectConnectGatewayAssociationProposalOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteDirectConnectGatewayAssociationProposal"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteDirectConnectGatewayAssociationProposalRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDirectConnectGatewayAssociationProposal-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    override suspend fun deleteInterconnect(input: DeleteInterconnectRequest): DeleteInterconnectResponse {
        val op = SdkHttpOperation.build<DeleteInterconnectRequest, DeleteInterconnectResponse> {
            serializer = DeleteInterconnectOperationSerializer()
            deserializer = DeleteInterconnectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteInterconnect"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteInterconnectRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteInterconnect-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the specified link aggregation group (LAG). You cannot delete a LAG if it has active virtual interfaces or hosted connections.
     */
    override suspend fun deleteLag(input: DeleteLagRequest): DeleteLagResponse {
        val op = SdkHttpOperation.build<DeleteLagRequest, DeleteLagResponse> {
            serializer = DeleteLagOperationSerializer()
            deserializer = DeleteLagOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteLag"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteLagRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteLag-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a virtual interface.
     */
    override suspend fun deleteVirtualInterface(input: DeleteVirtualInterfaceRequest): DeleteVirtualInterfaceResponse {
        val op = SdkHttpOperation.build<DeleteVirtualInterfaceRequest, DeleteVirtualInterfaceResponse> {
            serializer = DeleteVirtualInterfaceOperationSerializer()
            deserializer = DeleteVirtualInterfaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteVirtualInterface"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteVirtualInterfaceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteVirtualInterface-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deprecated. Use DescribeLoa instead.
     *
     * Gets the LOA-CFA for a connection.
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that your APN partner or service provider uses when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeConnectionLoa(input: DescribeConnectionLoaRequest): DescribeConnectionLoaResponse {
        val op = SdkHttpOperation.build<DescribeConnectionLoaRequest, DescribeConnectionLoaResponse> {
            serializer = DescribeConnectionLoaOperationSerializer()
            deserializer = DescribeConnectionLoaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeConnectionLoa"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeConnectionLoaRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeConnectionLoa-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Displays the specified connection or all connections in this Region.
     */
    override suspend fun describeConnections(input: DescribeConnectionsRequest): DescribeConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeConnectionsRequest, DescribeConnectionsResponse> {
            serializer = DescribeConnectionsOperationSerializer()
            deserializer = DescribeConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeConnections"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeConnectionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeConnections-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deprecated. Use DescribeHostedConnections instead.
     *
     * Lists the connections that have been provisioned on the specified interconnect.
     *
     * Intended for use by Direct Connect Partners only.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeConnectionsOnInterconnect(input: DescribeConnectionsOnInterconnectRequest): DescribeConnectionsOnInterconnectResponse {
        val op = SdkHttpOperation.build<DescribeConnectionsOnInterconnectRequest, DescribeConnectionsOnInterconnectResponse> {
            serializer = DescribeConnectionsOnInterconnectOperationSerializer()
            deserializer = DescribeConnectionsOnInterconnectOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeConnectionsOnInterconnect"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeConnectionsOnInterconnectRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeConnectionsOnInterconnect-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get and view a list of customer agreements, along with their signed status and whether the customer is an NNIPartner, NNIPartnerV2, or a nonPartner.
     */
    override suspend fun describeCustomerMetadata(input: DescribeCustomerMetadataRequest): DescribeCustomerMetadataResponse {
        val op = SdkHttpOperation.build<DescribeCustomerMetadataRequest, DescribeCustomerMetadataResponse> {
            serializer = DescribeCustomerMetadataOperationSerializer()
            deserializer = DescribeCustomerMetadataOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeCustomerMetadata"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeCustomerMetadataRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeCustomerMetadata-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes one or more association proposals for connection between a virtual private gateway or transit gateway and a Direct Connect gateway.
     */
    override suspend fun describeDirectConnectGatewayAssociationProposals(input: DescribeDirectConnectGatewayAssociationProposalsRequest): DescribeDirectConnectGatewayAssociationProposalsResponse {
        val op = SdkHttpOperation.build<DescribeDirectConnectGatewayAssociationProposalsRequest, DescribeDirectConnectGatewayAssociationProposalsResponse> {
            serializer = DescribeDirectConnectGatewayAssociationProposalsOperationSerializer()
            deserializer = DescribeDirectConnectGatewayAssociationProposalsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeDirectConnectGatewayAssociationProposals"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeDirectConnectGatewayAssociationProposalsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDirectConnectGatewayAssociationProposals-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the associations between your Direct Connect gateways and virtual private gateways and transit gateways. You must specify one of the following:
     * + A Direct Connect gatewayThe response contains all virtual private gateways and transit gateways associated with the Direct Connect gateway.
     * + A virtual private gatewayThe response contains the Direct Connect gateway.
     * + A transit gatewayThe response contains the Direct Connect gateway.
     * + A Direct Connect gateway and a virtual private gatewayThe response contains the association between the Direct Connect gateway and virtual private gateway.
     * + A Direct Connect gateway and a transit gatewayThe response contains the association between the Direct Connect gateway and transit gateway.
     */
    override suspend fun describeDirectConnectGatewayAssociations(input: DescribeDirectConnectGatewayAssociationsRequest): DescribeDirectConnectGatewayAssociationsResponse {
        val op = SdkHttpOperation.build<DescribeDirectConnectGatewayAssociationsRequest, DescribeDirectConnectGatewayAssociationsResponse> {
            serializer = DescribeDirectConnectGatewayAssociationsOperationSerializer()
            deserializer = DescribeDirectConnectGatewayAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeDirectConnectGatewayAssociations"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeDirectConnectGatewayAssociationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDirectConnectGatewayAssociations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the attachments between your Direct Connect gateways and virtual interfaces. You must specify a Direct Connect gateway, a virtual interface, or both. If you specify a Direct Connect gateway, the response contains all virtual interfaces attached to the Direct Connect gateway. If you specify a virtual interface, the response contains all Direct Connect gateways attached to the virtual interface. If you specify both, the response contains the attachment between the Direct Connect gateway and the virtual interface.
     */
    override suspend fun describeDirectConnectGatewayAttachments(input: DescribeDirectConnectGatewayAttachmentsRequest): DescribeDirectConnectGatewayAttachmentsResponse {
        val op = SdkHttpOperation.build<DescribeDirectConnectGatewayAttachmentsRequest, DescribeDirectConnectGatewayAttachmentsResponse> {
            serializer = DescribeDirectConnectGatewayAttachmentsOperationSerializer()
            deserializer = DescribeDirectConnectGatewayAttachmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeDirectConnectGatewayAttachments"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeDirectConnectGatewayAttachmentsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDirectConnectGatewayAttachments-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all your Direct Connect gateways or only the specified Direct Connect gateway. Deleted Direct Connect gateways are not returned.
     */
    override suspend fun describeDirectConnectGateways(input: DescribeDirectConnectGatewaysRequest): DescribeDirectConnectGatewaysResponse {
        val op = SdkHttpOperation.build<DescribeDirectConnectGatewaysRequest, DescribeDirectConnectGatewaysResponse> {
            serializer = DescribeDirectConnectGatewaysOperationSerializer()
            deserializer = DescribeDirectConnectGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeDirectConnectGateways"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeDirectConnectGatewaysRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDirectConnectGateways-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the hosted connections that have been provisioned on the specified interconnect or link aggregation group (LAG).
     *
     * Intended for use by Direct Connect Partners only.
     */
    override suspend fun describeHostedConnections(input: DescribeHostedConnectionsRequest): DescribeHostedConnectionsResponse {
        val op = SdkHttpOperation.build<DescribeHostedConnectionsRequest, DescribeHostedConnectionsResponse> {
            serializer = DescribeHostedConnectionsOperationSerializer()
            deserializer = DescribeHostedConnectionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeHostedConnections"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeHostedConnectionsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeHostedConnections-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deprecated. Use DescribeLoa instead.
     *
     * Gets the LOA-CFA for the specified interconnect.
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeInterconnectLoa(input: DescribeInterconnectLoaRequest): DescribeInterconnectLoaResponse {
        val op = SdkHttpOperation.build<DescribeInterconnectLoaRequest, DescribeInterconnectLoaResponse> {
            serializer = DescribeInterconnectLoaOperationSerializer()
            deserializer = DescribeInterconnectLoaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeInterconnectLoa"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeInterconnectLoaRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeInterconnectLoa-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the interconnects owned by the Amazon Web Services account or only the specified interconnect.
     */
    override suspend fun describeInterconnects(input: DescribeInterconnectsRequest): DescribeInterconnectsResponse {
        val op = SdkHttpOperation.build<DescribeInterconnectsRequest, DescribeInterconnectsResponse> {
            serializer = DescribeInterconnectsOperationSerializer()
            deserializer = DescribeInterconnectsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeInterconnects"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeInterconnectsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeInterconnects-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes all your link aggregation groups (LAG) or the specified LAG.
     */
    override suspend fun describeLags(input: DescribeLagsRequest): DescribeLagsResponse {
        val op = SdkHttpOperation.build<DescribeLagsRequest, DescribeLagsResponse> {
            serializer = DescribeLagsOperationSerializer()
            deserializer = DescribeLagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeLags"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeLagsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeLags-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
     *
     * The Letter of Authorization - Connecting Facility Assignment (LOA-CFA) is a document that is used when establishing your cross connect to Amazon Web Services at the colocation facility. For more information, see [Requesting Cross Connects at Direct Connect Locations](https://docs.aws.amazon.com/directconnect/latest/UserGuide/Colocation.html) in the *Direct Connect User Guide*.
     */
    override suspend fun describeLoa(input: DescribeLoaRequest): DescribeLoaResponse {
        val op = SdkHttpOperation.build<DescribeLoaRequest, DescribeLoaResponse> {
            serializer = DescribeLoaOperationSerializer()
            deserializer = DescribeLoaOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeLoa"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeLoaRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeLoa-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the Direct Connect locations in the current Amazon Web Services Region. These are the locations that can be selected when calling CreateConnection or CreateInterconnect.
     */
    override suspend fun describeLocations(input: DescribeLocationsRequest): DescribeLocationsResponse {
        val op = SdkHttpOperation.build<DescribeLocationsRequest, DescribeLocationsResponse> {
            serializer = DescribeLocationsOperationSerializer()
            deserializer = DescribeLocationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeLocations"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeLocationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeLocations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Details about the router.
     */
    override suspend fun describeRouterConfiguration(input: DescribeRouterConfigurationRequest): DescribeRouterConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeRouterConfigurationRequest, DescribeRouterConfigurationResponse> {
            serializer = DescribeRouterConfigurationOperationSerializer()
            deserializer = DescribeRouterConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeRouterConfiguration"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeRouterConfigurationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeRouterConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the tags associated with the specified Direct Connect resources.
     */
    override suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse {
        val op = SdkHttpOperation.build<DescribeTagsRequest, DescribeTagsResponse> {
            serializer = DescribeTagsOperationSerializer()
            deserializer = DescribeTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeTags"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeTagsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeTags-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the virtual private gateways owned by the Amazon Web Services account.
     *
     * You can create one or more Direct Connect private virtual interfaces linked to a virtual private gateway.
     */
    override suspend fun describeVirtualGateways(input: DescribeVirtualGatewaysRequest): DescribeVirtualGatewaysResponse {
        val op = SdkHttpOperation.build<DescribeVirtualGatewaysRequest, DescribeVirtualGatewaysResponse> {
            serializer = DescribeVirtualGatewaysOperationSerializer()
            deserializer = DescribeVirtualGatewaysOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeVirtualGateways"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeVirtualGatewaysRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeVirtualGateways-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Displays all virtual interfaces for an Amazon Web Services account. Virtual interfaces deleted fewer than 15 minutes before you make the request are also returned. If you specify a connection ID, only the virtual interfaces associated with the connection are returned. If you specify a virtual interface ID, then only a single virtual interface is returned.
     *
     * A virtual interface (VLAN) transmits the traffic between the Direct Connect location and the customer network.
     */
    override suspend fun describeVirtualInterfaces(input: DescribeVirtualInterfacesRequest): DescribeVirtualInterfacesResponse {
        val op = SdkHttpOperation.build<DescribeVirtualInterfacesRequest, DescribeVirtualInterfacesResponse> {
            serializer = DescribeVirtualInterfacesOperationSerializer()
            deserializer = DescribeVirtualInterfacesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DescribeVirtualInterfaces"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeVirtualInterfacesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeVirtualInterfaces-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disassociates a connection from a link aggregation group (LAG). The connection is interrupted and re-established as a standalone connection (the connection is not deleted; to delete the connection, use the DeleteConnection request). If the LAG has associated virtual interfaces or hosted connections, they remain associated with the LAG. A disassociated connection owned by an Direct Connect Partner is automatically converted to an interconnect.
     *
     * If disassociating the connection would cause the LAG to fall below its setting for minimum number of operational connections, the request fails, except when it's the last member of the LAG. If all connections are disassociated, the LAG continues to exist as an empty LAG with no physical connections.
     */
    override suspend fun disassociateConnectionFromLag(input: DisassociateConnectionFromLagRequest): DisassociateConnectionFromLagResponse {
        val op = SdkHttpOperation.build<DisassociateConnectionFromLagRequest, DisassociateConnectionFromLagResponse> {
            serializer = DisassociateConnectionFromLagOperationSerializer()
            deserializer = DisassociateConnectionFromLagOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateConnectionFromLag"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DisassociateConnectionFromLagRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateConnectionFromLag-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the association between a MAC Security (MACsec) security key and an Direct Connect dedicated connection.
     */
    override suspend fun disassociateMacSecKey(input: DisassociateMacSecKeyRequest): DisassociateMacSecKeyResponse {
        val op = SdkHttpOperation.build<DisassociateMacSecKeyRequest, DisassociateMacSecKeyResponse> {
            serializer = DisassociateMacSecKeyOperationSerializer()
            deserializer = DisassociateMacSecKeyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DisassociateMacSecKey"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DisassociateMacSecKeyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DisassociateMacSecKey-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the virtual interface failover test history.
     */
    override suspend fun listVirtualInterfaceTestHistory(input: ListVirtualInterfaceTestHistoryRequest): ListVirtualInterfaceTestHistoryResponse {
        val op = SdkHttpOperation.build<ListVirtualInterfaceTestHistoryRequest, ListVirtualInterfaceTestHistoryResponse> {
            serializer = ListVirtualInterfaceTestHistoryOperationSerializer()
            deserializer = ListVirtualInterfaceTestHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListVirtualInterfaceTestHistory"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListVirtualInterfaceTestHistoryRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListVirtualInterfaceTestHistory-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts the virtual interface failover test that verifies your configuration meets your resiliency requirements by placing the BGP peering session in the DOWN state. You can then send traffic to verify that there are no outages.
     *
     * You can run the test on public, private, transit, and hosted virtual interfaces.
     *
     * You can use [ListVirtualInterfaceTestHistory](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html) to view the virtual interface test history.
     *
     * If you need to stop the test before the test interval completes, use [StopBgpFailoverTest](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html).
     */
    override suspend fun startBgpFailoverTest(input: StartBgpFailoverTestRequest): StartBgpFailoverTestResponse {
        val op = SdkHttpOperation.build<StartBgpFailoverTestRequest, StartBgpFailoverTestResponse> {
            serializer = StartBgpFailoverTestOperationSerializer()
            deserializer = StartBgpFailoverTestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartBgpFailoverTest"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartBgpFailoverTestRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartBgpFailoverTest-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops the virtual interface failover test.
     */
    override suspend fun stopBgpFailoverTest(input: StopBgpFailoverTestRequest): StopBgpFailoverTestResponse {
        val op = SdkHttpOperation.build<StopBgpFailoverTestRequest, StopBgpFailoverTestResponse> {
            serializer = StopBgpFailoverTestOperationSerializer()
            deserializer = StopBgpFailoverTestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopBgpFailoverTest"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StopBgpFailoverTestRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopBgpFailoverTest-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds the specified tags to the specified Direct Connect resource. Each resource can have a maximum of 50 tags.
     *
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes one or more tags from the specified Direct Connect resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the Direct Connect dedicated connection configuration.
     *
     * You can update the following parameters for a connection:
     * + The connection name
     * + The connection's MAC Security (MACsec) encryption mode.
     */
    override suspend fun updateConnection(input: UpdateConnectionRequest): UpdateConnectionResponse {
        val op = SdkHttpOperation.build<UpdateConnectionRequest, UpdateConnectionResponse> {
            serializer = UpdateConnectionOperationSerializer()
            deserializer = UpdateConnectionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateConnection"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateConnectionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateConnection-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the name of a current Direct Connect gateway.
     */
    override suspend fun updateDirectConnectGateway(input: UpdateDirectConnectGatewayRequest): UpdateDirectConnectGatewayResponse {
        val op = SdkHttpOperation.build<UpdateDirectConnectGatewayRequest, UpdateDirectConnectGatewayResponse> {
            serializer = UpdateDirectConnectGatewayOperationSerializer()
            deserializer = UpdateDirectConnectGatewayOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateDirectConnectGateway"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateDirectConnectGatewayRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDirectConnectGateway-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the specified attributes of the Direct Connect gateway association.
     *
     * Add or remove prefixes from the association.
     */
    override suspend fun updateDirectConnectGatewayAssociation(input: UpdateDirectConnectGatewayAssociationRequest): UpdateDirectConnectGatewayAssociationResponse {
        val op = SdkHttpOperation.build<UpdateDirectConnectGatewayAssociationRequest, UpdateDirectConnectGatewayAssociationResponse> {
            serializer = UpdateDirectConnectGatewayAssociationOperationSerializer()
            deserializer = UpdateDirectConnectGatewayAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateDirectConnectGatewayAssociation"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateDirectConnectGatewayAssociationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDirectConnectGatewayAssociation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the attributes of the specified link aggregation group (LAG).
     *
     * You can update the following LAG attributes:
     * + The name of the LAG.
     * + The value for the minimum number of connections that must be operational for the LAG itself to be operational.
     * + The LAG's MACsec encryption mode.Amazon Web Services assigns this value to each connection which is part of the LAG.
     * + The tags
     *
     * If you adjust the threshold value for the minimum number of operational connections, ensure that the new value does not cause the LAG to fall below the threshold and become non-operational.
     */
    override suspend fun updateLag(input: UpdateLagRequest): UpdateLagResponse {
        val op = SdkHttpOperation.build<UpdateLagRequest, UpdateLagResponse> {
            serializer = UpdateLagOperationSerializer()
            deserializer = UpdateLagOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateLag"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateLagRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateLag-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the specified attributes of the specified virtual private interface.
     *
     * Setting the MTU of a virtual interface to 9001 (jumbo frames) can cause an update to the underlying physical connection if it wasn't updated to support jumbo frames. Updating the connection disrupts network connectivity for all virtual interfaces associated with the connection for up to 30 seconds. To check whether your connection supports jumbo frames, call DescribeConnections. To check whether your virtual q interface supports jumbo frames, call DescribeVirtualInterfaces.
     */
    override suspend fun updateVirtualInterfaceAttributes(input: UpdateVirtualInterfaceAttributesRequest): UpdateVirtualInterfaceAttributesResponse {
        val op = SdkHttpOperation.build<UpdateVirtualInterfaceAttributesRequest, UpdateVirtualInterfaceAttributesResponse> {
            serializer = UpdateVirtualInterfaceAttributesOperationSerializer()
            deserializer = UpdateVirtualInterfaceAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateVirtualInterfaceAttributes"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateVirtualInterfaceAttributesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("OvertureService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "directconnect"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateVirtualInterfaceAttributes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "directconnect")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
