// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.directconnect.model.AllocateHostedConnectionResponse
import aws.sdk.kotlin.services.directconnect.model.ConnectionState
import aws.sdk.kotlin.services.directconnect.model.DirectConnectException
import aws.sdk.kotlin.services.directconnect.model.HasLogicalRedundancy
import aws.sdk.kotlin.services.directconnect.model.MacSecKey
import aws.sdk.kotlin.services.directconnect.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class AllocateHostedConnectionOperationDeserializer: HttpDeserialize<AllocateHostedConnectionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AllocateHostedConnectionResponse {
        if (!response.status.isSuccess()) {
            throwAllocateHostedConnectionError(context, response)
        }
        val builder = AllocateHostedConnectionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAllocateHostedConnectionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAllocateHostedConnectionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw DirectConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DirectConnectClientException" -> DirectConnectClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "DirectConnectServerException" -> DirectConnectServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "DuplicateTagKeysException" -> DuplicateTagKeysExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyTagsException" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> DirectConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAllocateHostedConnectionOperationBody(builder: AllocateHostedConnectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AWSDEVICE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsDevice"))
    val AWSDEVICEV2_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsDeviceV2"))
    val AWSLOGICALDEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsLogicalDeviceId"))
    val BANDWIDTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bandwidth"))
    val CONNECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectionId"))
    val CONNECTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectionName"))
    val CONNECTIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectionState"))
    val ENCRYPTIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("encryptionMode"))
    val HASLOGICALREDUNDANCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("hasLogicalRedundancy"))
    val JUMBOFRAMECAPABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("jumboFrameCapable"))
    val LAGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("lagId"))
    val LOAISSUETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("loaIssueTime"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("location"))
    val MACSECCAPABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("macSecCapable"))
    val MACSECKEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("macSecKeys"))
    val OWNERACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ownerAccount"))
    val PARTNERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("partnerName"))
    val PORTENCRYPTIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("portEncryptionStatus"))
    val PROVIDERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("providerName"))
    val REGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("region"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val VLAN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("vlan"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWSDEVICE_DESCRIPTOR)
        field(AWSDEVICEV2_DESCRIPTOR)
        field(AWSLOGICALDEVICEID_DESCRIPTOR)
        field(BANDWIDTH_DESCRIPTOR)
        field(CONNECTIONID_DESCRIPTOR)
        field(CONNECTIONNAME_DESCRIPTOR)
        field(CONNECTIONSTATE_DESCRIPTOR)
        field(ENCRYPTIONMODE_DESCRIPTOR)
        field(HASLOGICALREDUNDANCY_DESCRIPTOR)
        field(JUMBOFRAMECAPABLE_DESCRIPTOR)
        field(LAGID_DESCRIPTOR)
        field(LOAISSUETIME_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(MACSECCAPABLE_DESCRIPTOR)
        field(MACSECKEYS_DESCRIPTOR)
        field(OWNERACCOUNT_DESCRIPTOR)
        field(PARTNERNAME_DESCRIPTOR)
        field(PORTENCRYPTIONSTATUS_DESCRIPTOR)
        field(PROVIDERNAME_DESCRIPTOR)
        field(REGION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VLAN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AWSDEVICE_DESCRIPTOR.index -> builder.awsDevice = deserializeString()
                AWSDEVICEV2_DESCRIPTOR.index -> builder.awsDeviceV2 = deserializeString()
                AWSLOGICALDEVICEID_DESCRIPTOR.index -> builder.awsLogicalDeviceId = deserializeString()
                BANDWIDTH_DESCRIPTOR.index -> builder.bandwidth = deserializeString()
                CONNECTIONID_DESCRIPTOR.index -> builder.connectionId = deserializeString()
                CONNECTIONNAME_DESCRIPTOR.index -> builder.connectionName = deserializeString()
                CONNECTIONSTATE_DESCRIPTOR.index -> builder.connectionState = deserializeString().let { ConnectionState.fromValue(it) }
                ENCRYPTIONMODE_DESCRIPTOR.index -> builder.encryptionMode = deserializeString()
                HASLOGICALREDUNDANCY_DESCRIPTOR.index -> builder.hasLogicalRedundancy = deserializeString().let { HasLogicalRedundancy.fromValue(it) }
                JUMBOFRAMECAPABLE_DESCRIPTOR.index -> builder.jumboFrameCapable = deserializeBoolean()
                LAGID_DESCRIPTOR.index -> builder.lagId = deserializeString()
                LOAISSUETIME_DESCRIPTOR.index -> builder.loaIssueTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeString()
                MACSECCAPABLE_DESCRIPTOR.index -> builder.macSecCapable = deserializeBoolean()
                MACSECKEYS_DESCRIPTOR.index -> builder.macSecKeys =
                    deserializer.deserializeList(MACSECKEYS_DESCRIPTOR) {
                        val col0 = mutableListOf<MacSecKey>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMacSecKeyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OWNERACCOUNT_DESCRIPTOR.index -> builder.ownerAccount = deserializeString()
                PARTNERNAME_DESCRIPTOR.index -> builder.partnerName = deserializeString()
                PORTENCRYPTIONSTATUS_DESCRIPTOR.index -> builder.portEncryptionStatus = deserializeString()
                PROVIDERNAME_DESCRIPTOR.index -> builder.providerName = deserializeString()
                REGION_DESCRIPTOR.index -> builder.region = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VLAN_DESCRIPTOR.index -> builder.vlan = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
