// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



/**
 * Information about the  proposal request to attach a virtual private gateway to a Direct Connect gateway.
 */
class DirectConnectGatewayAssociationProposal private constructor(builder: Builder) {
    /**
     * Information about the associated gateway.
     */
    val associatedGateway: aws.sdk.kotlin.services.directconnect.model.AssociatedGateway? = builder.associatedGateway
    /**
     * The ID of the Direct Connect gateway.
     */
    val directConnectGatewayId: kotlin.String? = builder.directConnectGatewayId
    /**
     * The ID of the Amazon Web Services account that owns the Direct Connect gateway.
     */
    val directConnectGatewayOwnerAccount: kotlin.String? = builder.directConnectGatewayOwnerAccount
    /**
     * The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
     */
    val existingAllowedPrefixesToDirectConnectGateway: List<RouteFilterPrefix>? = builder.existingAllowedPrefixesToDirectConnectGateway
    /**
     * The ID of the association proposal.
     */
    val proposalId: kotlin.String? = builder.proposalId
    /**
     * The state of the proposal. The following are possible values:
     *
     *
     *
     * accepted: The proposal has been accepted. The Direct Connect gateway association is available to use in this state.
     *
     *
     * deleted: The proposal has been deleted by the owner that made the proposal.  The Direct Connect gateway association cannot be used in this state.
     *
     *
     * requested: The proposal has been requested. The Direct Connect gateway association cannot be used in this state.
     */
    val proposalState: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociationProposalState? = builder.proposalState
    /**
     * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
     */
    val requestedAllowedPrefixesToDirectConnectGateway: List<RouteFilterPrefix>? = builder.requestedAllowedPrefixesToDirectConnectGateway

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociationProposal = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DirectConnectGatewayAssociationProposal(")
        append("associatedGateway=$associatedGateway,")
        append("directConnectGatewayId=$directConnectGatewayId,")
        append("directConnectGatewayOwnerAccount=$directConnectGatewayOwnerAccount,")
        append("existingAllowedPrefixesToDirectConnectGateway=$existingAllowedPrefixesToDirectConnectGateway,")
        append("proposalId=$proposalId,")
        append("proposalState=$proposalState,")
        append("requestedAllowedPrefixesToDirectConnectGateway=$requestedAllowedPrefixesToDirectConnectGateway)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedGateway?.hashCode() ?: 0
        result = 31 * result + (directConnectGatewayId?.hashCode() ?: 0)
        result = 31 * result + (directConnectGatewayOwnerAccount?.hashCode() ?: 0)
        result = 31 * result + (existingAllowedPrefixesToDirectConnectGateway?.hashCode() ?: 0)
        result = 31 * result + (proposalId?.hashCode() ?: 0)
        result = 31 * result + (proposalState?.hashCode() ?: 0)
        result = 31 * result + (requestedAllowedPrefixesToDirectConnectGateway?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DirectConnectGatewayAssociationProposal

        if (associatedGateway != other.associatedGateway) return false
        if (directConnectGatewayId != other.directConnectGatewayId) return false
        if (directConnectGatewayOwnerAccount != other.directConnectGatewayOwnerAccount) return false
        if (existingAllowedPrefixesToDirectConnectGateway != other.existingAllowedPrefixesToDirectConnectGateway) return false
        if (proposalId != other.proposalId) return false
        if (proposalState != other.proposalState) return false
        if (requestedAllowedPrefixesToDirectConnectGateway != other.requestedAllowedPrefixesToDirectConnectGateway) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociationProposal = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the associated gateway.
         */
        var associatedGateway: aws.sdk.kotlin.services.directconnect.model.AssociatedGateway? = null
        /**
         * The ID of the Direct Connect gateway.
         */
        var directConnectGatewayId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the Direct Connect gateway.
         */
        var directConnectGatewayOwnerAccount: kotlin.String? = null
        /**
         * The existing Amazon VPC prefixes advertised to the Direct Connect gateway.
         */
        var existingAllowedPrefixesToDirectConnectGateway: List<RouteFilterPrefix>? = null
        /**
         * The ID of the association proposal.
         */
        var proposalId: kotlin.String? = null
        /**
         * The state of the proposal. The following are possible values:
         *
         *
         *
         * accepted: The proposal has been accepted. The Direct Connect gateway association is available to use in this state.
         *
         *
         * deleted: The proposal has been deleted by the owner that made the proposal.  The Direct Connect gateway association cannot be used in this state.
         *
         *
         * requested: The proposal has been requested. The Direct Connect gateway association cannot be used in this state.
         */
        var proposalState: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociationProposalState? = null
        /**
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         */
        var requestedAllowedPrefixesToDirectConnectGateway: List<RouteFilterPrefix>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociationProposal) : this() {
            this.associatedGateway = x.associatedGateway
            this.directConnectGatewayId = x.directConnectGatewayId
            this.directConnectGatewayOwnerAccount = x.directConnectGatewayOwnerAccount
            this.existingAllowedPrefixesToDirectConnectGateway = x.existingAllowedPrefixesToDirectConnectGateway
            this.proposalId = x.proposalId
            this.proposalState = x.proposalState
            this.requestedAllowedPrefixesToDirectConnectGateway = x.requestedAllowedPrefixesToDirectConnectGateway
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayAssociationProposal = DirectConnectGatewayAssociationProposal(this)

        /**
         * construct an [aws.sdk.kotlin.services.directconnect.model.AssociatedGateway] inside the given [block]
         */
        fun associatedGateway(block: aws.sdk.kotlin.services.directconnect.model.AssociatedGateway.Builder.() -> kotlin.Unit) {
            this.associatedGateway = aws.sdk.kotlin.services.directconnect.model.AssociatedGateway.invoke(block)
        }
    }
}
