// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.directconnect.model



/**
 * Information about a Direct Connect gateway, which enables you to connect virtual interfaces and virtual private gateway or transit gateways.
 */
class DirectConnectGateway private constructor(builder: Builder) {
    /**
     * The autonomous system number (ASN) for the Amazon side of the connection.
     */
    val amazonSideAsn: kotlin.Long? = builder.amazonSideAsn
    /**
     * The ID of the Direct Connect gateway.
     */
    val directConnectGatewayId: kotlin.String? = builder.directConnectGatewayId
    /**
     * The name of the Direct Connect gateway.
     */
    val directConnectGatewayName: kotlin.String? = builder.directConnectGatewayName
    /**
     * The state of the Direct Connect gateway. The following are the possible values:
     *
     *
     *
     * pending: The initial state after calling CreateDirectConnectGateway.
     *
     *
     * available: The Direct Connect gateway is ready for use.
     *
     *
     * deleting: The initial state after calling DeleteDirectConnectGateway.
     *
     *
     * deleted: The Direct Connect gateway is deleted and cannot pass traffic.
     */
    val directConnectGatewayState: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayState? = builder.directConnectGatewayState
    /**
     * The ID of the Amazon Web Services account that owns the Direct Connect gateway.
     */
    val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The error message if the state of an object failed to advance.
     */
    val stateChangeError: kotlin.String? = builder.stateChangeError

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.directconnect.model.DirectConnectGateway = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DirectConnectGateway(")
        append("amazonSideAsn=$amazonSideAsn,")
        append("directConnectGatewayId=$directConnectGatewayId,")
        append("directConnectGatewayName=$directConnectGatewayName,")
        append("directConnectGatewayState=$directConnectGatewayState,")
        append("ownerAccount=$ownerAccount,")
        append("stateChangeError=$stateChangeError)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonSideAsn?.hashCode() ?: 0
        result = 31 * result + (directConnectGatewayId?.hashCode() ?: 0)
        result = 31 * result + (directConnectGatewayName?.hashCode() ?: 0)
        result = 31 * result + (directConnectGatewayState?.hashCode() ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (stateChangeError?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DirectConnectGateway

        if (amazonSideAsn != other.amazonSideAsn) return false
        if (directConnectGatewayId != other.directConnectGatewayId) return false
        if (directConnectGatewayName != other.directConnectGatewayName) return false
        if (directConnectGatewayState != other.directConnectGatewayState) return false
        if (ownerAccount != other.ownerAccount) return false
        if (stateChangeError != other.stateChangeError) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.directconnect.model.DirectConnectGateway = Builder(this).apply(block).build()

    class Builder {
        /**
         * The autonomous system number (ASN) for the Amazon side of the connection.
         */
        var amazonSideAsn: kotlin.Long? = null
        /**
         * The ID of the Direct Connect gateway.
         */
        var directConnectGatewayId: kotlin.String? = null
        /**
         * The name of the Direct Connect gateway.
         */
        var directConnectGatewayName: kotlin.String? = null
        /**
         * The state of the Direct Connect gateway. The following are the possible values:
         *
         *
         *
         * pending: The initial state after calling CreateDirectConnectGateway.
         *
         *
         * available: The Direct Connect gateway is ready for use.
         *
         *
         * deleting: The initial state after calling DeleteDirectConnectGateway.
         *
         *
         * deleted: The Direct Connect gateway is deleted and cannot pass traffic.
         */
        var directConnectGatewayState: aws.sdk.kotlin.services.directconnect.model.DirectConnectGatewayState? = null
        /**
         * The ID of the Amazon Web Services account that owns the Direct Connect gateway.
         */
        var ownerAccount: kotlin.String? = null
        /**
         * The error message if the state of an object failed to advance.
         */
        var stateChangeError: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.directconnect.model.DirectConnectGateway) : this() {
            this.amazonSideAsn = x.amazonSideAsn
            this.directConnectGatewayId = x.directConnectGatewayId
            this.directConnectGatewayName = x.directConnectGatewayName
            this.directConnectGatewayState = x.directConnectGatewayState
            this.ownerAccount = x.ownerAccount
            this.stateChangeError = x.stateChangeError
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.directconnect.model.DirectConnectGateway = DirectConnectGateway(this)
    }
}
