// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.serde

import aws.sdk.kotlin.services.devicefarm.model.DeleteTestGridProjectResponse
import aws.sdk.kotlin.services.devicefarm.model.DeviceFarmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteTestGridProjectOperationDeserializer: HttpDeserializer.NonStreaming<DeleteTestGridProjectResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteTestGridProjectResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteTestGridProjectError(context, call, payload)
        }
        val builder = DeleteTestGridProjectResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteTestGridProjectError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DeviceFarmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ArgumentException" -> ArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CannotDeleteException" -> CannotDeleteExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DeviceFarmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
