// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.serde

import aws.sdk.kotlin.services.devicefarm.model.CreateDevicePoolResponse
import aws.sdk.kotlin.services.devicefarm.model.DeviceFarmException
import aws.sdk.kotlin.services.devicefarm.model.DevicePool
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDevicePoolOperationDeserializer: HttpDeserializer.NonStreaming<CreateDevicePoolResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDevicePoolResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDevicePoolError(context, call, payload)
        }
        val builder = CreateDevicePoolResponse.Builder()

        if (payload != null) {
            deserializeCreateDevicePoolOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDevicePoolError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DeviceFarmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ArgumentException" -> ArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceAccountException" -> ServiceAccountExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DeviceFarmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDevicePoolOperationBody(builder: CreateDevicePoolResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEVICEPOOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("devicePool"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICEPOOL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEVICEPOOL_DESCRIPTOR.index -> builder.devicePool = deserializeDevicePoolDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
