// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a request to the update project operation.
 */
public class UpdateProjectRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the project whose name to update.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The number of minutes a test run in the project executes before it times out.
     */
    public val defaultJobTimeoutMinutes: kotlin.Int? = builder.defaultJobTimeoutMinutes
    /**
     * A string that represents the new name of the project that you are updating.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The VPC security groups and subnets that are attached to a project.
     */
    public val vpcConfig: aws.sdk.kotlin.services.devicefarm.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.UpdateProjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateProjectRequest(")
        append("arn=$arn,")
        append("defaultJobTimeoutMinutes=$defaultJobTimeoutMinutes,")
        append("name=$name,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (defaultJobTimeoutMinutes ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateProjectRequest

        if (arn != other.arn) return false
        if (defaultJobTimeoutMinutes != other.defaultJobTimeoutMinutes) return false
        if (name != other.name) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.UpdateProjectRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the project whose name to update.
         */
        public var arn: kotlin.String? = null
        /**
         * The number of minutes a test run in the project executes before it times out.
         */
        public var defaultJobTimeoutMinutes: kotlin.Int? = null
        /**
         * A string that represents the new name of the project that you are updating.
         */
        public var name: kotlin.String? = null
        /**
         * The VPC security groups and subnets that are attached to a project.
         */
        public var vpcConfig: aws.sdk.kotlin.services.devicefarm.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.UpdateProjectRequest) : this() {
            this.arn = x.arn
            this.defaultJobTimeoutMinutes = x.defaultJobTimeoutMinutes
            this.name = x.name
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.UpdateProjectRequest = UpdateProjectRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.devicefarm.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.devicefarm.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
