// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a request to the update device pool operation.
 */
public class UpdateDevicePoolRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Device Farm device pool to update.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Sets whether the `maxDevices` parameter applies to your device pool. If you set this parameter to `true`, the `maxDevices` parameter does not apply, and Device Farm does not limit the number of devices that it adds to your device pool. In this case, Device Farm adds all available devices that meet the criteria specified in the `rules` parameter.
     *
     * If you use this parameter in your request, you cannot use the `maxDevices` parameter in the same request.
     */
    public val clearMaxDevices: kotlin.Boolean? = builder.clearMaxDevices
    /**
     * A description of the device pool to update.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and that meet the criteria that you assign for the `rules` parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.
     *
     * By specifying the maximum number of devices, you can control the costs that you incur by running tests.
     *
     * If you use this parameter in your request, you cannot use the `clearMaxDevices` parameter in the same request.
     */
    public val maxDevices: kotlin.Int? = builder.maxDevices
    /**
     * A string that represents the name of the device pool to update.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your request, the update replaces the existing rules.
     */
    public val rules: List<Rule>? = builder.rules

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.UpdateDevicePoolRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDevicePoolRequest(")
        append("arn=$arn,")
        append("clearMaxDevices=$clearMaxDevices,")
        append("description=$description,")
        append("maxDevices=$maxDevices,")
        append("name=$name,")
        append("rules=$rules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (clearMaxDevices?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (maxDevices ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDevicePoolRequest

        if (arn != other.arn) return false
        if (clearMaxDevices != other.clearMaxDevices) return false
        if (description != other.description) return false
        if (maxDevices != other.maxDevices) return false
        if (name != other.name) return false
        if (rules != other.rules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.UpdateDevicePoolRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Device Farm device pool to update.
         */
        public var arn: kotlin.String? = null
        /**
         * Sets whether the `maxDevices` parameter applies to your device pool. If you set this parameter to `true`, the `maxDevices` parameter does not apply, and Device Farm does not limit the number of devices that it adds to your device pool. In this case, Device Farm adds all available devices that meet the criteria specified in the `rules` parameter.
         *
         * If you use this parameter in your request, you cannot use the `maxDevices` parameter in the same request.
         */
        public var clearMaxDevices: kotlin.Boolean? = null
        /**
         * A description of the device pool to update.
         */
        public var description: kotlin.String? = null
        /**
         * The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and that meet the criteria that you assign for the `rules` parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.
         *
         * By specifying the maximum number of devices, you can control the costs that you incur by running tests.
         *
         * If you use this parameter in your request, you cannot use the `clearMaxDevices` parameter in the same request.
         */
        public var maxDevices: kotlin.Int? = null
        /**
         * A string that represents the name of the device pool to update.
         */
        public var name: kotlin.String? = null
        /**
         * Represents the rules to modify for the device pool. Updating rules is optional. If you update rules for your request, the update replaces the existing rules.
         */
        public var rules: List<Rule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.UpdateDevicePoolRequest) : this() {
            this.arn = x.arn
            this.clearMaxDevices = x.clearMaxDevices
            this.description = x.description
            this.maxDevices = x.maxDevices
            this.name = x.name
            this.rules = x.rules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.UpdateDevicePoolRequest = UpdateDevicePoolRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
