// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the settings for a run. Includes things like location, radio states, auxiliary apps, and network profiles.
 */
public class ScheduleRunConfiguration private constructor(builder: Builder) {
    /**
     * A list of upload ARNs for app packages to be installed with your app.
     */
    public val auxiliaryApps: List<String>? = builder.auxiliaryApps
    /**
     * Specifies the billing method for a test run: `metered` or `unmetered`. If the parameter is not specified, the default value is `metered`.
     *
     * If you have purchased unmetered device slots, you must set this parameter to `unmetered` to make use of them. Otherwise, your run counts against your metered time.
     */
    public val billingMethod: aws.sdk.kotlin.services.devicefarm.model.BillingMethod? = builder.billingMethod
    /**
     * Input `CustomerArtifactPaths` object for the scheduled run configuration.
     */
    public val customerArtifactPaths: aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths? = builder.customerArtifactPaths
    /**
     * The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm extracts to external data for Android or the app's sandbox for iOS.
     */
    public val extraDataPackageArn: kotlin.String? = builder.extraDataPackageArn
    /**
     * Information about the locale that is used for the run.
     */
    public val locale: kotlin.String? = builder.locale
    /**
     * Information about the location that is used for the run.
     */
    public val location: aws.sdk.kotlin.services.devicefarm.model.Location? = builder.location
    /**
     * Reserved for internal use.
     */
    public val networkProfileArn: kotlin.String? = builder.networkProfileArn
    /**
     * Information about the radio states for the run.
     */
    public val radios: aws.sdk.kotlin.services.devicefarm.model.Radios? = builder.radios
    /**
     * An array of ARNs for your VPC endpoint configurations.
     */
    public val vpceConfigurationArns: List<String>? = builder.vpceConfigurationArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.ScheduleRunConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduleRunConfiguration(")
        append("auxiliaryApps=$auxiliaryApps,")
        append("billingMethod=$billingMethod,")
        append("customerArtifactPaths=$customerArtifactPaths,")
        append("extraDataPackageArn=$extraDataPackageArn,")
        append("locale=$locale,")
        append("location=$location,")
        append("networkProfileArn=$networkProfileArn,")
        append("radios=$radios,")
        append("vpceConfigurationArns=$vpceConfigurationArns")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auxiliaryApps?.hashCode() ?: 0
        result = 31 * result + (billingMethod?.hashCode() ?: 0)
        result = 31 * result + (customerArtifactPaths?.hashCode() ?: 0)
        result = 31 * result + (extraDataPackageArn?.hashCode() ?: 0)
        result = 31 * result + (locale?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (networkProfileArn?.hashCode() ?: 0)
        result = 31 * result + (radios?.hashCode() ?: 0)
        result = 31 * result + (vpceConfigurationArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduleRunConfiguration

        if (auxiliaryApps != other.auxiliaryApps) return false
        if (billingMethod != other.billingMethod) return false
        if (customerArtifactPaths != other.customerArtifactPaths) return false
        if (extraDataPackageArn != other.extraDataPackageArn) return false
        if (locale != other.locale) return false
        if (location != other.location) return false
        if (networkProfileArn != other.networkProfileArn) return false
        if (radios != other.radios) return false
        if (vpceConfigurationArns != other.vpceConfigurationArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.ScheduleRunConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of upload ARNs for app packages to be installed with your app.
         */
        public var auxiliaryApps: List<String>? = null
        /**
         * Specifies the billing method for a test run: `metered` or `unmetered`. If the parameter is not specified, the default value is `metered`.
         *
         * If you have purchased unmetered device slots, you must set this parameter to `unmetered` to make use of them. Otherwise, your run counts against your metered time.
         */
        public var billingMethod: aws.sdk.kotlin.services.devicefarm.model.BillingMethod? = null
        /**
         * Input `CustomerArtifactPaths` object for the scheduled run configuration.
         */
        public var customerArtifactPaths: aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths? = null
        /**
         * The ARN of the extra data for the run. The extra data is a .zip file that AWS Device Farm extracts to external data for Android or the app's sandbox for iOS.
         */
        public var extraDataPackageArn: kotlin.String? = null
        /**
         * Information about the locale that is used for the run.
         */
        public var locale: kotlin.String? = null
        /**
         * Information about the location that is used for the run.
         */
        public var location: aws.sdk.kotlin.services.devicefarm.model.Location? = null
        /**
         * Reserved for internal use.
         */
        public var networkProfileArn: kotlin.String? = null
        /**
         * Information about the radio states for the run.
         */
        public var radios: aws.sdk.kotlin.services.devicefarm.model.Radios? = null
        /**
         * An array of ARNs for your VPC endpoint configurations.
         */
        public var vpceConfigurationArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.ScheduleRunConfiguration) : this() {
            this.auxiliaryApps = x.auxiliaryApps
            this.billingMethod = x.billingMethod
            this.customerArtifactPaths = x.customerArtifactPaths
            this.extraDataPackageArn = x.extraDataPackageArn
            this.locale = x.locale
            this.location = x.location
            this.networkProfileArn = x.networkProfileArn
            this.radios = x.radios
            this.vpceConfigurationArns = x.vpceConfigurationArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.ScheduleRunConfiguration = ScheduleRunConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths] inside the given [block]
         */
        public fun customerArtifactPaths(block: aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths.Builder.() -> kotlin.Unit) {
            this.customerArtifactPaths = aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.Location] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.devicefarm.model.Location.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.devicefarm.model.Location.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.Radios] inside the given [block]
         */
        public fun radios(block: aws.sdk.kotlin.services.devicefarm.model.Radios.Builder.() -> kotlin.Unit) {
            this.radios = aws.sdk.kotlin.services.devicefarm.model.Radios.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
