// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a test run on a set of devices with a given app package, test parameters, and so on.
 */
public class Run private constructor(builder: Builder) {
    /**
     * An app to upload or that has been uploaded.
     */
    public val appUpload: kotlin.String? = builder.appUpload
    /**
     * The run's ARN.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Specifies the billing method for a test run: `metered` or `unmetered`. If the parameter is not specified, the default value is `metered`.
     *
     * If you have unmetered device slots, you must set this to `unmetered` to use them. Otherwise, the run is counted toward metered device minutes.
     */
    public val billingMethod: aws.sdk.kotlin.services.devicefarm.model.BillingMethod? = builder.billingMethod
    /**
     * The total number of completed jobs.
     */
    public val completedJobs: kotlin.Int? = builder.completedJobs
    /**
     * The run's result counters.
     */
    public val counters: aws.sdk.kotlin.services.devicefarm.model.Counters? = builder.counters
    /**
     * When the run was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * Output `CustomerArtifactPaths` object for the test run.
     */
    public val customerArtifactPaths: aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths? = builder.customerArtifactPaths
    /**
     * Represents the total (metered or unmetered) minutes used by the test run.
     */
    public val deviceMinutes: aws.sdk.kotlin.services.devicefarm.model.DeviceMinutes? = builder.deviceMinutes
    /**
     * The ARN of the device pool for the run.
     */
    public val devicePoolArn: kotlin.String? = builder.devicePoolArn
    /**
     * The results of a device filter used to select the devices for a test run.
     */
    public val deviceSelectionResult: aws.sdk.kotlin.services.devicefarm.model.DeviceSelectionResult? = builder.deviceSelectionResult
    /**
     * For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz test should perform.
     */
    public val eventCount: kotlin.Int? = builder.eventCount
    /**
     * The number of minutes the job executes before it times out.
     */
    public val jobTimeoutMinutes: kotlin.Int? = builder.jobTimeoutMinutes
    /**
     * Information about the locale that is used for the run.
     */
    public val locale: kotlin.String? = builder.locale
    /**
     * Information about the location that is used for the run.
     */
    public val location: aws.sdk.kotlin.services.devicefarm.model.Location? = builder.location
    /**
     * A message about the run's result.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The run's name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The network profile being used for a test run.
     */
    public val networkProfile: aws.sdk.kotlin.services.devicefarm.model.NetworkProfile? = builder.networkProfile
    /**
     * Read-only URL for an object in an S3 bucket where you can get the parsing results of the test package. If the test package doesn't parse, the reason why it doesn't parse appears in the file that this URL points to.
     */
    public val parsingResultUrl: kotlin.String? = builder.parsingResultUrl
    /**
     * The run's platform.
     *
     * Allowed values include:
     * + ANDROID
     * + IOS
     */
    public val platform: aws.sdk.kotlin.services.devicefarm.model.DevicePlatform? = builder.platform
    /**
     * Information about the radio states for the run.
     */
    public val radios: aws.sdk.kotlin.services.devicefarm.model.Radios? = builder.radios
    /**
     * The run's result.
     *
     * Allowed values include:
     * + PENDING
     * + PASSED
     * + WARNED
     * + FAILED
     * + SKIPPED
     * + ERRORED
     * + STOPPED
     */
    public val result: aws.sdk.kotlin.services.devicefarm.model.ExecutionResult? = builder.result
    /**
     * Supporting field for the result field. Set only if `result` is `SKIPPED`. `PARSING_FAILED` if the result is skipped because of test package parsing failure.
     */
    public val resultCode: aws.sdk.kotlin.services.devicefarm.model.ExecutionResultCode? = builder.resultCode
    /**
     * For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures identical event sequences.
     */
    public val seed: kotlin.Int? = builder.seed
    /**
     * When set to `true`, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again.
     *
     * For more information about how Device Farm re-signs your apps, see [Do you modify my app?](http://aws.amazon.com/device-farm/faqs/) in the *AWS Device Farm FAQs*.
     */
    public val skipAppResign: kotlin.Boolean? = builder.skipAppResign
    /**
     * The run's start time.
     */
    public val started: aws.smithy.kotlin.runtime.time.Instant? = builder.started
    /**
     * The run's status.
     *
     * Allowed values include:
     * + PENDING
     * + PENDING_CONCURRENCY
     * + PENDING_DEVICE
     * + PROCESSING
     * + SCHEDULING
     * + PREPARING
     * + RUNNING
     * + COMPLETED
     * + STOPPING
     */
    public val status: aws.sdk.kotlin.services.devicefarm.model.ExecutionStatus? = builder.status
    /**
     * The run's stop time.
     */
    public val stopped: aws.smithy.kotlin.runtime.time.Instant? = builder.stopped
    /**
     * The ARN of the YAML-formatted test specification for the run.
     */
    public val testSpecArn: kotlin.String? = builder.testSpecArn
    /**
     * The total number of jobs for the run.
     */
    public val totalJobs: kotlin.Int? = builder.totalJobs
    /**
     * The run's type.
     *
     * Must be one of the following values:
     * + BUILTIN_FUZZ
     * + APPIUM_JAVA_JUNIT
     * + APPIUM_JAVA_TESTNG
     * + APPIUM_PYTHON
     * + APPIUM_NODE
     * + APPIUM_RUBY
     * + APPIUM_WEB_JAVA_JUNIT
     * + APPIUM_WEB_JAVA_TESTNG
     * + APPIUM_WEB_PYTHON
     * + APPIUM_WEB_NODE
     * + APPIUM_WEB_RUBY
     * + INSTRUMENTATION
     * + XCTEST
     * + XCTEST_UI
     */
    public val type: aws.sdk.kotlin.services.devicefarm.model.TestType? = builder.type
    /**
     * The VPC security groups and subnets that are attached to a project.
     */
    public val vpcConfig: aws.sdk.kotlin.services.devicefarm.model.VpcConfig? = builder.vpcConfig
    /**
     * The Device Farm console URL for the recording of the run.
     */
    public val webUrl: kotlin.String? = builder.webUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.Run = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Run(")
        append("appUpload=$appUpload,")
        append("arn=$arn,")
        append("billingMethod=$billingMethod,")
        append("completedJobs=$completedJobs,")
        append("counters=$counters,")
        append("created=$created,")
        append("customerArtifactPaths=$customerArtifactPaths,")
        append("deviceMinutes=$deviceMinutes,")
        append("devicePoolArn=$devicePoolArn,")
        append("deviceSelectionResult=$deviceSelectionResult,")
        append("eventCount=$eventCount,")
        append("jobTimeoutMinutes=$jobTimeoutMinutes,")
        append("locale=$locale,")
        append("location=$location,")
        append("message=$message,")
        append("name=$name,")
        append("networkProfile=$networkProfile,")
        append("parsingResultUrl=$parsingResultUrl,")
        append("platform=$platform,")
        append("radios=$radios,")
        append("result=$result,")
        append("resultCode=$resultCode,")
        append("seed=$seed,")
        append("skipAppResign=$skipAppResign,")
        append("started=$started,")
        append("status=$status,")
        append("stopped=$stopped,")
        append("testSpecArn=$testSpecArn,")
        append("totalJobs=$totalJobs,")
        append("type=$type,")
        append("vpcConfig=$vpcConfig,")
        append("webUrl=$webUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appUpload?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (billingMethod?.hashCode() ?: 0)
        result = 31 * result + (completedJobs ?: 0)
        result = 31 * result + (counters?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (customerArtifactPaths?.hashCode() ?: 0)
        result = 31 * result + (deviceMinutes?.hashCode() ?: 0)
        result = 31 * result + (devicePoolArn?.hashCode() ?: 0)
        result = 31 * result + (deviceSelectionResult?.hashCode() ?: 0)
        result = 31 * result + (eventCount ?: 0)
        result = 31 * result + (jobTimeoutMinutes ?: 0)
        result = 31 * result + (locale?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkProfile?.hashCode() ?: 0)
        result = 31 * result + (parsingResultUrl?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (radios?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        result = 31 * result + (resultCode?.hashCode() ?: 0)
        result = 31 * result + (seed ?: 0)
        result = 31 * result + (skipAppResign?.hashCode() ?: 0)
        result = 31 * result + (started?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stopped?.hashCode() ?: 0)
        result = 31 * result + (testSpecArn?.hashCode() ?: 0)
        result = 31 * result + (totalJobs ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        result = 31 * result + (webUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Run

        if (appUpload != other.appUpload) return false
        if (arn != other.arn) return false
        if (billingMethod != other.billingMethod) return false
        if (completedJobs != other.completedJobs) return false
        if (counters != other.counters) return false
        if (created != other.created) return false
        if (customerArtifactPaths != other.customerArtifactPaths) return false
        if (deviceMinutes != other.deviceMinutes) return false
        if (devicePoolArn != other.devicePoolArn) return false
        if (deviceSelectionResult != other.deviceSelectionResult) return false
        if (eventCount != other.eventCount) return false
        if (jobTimeoutMinutes != other.jobTimeoutMinutes) return false
        if (locale != other.locale) return false
        if (location != other.location) return false
        if (message != other.message) return false
        if (name != other.name) return false
        if (networkProfile != other.networkProfile) return false
        if (parsingResultUrl != other.parsingResultUrl) return false
        if (platform != other.platform) return false
        if (radios != other.radios) return false
        if (result != other.result) return false
        if (resultCode != other.resultCode) return false
        if (seed != other.seed) return false
        if (skipAppResign != other.skipAppResign) return false
        if (started != other.started) return false
        if (status != other.status) return false
        if (stopped != other.stopped) return false
        if (testSpecArn != other.testSpecArn) return false
        if (totalJobs != other.totalJobs) return false
        if (type != other.type) return false
        if (vpcConfig != other.vpcConfig) return false
        if (webUrl != other.webUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.Run = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An app to upload or that has been uploaded.
         */
        public var appUpload: kotlin.String? = null
        /**
         * The run's ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * Specifies the billing method for a test run: `metered` or `unmetered`. If the parameter is not specified, the default value is `metered`.
         *
         * If you have unmetered device slots, you must set this to `unmetered` to use them. Otherwise, the run is counted toward metered device minutes.
         */
        public var billingMethod: aws.sdk.kotlin.services.devicefarm.model.BillingMethod? = null
        /**
         * The total number of completed jobs.
         */
        public var completedJobs: kotlin.Int? = null
        /**
         * The run's result counters.
         */
        public var counters: aws.sdk.kotlin.services.devicefarm.model.Counters? = null
        /**
         * When the run was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Output `CustomerArtifactPaths` object for the test run.
         */
        public var customerArtifactPaths: aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths? = null
        /**
         * Represents the total (metered or unmetered) minutes used by the test run.
         */
        public var deviceMinutes: aws.sdk.kotlin.services.devicefarm.model.DeviceMinutes? = null
        /**
         * The ARN of the device pool for the run.
         */
        public var devicePoolArn: kotlin.String? = null
        /**
         * The results of a device filter used to select the devices for a test run.
         */
        public var deviceSelectionResult: aws.sdk.kotlin.services.devicefarm.model.DeviceSelectionResult? = null
        /**
         * For fuzz tests, this is the number of events, between 1 and 10000, that the UI fuzz test should perform.
         */
        public var eventCount: kotlin.Int? = null
        /**
         * The number of minutes the job executes before it times out.
         */
        public var jobTimeoutMinutes: kotlin.Int? = null
        /**
         * Information about the locale that is used for the run.
         */
        public var locale: kotlin.String? = null
        /**
         * Information about the location that is used for the run.
         */
        public var location: aws.sdk.kotlin.services.devicefarm.model.Location? = null
        /**
         * A message about the run's result.
         */
        public var message: kotlin.String? = null
        /**
         * The run's name.
         */
        public var name: kotlin.String? = null
        /**
         * The network profile being used for a test run.
         */
        public var networkProfile: aws.sdk.kotlin.services.devicefarm.model.NetworkProfile? = null
        /**
         * Read-only URL for an object in an S3 bucket where you can get the parsing results of the test package. If the test package doesn't parse, the reason why it doesn't parse appears in the file that this URL points to.
         */
        public var parsingResultUrl: kotlin.String? = null
        /**
         * The run's platform.
         *
         * Allowed values include:
         * + ANDROID
         * + IOS
         */
        public var platform: aws.sdk.kotlin.services.devicefarm.model.DevicePlatform? = null
        /**
         * Information about the radio states for the run.
         */
        public var radios: aws.sdk.kotlin.services.devicefarm.model.Radios? = null
        /**
         * The run's result.
         *
         * Allowed values include:
         * + PENDING
         * + PASSED
         * + WARNED
         * + FAILED
         * + SKIPPED
         * + ERRORED
         * + STOPPED
         */
        public var result: aws.sdk.kotlin.services.devicefarm.model.ExecutionResult? = null
        /**
         * Supporting field for the result field. Set only if `result` is `SKIPPED`. `PARSING_FAILED` if the result is skipped because of test package parsing failure.
         */
        public var resultCode: aws.sdk.kotlin.services.devicefarm.model.ExecutionResultCode? = null
        /**
         * For fuzz tests, this is a seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures identical event sequences.
         */
        public var seed: kotlin.Int? = null
        /**
         * When set to `true`, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again.
         *
         * For more information about how Device Farm re-signs your apps, see [Do you modify my app?](http://aws.amazon.com/device-farm/faqs/) in the *AWS Device Farm FAQs*.
         */
        public var skipAppResign: kotlin.Boolean? = null
        /**
         * The run's start time.
         */
        public var started: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The run's status.
         *
         * Allowed values include:
         * + PENDING
         * + PENDING_CONCURRENCY
         * + PENDING_DEVICE
         * + PROCESSING
         * + SCHEDULING
         * + PREPARING
         * + RUNNING
         * + COMPLETED
         * + STOPPING
         */
        public var status: aws.sdk.kotlin.services.devicefarm.model.ExecutionStatus? = null
        /**
         * The run's stop time.
         */
        public var stopped: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the YAML-formatted test specification for the run.
         */
        public var testSpecArn: kotlin.String? = null
        /**
         * The total number of jobs for the run.
         */
        public var totalJobs: kotlin.Int? = null
        /**
         * The run's type.
         *
         * Must be one of the following values:
         * + BUILTIN_FUZZ
         * + APPIUM_JAVA_JUNIT
         * + APPIUM_JAVA_TESTNG
         * + APPIUM_PYTHON
         * + APPIUM_NODE
         * + APPIUM_RUBY
         * + APPIUM_WEB_JAVA_JUNIT
         * + APPIUM_WEB_JAVA_TESTNG
         * + APPIUM_WEB_PYTHON
         * + APPIUM_WEB_NODE
         * + APPIUM_WEB_RUBY
         * + INSTRUMENTATION
         * + XCTEST
         * + XCTEST_UI
         */
        public var type: aws.sdk.kotlin.services.devicefarm.model.TestType? = null
        /**
         * The VPC security groups and subnets that are attached to a project.
         */
        public var vpcConfig: aws.sdk.kotlin.services.devicefarm.model.VpcConfig? = null
        /**
         * The Device Farm console URL for the recording of the run.
         */
        public var webUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.Run) : this() {
            this.appUpload = x.appUpload
            this.arn = x.arn
            this.billingMethod = x.billingMethod
            this.completedJobs = x.completedJobs
            this.counters = x.counters
            this.created = x.created
            this.customerArtifactPaths = x.customerArtifactPaths
            this.deviceMinutes = x.deviceMinutes
            this.devicePoolArn = x.devicePoolArn
            this.deviceSelectionResult = x.deviceSelectionResult
            this.eventCount = x.eventCount
            this.jobTimeoutMinutes = x.jobTimeoutMinutes
            this.locale = x.locale
            this.location = x.location
            this.message = x.message
            this.name = x.name
            this.networkProfile = x.networkProfile
            this.parsingResultUrl = x.parsingResultUrl
            this.platform = x.platform
            this.radios = x.radios
            this.result = x.result
            this.resultCode = x.resultCode
            this.seed = x.seed
            this.skipAppResign = x.skipAppResign
            this.started = x.started
            this.status = x.status
            this.stopped = x.stopped
            this.testSpecArn = x.testSpecArn
            this.totalJobs = x.totalJobs
            this.type = x.type
            this.vpcConfig = x.vpcConfig
            this.webUrl = x.webUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.Run = Run(this)

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.Counters] inside the given [block]
         */
        public fun counters(block: aws.sdk.kotlin.services.devicefarm.model.Counters.Builder.() -> kotlin.Unit) {
            this.counters = aws.sdk.kotlin.services.devicefarm.model.Counters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths] inside the given [block]
         */
        public fun customerArtifactPaths(block: aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths.Builder.() -> kotlin.Unit) {
            this.customerArtifactPaths = aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.DeviceMinutes] inside the given [block]
         */
        public fun deviceMinutes(block: aws.sdk.kotlin.services.devicefarm.model.DeviceMinutes.Builder.() -> kotlin.Unit) {
            this.deviceMinutes = aws.sdk.kotlin.services.devicefarm.model.DeviceMinutes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.DeviceSelectionResult] inside the given [block]
         */
        public fun deviceSelectionResult(block: aws.sdk.kotlin.services.devicefarm.model.DeviceSelectionResult.Builder.() -> kotlin.Unit) {
            this.deviceSelectionResult = aws.sdk.kotlin.services.devicefarm.model.DeviceSelectionResult.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.Location] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.devicefarm.model.Location.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.devicefarm.model.Location.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.NetworkProfile] inside the given [block]
         */
        public fun networkProfile(block: aws.sdk.kotlin.services.devicefarm.model.NetworkProfile.Builder.() -> kotlin.Unit) {
            this.networkProfile = aws.sdk.kotlin.services.devicefarm.model.NetworkProfile.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.Radios] inside the given [block]
         */
        public fun radios(block: aws.sdk.kotlin.services.devicefarm.model.Radios.Builder.() -> kotlin.Unit) {
            this.radios = aws.sdk.kotlin.services.devicefarm.model.Radios.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.devicefarm.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.devicefarm.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
