// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents information about the remote access session.
 */
public class RemoteAccessSession private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the remote access session.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The billing method of the remote access session. Possible values include `METERED` or `UNMETERED`. For more information about metered devices, see [AWS Device Farm terminology](https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology).
     */
    public val billingMethod: aws.sdk.kotlin.services.devicefarm.model.BillingMethod? = builder.billingMethod
    /**
     * Unique identifier of your client for the remote access session. Only returned if remote debugging is enabled for the remote access session.
     *
     * Remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * The date and time the remote access session was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The device (phone or tablet) used in the remote access session.
     */
    public val device: aws.sdk.kotlin.services.devicefarm.model.Device? = builder.device
    /**
     * The number of minutes a device is used in a remote access session (including setup and teardown minutes).
     */
    public val deviceMinutes: aws.sdk.kotlin.services.devicefarm.model.DeviceMinutes? = builder.deviceMinutes
    /**
     * Unique device identifier for the remote device. Only returned if remote debugging is enabled for the remote access session.
     *
     * Remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
     */
    public val deviceUdid: kotlin.String? = builder.deviceUdid
    /**
     * The endpoint for the remote access sesssion.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * IP address of the EC2 host where you need to connect to remotely debug devices. Only returned if remote debugging is enabled for the remote access session.
     *
     * Remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
     */
    public val hostAddress: kotlin.String? = builder.hostAddress
    /**
     * The ARN of the instance.
     */
    public val instanceArn: kotlin.String? = builder.instanceArn
    /**
     * The interaction mode of the remote access session. Valid values are:
     * + INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot run XCUITest framework-based tests in this mode.
     * + NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the fastest test execution speed. You can run XCUITest framework-based tests in this mode.
     * + VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based tests and watch the screen in this mode.
     */
    public val interactionMode: aws.sdk.kotlin.services.devicefarm.model.InteractionMode? = builder.interactionMode
    /**
     * A message about the remote access session.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The name of the remote access session.
     */
    public val name: kotlin.String? = builder.name
    /**
     * This flag is set to `true` if remote debugging is enabled for the remote access session.
     *
     * Remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
     */
    public val remoteDebugEnabled: kotlin.Boolean? = builder.remoteDebugEnabled
    /**
     * The ARN for the app to be recorded in the remote access session.
     */
    public val remoteRecordAppArn: kotlin.String? = builder.remoteRecordAppArn
    /**
     * This flag is set to `true` if remote recording is enabled for the remote access session.
     */
    public val remoteRecordEnabled: kotlin.Boolean? = builder.remoteRecordEnabled
    /**
     * The result of the remote access session. Can be any of the following:
     * + PENDING.
     * + PASSED.
     * + WARNED.
     * + FAILED.
     * + SKIPPED.
     * + ERRORED.
     * + STOPPED.
     */
    public val result: aws.sdk.kotlin.services.devicefarm.model.ExecutionResult? = builder.result
    /**
     * When set to `true`, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again.
     *
     * For more information about how Device Farm re-signs your apps, see [Do you modify my app?](http://aws.amazon.com/device-farm/faqs/) in the *AWS Device Farm FAQs*.
     */
    public val skipAppResign: kotlin.Boolean? = builder.skipAppResign
    /**
     * The date and time the remote access session was started.
     */
    public val started: aws.smithy.kotlin.runtime.time.Instant? = builder.started
    /**
     * The status of the remote access session. Can be any of the following:
     * + PENDING.
     * + PENDING_CONCURRENCY.
     * + PENDING_DEVICE.
     * + PROCESSING.
     * + SCHEDULING.
     * + PREPARING.
     * + RUNNING.
     * + COMPLETED.
     * + STOPPING.
     */
    public val status: aws.sdk.kotlin.services.devicefarm.model.ExecutionStatus? = builder.status
    /**
     * The date and time the remote access session was stopped.
     */
    public val stopped: aws.smithy.kotlin.runtime.time.Instant? = builder.stopped
    /**
     * The VPC security groups and subnets that are attached to a project.
     */
    public val vpcConfig: aws.sdk.kotlin.services.devicefarm.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.RemoteAccessSession = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RemoteAccessSession(")
        append("arn=$arn,")
        append("billingMethod=$billingMethod,")
        append("clientId=$clientId,")
        append("created=$created,")
        append("device=$device,")
        append("deviceMinutes=$deviceMinutes,")
        append("deviceUdid=$deviceUdid,")
        append("endpoint=$endpoint,")
        append("hostAddress=$hostAddress,")
        append("instanceArn=$instanceArn,")
        append("interactionMode=$interactionMode,")
        append("message=$message,")
        append("name=$name,")
        append("remoteDebugEnabled=$remoteDebugEnabled,")
        append("remoteRecordAppArn=$remoteRecordAppArn,")
        append("remoteRecordEnabled=$remoteRecordEnabled,")
        append("result=$result,")
        append("skipAppResign=$skipAppResign,")
        append("started=$started,")
        append("status=$status,")
        append("stopped=$stopped,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (billingMethod?.hashCode() ?: 0)
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (device?.hashCode() ?: 0)
        result = 31 * result + (deviceMinutes?.hashCode() ?: 0)
        result = 31 * result + (deviceUdid?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (hostAddress?.hashCode() ?: 0)
        result = 31 * result + (instanceArn?.hashCode() ?: 0)
        result = 31 * result + (interactionMode?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (remoteDebugEnabled?.hashCode() ?: 0)
        result = 31 * result + (remoteRecordAppArn?.hashCode() ?: 0)
        result = 31 * result + (remoteRecordEnabled?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        result = 31 * result + (skipAppResign?.hashCode() ?: 0)
        result = 31 * result + (started?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stopped?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RemoteAccessSession

        if (arn != other.arn) return false
        if (billingMethod != other.billingMethod) return false
        if (clientId != other.clientId) return false
        if (created != other.created) return false
        if (device != other.device) return false
        if (deviceMinutes != other.deviceMinutes) return false
        if (deviceUdid != other.deviceUdid) return false
        if (endpoint != other.endpoint) return false
        if (hostAddress != other.hostAddress) return false
        if (instanceArn != other.instanceArn) return false
        if (interactionMode != other.interactionMode) return false
        if (message != other.message) return false
        if (name != other.name) return false
        if (remoteDebugEnabled != other.remoteDebugEnabled) return false
        if (remoteRecordAppArn != other.remoteRecordAppArn) return false
        if (remoteRecordEnabled != other.remoteRecordEnabled) return false
        if (result != other.result) return false
        if (skipAppResign != other.skipAppResign) return false
        if (started != other.started) return false
        if (status != other.status) return false
        if (stopped != other.stopped) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.RemoteAccessSession = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the remote access session.
         */
        public var arn: kotlin.String? = null
        /**
         * The billing method of the remote access session. Possible values include `METERED` or `UNMETERED`. For more information about metered devices, see [AWS Device Farm terminology](https://docs.aws.amazon.com/devicefarm/latest/developerguide/welcome.html#welcome-terminology).
         */
        public var billingMethod: aws.sdk.kotlin.services.devicefarm.model.BillingMethod? = null
        /**
         * Unique identifier of your client for the remote access session. Only returned if remote debugging is enabled for the remote access session.
         *
         * Remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
         */
        public var clientId: kotlin.String? = null
        /**
         * The date and time the remote access session was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The device (phone or tablet) used in the remote access session.
         */
        public var device: aws.sdk.kotlin.services.devicefarm.model.Device? = null
        /**
         * The number of minutes a device is used in a remote access session (including setup and teardown minutes).
         */
        public var deviceMinutes: aws.sdk.kotlin.services.devicefarm.model.DeviceMinutes? = null
        /**
         * Unique device identifier for the remote device. Only returned if remote debugging is enabled for the remote access session.
         *
         * Remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
         */
        public var deviceUdid: kotlin.String? = null
        /**
         * The endpoint for the remote access sesssion.
         */
        public var endpoint: kotlin.String? = null
        /**
         * IP address of the EC2 host where you need to connect to remotely debug devices. Only returned if remote debugging is enabled for the remote access session.
         *
         * Remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
         */
        public var hostAddress: kotlin.String? = null
        /**
         * The ARN of the instance.
         */
        public var instanceArn: kotlin.String? = null
        /**
         * The interaction mode of the remote access session. Valid values are:
         * + INTERACTIVE: You can interact with the iOS device by viewing, touching, and rotating the screen. You cannot run XCUITest framework-based tests in this mode.
         * + NO_VIDEO: You are connected to the device, but cannot interact with it or view the screen. This mode has the fastest test execution speed. You can run XCUITest framework-based tests in this mode.
         * + VIDEO_ONLY: You can view the screen, but cannot touch or rotate it. You can run XCUITest framework-based tests and watch the screen in this mode.
         */
        public var interactionMode: aws.sdk.kotlin.services.devicefarm.model.InteractionMode? = null
        /**
         * A message about the remote access session.
         */
        public var message: kotlin.String? = null
        /**
         * The name of the remote access session.
         */
        public var name: kotlin.String? = null
        /**
         * This flag is set to `true` if remote debugging is enabled for the remote access session.
         *
         * Remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
         */
        public var remoteDebugEnabled: kotlin.Boolean? = null
        /**
         * The ARN for the app to be recorded in the remote access session.
         */
        public var remoteRecordAppArn: kotlin.String? = null
        /**
         * This flag is set to `true` if remote recording is enabled for the remote access session.
         */
        public var remoteRecordEnabled: kotlin.Boolean? = null
        /**
         * The result of the remote access session. Can be any of the following:
         * + PENDING.
         * + PASSED.
         * + WARNED.
         * + FAILED.
         * + SKIPPED.
         * + ERRORED.
         * + STOPPED.
         */
        public var result: aws.sdk.kotlin.services.devicefarm.model.ExecutionResult? = null
        /**
         * When set to `true`, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again.
         *
         * For more information about how Device Farm re-signs your apps, see [Do you modify my app?](http://aws.amazon.com/device-farm/faqs/) in the *AWS Device Farm FAQs*.
         */
        public var skipAppResign: kotlin.Boolean? = null
        /**
         * The date and time the remote access session was started.
         */
        public var started: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the remote access session. Can be any of the following:
         * + PENDING.
         * + PENDING_CONCURRENCY.
         * + PENDING_DEVICE.
         * + PROCESSING.
         * + SCHEDULING.
         * + PREPARING.
         * + RUNNING.
         * + COMPLETED.
         * + STOPPING.
         */
        public var status: aws.sdk.kotlin.services.devicefarm.model.ExecutionStatus? = null
        /**
         * The date and time the remote access session was stopped.
         */
        public var stopped: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The VPC security groups and subnets that are attached to a project.
         */
        public var vpcConfig: aws.sdk.kotlin.services.devicefarm.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.RemoteAccessSession) : this() {
            this.arn = x.arn
            this.billingMethod = x.billingMethod
            this.clientId = x.clientId
            this.created = x.created
            this.device = x.device
            this.deviceMinutes = x.deviceMinutes
            this.deviceUdid = x.deviceUdid
            this.endpoint = x.endpoint
            this.hostAddress = x.hostAddress
            this.instanceArn = x.instanceArn
            this.interactionMode = x.interactionMode
            this.message = x.message
            this.name = x.name
            this.remoteDebugEnabled = x.remoteDebugEnabled
            this.remoteRecordAppArn = x.remoteRecordAppArn
            this.remoteRecordEnabled = x.remoteRecordEnabled
            this.result = x.result
            this.skipAppResign = x.skipAppResign
            this.started = x.started
            this.status = x.status
            this.stopped = x.stopped
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.RemoteAccessSession = RemoteAccessSession(this)

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.Device] inside the given [block]
         */
        public fun device(block: aws.sdk.kotlin.services.devicefarm.model.Device.Builder.() -> kotlin.Unit) {
            this.device = aws.sdk.kotlin.services.devicefarm.model.Device.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.DeviceMinutes] inside the given [block]
         */
        public fun deviceMinutes(block: aws.sdk.kotlin.services.devicefarm.model.DeviceMinutes.Builder.() -> kotlin.Unit) {
            this.deviceMinutes = aws.sdk.kotlin.services.devicefarm.model.DeviceMinutes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.devicefarm.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.devicefarm.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
