// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents configuration information about a test run, such as the execution timeout (in minutes).
 */
public class ExecutionConfiguration private constructor(builder: Builder) {
    /**
     * True if account cleanup is enabled at the beginning of the test. Otherwise, false.
     */
    public val accountsCleanup: kotlin.Boolean? = builder.accountsCleanup
    /**
     * True if app package cleanup is enabled at the beginning of the test. Otherwise, false.
     */
    public val appPackagesCleanup: kotlin.Boolean? = builder.appPackagesCleanup
    /**
     * The number of minutes a test run executes before it times out.
     */
    public val jobTimeoutMinutes: kotlin.Int? = builder.jobTimeoutMinutes
    /**
     * When set to `true`, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again.
     *
     * For more information about how Device Farm re-signs your apps, see [Do you modify my app?](http://aws.amazon.com/device-farm/faqs/) in the *AWS Device Farm FAQs*.
     */
    public val skipAppResign: kotlin.Boolean? = builder.skipAppResign
    /**
     * Set to true to enable video capture. Otherwise, set to false. The default is true.
     */
    public val videoCapture: kotlin.Boolean? = builder.videoCapture

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.ExecutionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecutionConfiguration(")
        append("accountsCleanup=$accountsCleanup,")
        append("appPackagesCleanup=$appPackagesCleanup,")
        append("jobTimeoutMinutes=$jobTimeoutMinutes,")
        append("skipAppResign=$skipAppResign,")
        append("videoCapture=$videoCapture")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountsCleanup?.hashCode() ?: 0
        result = 31 * result + (appPackagesCleanup?.hashCode() ?: 0)
        result = 31 * result + (jobTimeoutMinutes ?: 0)
        result = 31 * result + (skipAppResign?.hashCode() ?: 0)
        result = 31 * result + (videoCapture?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecutionConfiguration

        if (accountsCleanup != other.accountsCleanup) return false
        if (appPackagesCleanup != other.appPackagesCleanup) return false
        if (jobTimeoutMinutes != other.jobTimeoutMinutes) return false
        if (skipAppResign != other.skipAppResign) return false
        if (videoCapture != other.videoCapture) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.ExecutionConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * True if account cleanup is enabled at the beginning of the test. Otherwise, false.
         */
        public var accountsCleanup: kotlin.Boolean? = null
        /**
         * True if app package cleanup is enabled at the beginning of the test. Otherwise, false.
         */
        public var appPackagesCleanup: kotlin.Boolean? = null
        /**
         * The number of minutes a test run executes before it times out.
         */
        public var jobTimeoutMinutes: kotlin.Int? = null
        /**
         * When set to `true`, for private devices, Device Farm does not sign your app again. For public devices, Device Farm always signs your apps again.
         *
         * For more information about how Device Farm re-signs your apps, see [Do you modify my app?](http://aws.amazon.com/device-farm/faqs/) in the *AWS Device Farm FAQs*.
         */
        public var skipAppResign: kotlin.Boolean? = null
        /**
         * Set to true to enable video capture. Otherwise, set to false. The default is true.
         */
        public var videoCapture: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.ExecutionConfiguration) : this() {
            this.accountsCleanup = x.accountsCleanup
            this.appPackagesCleanup = x.appPackagesCleanup
            this.jobTimeoutMinutes = x.jobTimeoutMinutes
            this.skipAppResign = x.skipAppResign
            this.videoCapture = x.videoCapture
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.ExecutionConfiguration = ExecutionConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
