// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a collection of device types.
 */
public class DevicePool private constructor(builder: Builder) {
    /**
     * The device pool's ARN.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The device pool's description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and meet the criteria that you assign for the `rules` parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.
     *
     * By specifying the maximum number of devices, you can control the costs that you incur by running tests.
     */
    public val maxDevices: kotlin.Int? = builder.maxDevices
    /**
     * The device pool's name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Information about the device pool's rules.
     */
    public val rules: List<Rule>? = builder.rules
    /**
     * The device pool's type.
     *
     * Allowed values include:
     * + CURATED: A device pool that is created and managed by AWS Device Farm.
     * + PRIVATE: A device pool that is created and managed by the device pool developer.
     */
    public val type: aws.sdk.kotlin.services.devicefarm.model.DevicePoolType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.DevicePool = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DevicePool(")
        append("arn=$arn,")
        append("description=$description,")
        append("maxDevices=$maxDevices,")
        append("name=$name,")
        append("rules=$rules,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (maxDevices ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DevicePool

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (maxDevices != other.maxDevices) return false
        if (name != other.name) return false
        if (rules != other.rules) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.DevicePool = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The device pool's ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * The device pool's description.
         */
        public var description: kotlin.String? = null
        /**
         * The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and meet the criteria that you assign for the `rules` parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.
         *
         * By specifying the maximum number of devices, you can control the costs that you incur by running tests.
         */
        public var maxDevices: kotlin.Int? = null
        /**
         * The device pool's name.
         */
        public var name: kotlin.String? = null
        /**
         * Information about the device pool's rules.
         */
        public var rules: List<Rule>? = null
        /**
         * The device pool's type.
         *
         * Allowed values include:
         * + CURATED: A device pool that is created and managed by AWS Device Farm.
         * + PRIVATE: A device pool that is created and managed by the device pool developer.
         */
        public var type: aws.sdk.kotlin.services.devicefarm.model.DevicePoolType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.DevicePool) : this() {
            this.arn = x.arn
            this.description = x.description
            this.maxDevices = x.maxDevices
            this.name = x.name
            this.rules = x.rules
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.DevicePool = DevicePool(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
