// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a request to the create device pool operation.
 */
public class CreateDevicePoolRequest private constructor(builder: Builder) {
    /**
     * The device pool's description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and meet the criteria that you assign for the `rules` parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.
     *
     * By specifying the maximum number of devices, you can control the costs that you incur by running tests.
     */
    public val maxDevices: kotlin.Int? = builder.maxDevices
    /**
     * The device pool's name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the project for the device pool.
     */
    public val projectArn: kotlin.String? = builder.projectArn
    /**
     * The device pool's rules.
     */
    public val rules: List<Rule>? = builder.rules

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.CreateDevicePoolRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDevicePoolRequest(")
        append("description=$description,")
        append("maxDevices=$maxDevices,")
        append("name=$name,")
        append("projectArn=$projectArn,")
        append("rules=$rules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (maxDevices ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (projectArn?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDevicePoolRequest

        if (description != other.description) return false
        if (maxDevices != other.maxDevices) return false
        if (name != other.name) return false
        if (projectArn != other.projectArn) return false
        if (rules != other.rules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.CreateDevicePoolRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The device pool's description.
         */
        public var description: kotlin.String? = null
        /**
         * The number of devices that Device Farm can add to your device pool. Device Farm adds devices that are available and meet the criteria that you assign for the `rules` parameter. Depending on how many devices meet these constraints, your device pool might contain fewer devices than the value for this parameter.
         *
         * By specifying the maximum number of devices, you can control the costs that you incur by running tests.
         */
        public var maxDevices: kotlin.Int? = null
        /**
         * The device pool's name.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the project for the device pool.
         */
        public var projectArn: kotlin.String? = null
        /**
         * The device pool's rules.
         */
        public var rules: List<Rule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.CreateDevicePoolRequest) : this() {
            this.description = x.description
            this.maxDevices = x.maxDevices
            this.name = x.name
            this.projectArn = x.projectArn
            this.rules = x.rules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.CreateDevicePoolRequest = CreateDevicePoolRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
