// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.serde

import aws.sdk.kotlin.services.devicefarm.model.DeviceFarmException
import aws.sdk.kotlin.services.devicefarm.model.InstanceProfile
import aws.sdk.kotlin.services.devicefarm.model.UpdateInstanceProfileResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateInstanceProfileOperationDeserializer: HttpDeserialize<UpdateInstanceProfileResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateInstanceProfileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateInstanceProfileError(context, call)
        }
        val builder = UpdateInstanceProfileResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateInstanceProfileOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateInstanceProfileError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DeviceFarmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ArgumentException" -> ArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceAccountException" -> ServiceAccountExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DeviceFarmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateInstanceProfileOperationBody(builder: UpdateInstanceProfileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSTANCEPROFILE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("instanceProfile"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSTANCEPROFILE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCEPROFILE_DESCRIPTOR.index -> builder.instanceProfile = deserializeInstanceProfileDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
