// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.serde

import aws.sdk.kotlin.services.devicefarm.model.DeviceFarmException
import aws.sdk.kotlin.services.devicefarm.model.DevicePoolCompatibilityResult
import aws.sdk.kotlin.services.devicefarm.model.GetDevicePoolCompatibilityResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetDevicePoolCompatibilityOperationDeserializer: HttpDeserialize<GetDevicePoolCompatibilityResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetDevicePoolCompatibilityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDevicePoolCompatibilityError(context, call)
        }
        val builder = GetDevicePoolCompatibilityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDevicePoolCompatibilityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetDevicePoolCompatibilityError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DeviceFarmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ArgumentException" -> ArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceAccountException" -> ServiceAccountExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> DeviceFarmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDevicePoolCompatibilityOperationBody(builder: GetDevicePoolCompatibilityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMPATIBLEDEVICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("compatibleDevices"))
    val INCOMPATIBLEDEVICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("incompatibleDevices"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPATIBLEDEVICES_DESCRIPTOR)
        field(INCOMPATIBLEDEVICES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPATIBLEDEVICES_DESCRIPTOR.index -> builder.compatibleDevices =
                    deserializer.deserializeList(COMPATIBLEDEVICES_DESCRIPTOR) {
                        val col0 = mutableListOf<DevicePoolCompatibilityResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDevicePoolCompatibilityResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INCOMPATIBLEDEVICES_DESCRIPTOR.index -> builder.incompatibleDevices =
                    deserializer.deserializeList(INCOMPATIBLEDEVICES_DESCRIPTOR) {
                        val col0 = mutableListOf<DevicePoolCompatibilityResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDevicePoolCompatibilityResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
