// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.paginators

import aws.sdk.kotlin.services.devicefarm.DeviceFarmClient
import aws.sdk.kotlin.services.devicefarm.model.Artifact
import aws.sdk.kotlin.services.devicefarm.model.Device
import aws.sdk.kotlin.services.devicefarm.model.DevicePool
import aws.sdk.kotlin.services.devicefarm.model.GetOfferingStatusRequest
import aws.sdk.kotlin.services.devicefarm.model.GetOfferingStatusResponse
import aws.sdk.kotlin.services.devicefarm.model.Job
import aws.sdk.kotlin.services.devicefarm.model.ListArtifactsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListArtifactsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListDevicePoolsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListDevicePoolsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListDevicesRequest
import aws.sdk.kotlin.services.devicefarm.model.ListDevicesResponse
import aws.sdk.kotlin.services.devicefarm.model.ListJobsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListJobsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListOfferingTransactionsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListOfferingTransactionsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListOfferingsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListOfferingsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListProjectsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListProjectsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListRunsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListRunsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListSamplesRequest
import aws.sdk.kotlin.services.devicefarm.model.ListSamplesResponse
import aws.sdk.kotlin.services.devicefarm.model.ListSuitesRequest
import aws.sdk.kotlin.services.devicefarm.model.ListSuitesResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridProjectsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridProjectsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionActionsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionActionsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionArtifactsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionArtifactsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTestsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTestsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListUniqueProblemsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListUniqueProblemsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListUploadsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListUploadsResponse
import aws.sdk.kotlin.services.devicefarm.model.Offering
import aws.sdk.kotlin.services.devicefarm.model.OfferingTransaction
import aws.sdk.kotlin.services.devicefarm.model.Project
import aws.sdk.kotlin.services.devicefarm.model.Run
import aws.sdk.kotlin.services.devicefarm.model.Sample
import aws.sdk.kotlin.services.devicefarm.model.Suite
import aws.sdk.kotlin.services.devicefarm.model.Test
import aws.sdk.kotlin.services.devicefarm.model.UniqueProblem
import aws.sdk.kotlin.services.devicefarm.model.Upload
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetOfferingStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetOfferingStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetOfferingStatusResponse]
 */
public fun DeviceFarmClient.getOfferingStatusPaginated(initialRequest: GetOfferingStatusRequest = GetOfferingStatusRequest { }): Flow<GetOfferingStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getOfferingStatusPaginated.getOfferingStatus(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetOfferingStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetOfferingStatusResponse]
 */
public fun DeviceFarmClient.getOfferingStatusPaginated(block: GetOfferingStatusRequest.Builder.() -> Unit): Flow<GetOfferingStatusResponse> =
    getOfferingStatusPaginated(GetOfferingStatusRequest.Builder().apply(block).build())

/**
 * Paginate over [ListArtifactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListArtifactsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListArtifactsResponse]
 */
public fun DeviceFarmClient.listArtifactsPaginated(initialRequest: ListArtifactsRequest): Flow<ListArtifactsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listArtifactsPaginated.listArtifacts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListArtifactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListArtifactsResponse]
 */
public fun DeviceFarmClient.listArtifactsPaginated(block: ListArtifactsRequest.Builder.() -> Unit): Flow<ListArtifactsResponse> =
    listArtifactsPaginated(ListArtifactsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listArtifactsPaginated]
 * to access the nested member [Artifact]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Artifact]
 */
@JvmName("listArtifactsResponseArtifact")
public fun Flow<ListArtifactsResponse>.artifacts(): Flow<Artifact> =
    transform() { response ->
        response.artifacts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDevicePoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDevicePoolsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevicePoolsResponse]
 */
public fun DeviceFarmClient.listDevicePoolsPaginated(initialRequest: ListDevicePoolsRequest): Flow<ListDevicePoolsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDevicePoolsPaginated.listDevicePools(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDevicePoolsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevicePoolsResponse]
 */
public fun DeviceFarmClient.listDevicePoolsPaginated(block: ListDevicePoolsRequest.Builder.() -> Unit): Flow<ListDevicePoolsResponse> =
    listDevicePoolsPaginated(ListDevicePoolsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDevicePoolsPaginated]
 * to access the nested member [DevicePool]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DevicePool]
 */
@JvmName("listDevicePoolsResponseDevicePool")
public fun Flow<ListDevicePoolsResponse>.devicePools(): Flow<DevicePool> =
    transform() { response ->
        response.devicePools?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDevicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevicesResponse]
 */
public fun DeviceFarmClient.listDevicesPaginated(initialRequest: ListDevicesRequest = ListDevicesRequest { }): Flow<ListDevicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDevicesPaginated.listDevices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDevicesResponse]
 */
public fun DeviceFarmClient.listDevicesPaginated(block: ListDevicesRequest.Builder.() -> Unit): Flow<ListDevicesResponse> =
    listDevicesPaginated(ListDevicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDevicesPaginated]
 * to access the nested member [Device]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Device]
 */
@JvmName("listDevicesResponseDevice")
public fun Flow<ListDevicesResponse>.devices(): Flow<Device> =
    transform() { response ->
        response.devices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun DeviceFarmClient.listJobsPaginated(initialRequest: ListJobsRequest): Flow<ListJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobsPaginated.listJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun DeviceFarmClient.listJobsPaginated(block: ListJobsRequest.Builder.() -> Unit): Flow<ListJobsResponse> =
    listJobsPaginated(ListJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobsPaginated]
 * to access the nested member [Job]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Job]
 */
@JvmName("listJobsResponseJob")
public fun Flow<ListJobsResponse>.jobs(): Flow<Job> =
    transform() { response ->
        response.jobs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOfferingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOfferingsResponse]
 */
public fun DeviceFarmClient.listOfferingsPaginated(initialRequest: ListOfferingsRequest = ListOfferingsRequest { }): Flow<ListOfferingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOfferingsPaginated.listOfferings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOfferingsResponse]
 */
public fun DeviceFarmClient.listOfferingsPaginated(block: ListOfferingsRequest.Builder.() -> Unit): Flow<ListOfferingsResponse> =
    listOfferingsPaginated(ListOfferingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOfferingsPaginated]
 * to access the nested member [Offering]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Offering]
 */
@JvmName("listOfferingsResponseOffering")
public fun Flow<ListOfferingsResponse>.offerings(): Flow<Offering> =
    transform() { response ->
        response.offerings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListOfferingTransactionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOfferingTransactionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOfferingTransactionsResponse]
 */
public fun DeviceFarmClient.listOfferingTransactionsPaginated(initialRequest: ListOfferingTransactionsRequest = ListOfferingTransactionsRequest { }): Flow<ListOfferingTransactionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOfferingTransactionsPaginated.listOfferingTransactions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOfferingTransactionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOfferingTransactionsResponse]
 */
public fun DeviceFarmClient.listOfferingTransactionsPaginated(block: ListOfferingTransactionsRequest.Builder.() -> Unit): Flow<ListOfferingTransactionsResponse> =
    listOfferingTransactionsPaginated(ListOfferingTransactionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listOfferingTransactionsPaginated]
 * to access the nested member [OfferingTransaction]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [OfferingTransaction]
 */
@JvmName("listOfferingTransactionsResponseOfferingTransaction")
public fun Flow<ListOfferingTransactionsResponse>.offeringTransactions(): Flow<OfferingTransaction> =
    transform() { response ->
        response.offeringTransactions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun DeviceFarmClient.listProjectsPaginated(initialRequest: ListProjectsRequest = ListProjectsRequest { }): Flow<ListProjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProjectsPaginated.listProjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun DeviceFarmClient.listProjectsPaginated(block: ListProjectsRequest.Builder.() -> Unit): Flow<ListProjectsResponse> =
    listProjectsPaginated(ListProjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProjectsPaginated]
 * to access the nested member [Project]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Project]
 */
@JvmName("listProjectsResponseProject")
public fun Flow<ListProjectsResponse>.projects(): Flow<Project> =
    transform() { response ->
        response.projects?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRunsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRunsResponse]
 */
public fun DeviceFarmClient.listRunsPaginated(initialRequest: ListRunsRequest): Flow<ListRunsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRunsPaginated.listRuns(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRunsResponse]
 */
public fun DeviceFarmClient.listRunsPaginated(block: ListRunsRequest.Builder.() -> Unit): Flow<ListRunsResponse> =
    listRunsPaginated(ListRunsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRunsPaginated]
 * to access the nested member [Run]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Run]
 */
@JvmName("listRunsResponseRun")
public fun Flow<ListRunsResponse>.runs(): Flow<Run> =
    transform() { response ->
        response.runs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSamplesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSamplesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSamplesResponse]
 */
public fun DeviceFarmClient.listSamplesPaginated(initialRequest: ListSamplesRequest): Flow<ListSamplesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSamplesPaginated.listSamples(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSamplesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSamplesResponse]
 */
public fun DeviceFarmClient.listSamplesPaginated(block: ListSamplesRequest.Builder.() -> Unit): Flow<ListSamplesResponse> =
    listSamplesPaginated(ListSamplesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSamplesPaginated]
 * to access the nested member [Sample]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Sample]
 */
@JvmName("listSamplesResponseSample")
public fun Flow<ListSamplesResponse>.samples(): Flow<Sample> =
    transform() { response ->
        response.samples?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSuitesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSuitesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSuitesResponse]
 */
public fun DeviceFarmClient.listSuitesPaginated(initialRequest: ListSuitesRequest): Flow<ListSuitesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSuitesPaginated.listSuites(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSuitesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSuitesResponse]
 */
public fun DeviceFarmClient.listSuitesPaginated(block: ListSuitesRequest.Builder.() -> Unit): Flow<ListSuitesResponse> =
    listSuitesPaginated(ListSuitesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSuitesPaginated]
 * to access the nested member [Suite]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Suite]
 */
@JvmName("listSuitesResponseSuite")
public fun Flow<ListSuitesResponse>.suites(): Flow<Suite> =
    transform() { response ->
        response.suites?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTestGridProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestGridProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestGridProjectsResponse]
 */
public fun DeviceFarmClient.listTestGridProjectsPaginated(initialRequest: ListTestGridProjectsRequest = ListTestGridProjectsRequest { }): Flow<ListTestGridProjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestGridProjectsPaginated.listTestGridProjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestGridProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestGridProjectsResponse]
 */
public fun DeviceFarmClient.listTestGridProjectsPaginated(block: ListTestGridProjectsRequest.Builder.() -> Unit): Flow<ListTestGridProjectsResponse> =
    listTestGridProjectsPaginated(ListTestGridProjectsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTestGridSessionActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestGridSessionActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestGridSessionActionsResponse]
 */
public fun DeviceFarmClient.listTestGridSessionActionsPaginated(initialRequest: ListTestGridSessionActionsRequest): Flow<ListTestGridSessionActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestGridSessionActionsPaginated.listTestGridSessionActions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestGridSessionActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestGridSessionActionsResponse]
 */
public fun DeviceFarmClient.listTestGridSessionActionsPaginated(block: ListTestGridSessionActionsRequest.Builder.() -> Unit): Flow<ListTestGridSessionActionsResponse> =
    listTestGridSessionActionsPaginated(ListTestGridSessionActionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTestGridSessionArtifactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestGridSessionArtifactsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestGridSessionArtifactsResponse]
 */
public fun DeviceFarmClient.listTestGridSessionArtifactsPaginated(initialRequest: ListTestGridSessionArtifactsRequest): Flow<ListTestGridSessionArtifactsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestGridSessionArtifactsPaginated.listTestGridSessionArtifacts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestGridSessionArtifactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestGridSessionArtifactsResponse]
 */
public fun DeviceFarmClient.listTestGridSessionArtifactsPaginated(block: ListTestGridSessionArtifactsRequest.Builder.() -> Unit): Flow<ListTestGridSessionArtifactsResponse> =
    listTestGridSessionArtifactsPaginated(ListTestGridSessionArtifactsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTestGridSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestGridSessionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestGridSessionsResponse]
 */
public fun DeviceFarmClient.listTestGridSessionsPaginated(initialRequest: ListTestGridSessionsRequest): Flow<ListTestGridSessionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestGridSessionsPaginated.listTestGridSessions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestGridSessionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestGridSessionsResponse]
 */
public fun DeviceFarmClient.listTestGridSessionsPaginated(block: ListTestGridSessionsRequest.Builder.() -> Unit): Flow<ListTestGridSessionsResponse> =
    listTestGridSessionsPaginated(ListTestGridSessionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTestsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestsResponse]
 */
public fun DeviceFarmClient.listTestsPaginated(initialRequest: ListTestsRequest): Flow<ListTestsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTestsPaginated.listTests(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTestsResponse]
 */
public fun DeviceFarmClient.listTestsPaginated(block: ListTestsRequest.Builder.() -> Unit): Flow<ListTestsResponse> =
    listTestsPaginated(ListTestsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTestsPaginated]
 * to access the nested member [Test]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Test]
 */
@JvmName("listTestsResponseTest")
public fun Flow<ListTestsResponse>.tests(): Flow<Test> =
    transform() { response ->
        response.tests?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUniqueProblemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUniqueProblemsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUniqueProblemsResponse]
 */
public fun DeviceFarmClient.listUniqueProblemsPaginated(initialRequest: ListUniqueProblemsRequest): Flow<ListUniqueProblemsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUniqueProblemsPaginated.listUniqueProblems(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUniqueProblemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUniqueProblemsResponse]
 */
public fun DeviceFarmClient.listUniqueProblemsPaginated(block: ListUniqueProblemsRequest.Builder.() -> Unit): Flow<ListUniqueProblemsResponse> =
    listUniqueProblemsPaginated(ListUniqueProblemsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUniqueProblemsPaginated]
 * to access the nested member [UniqueProblemsByExecutionResultMap]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UniqueProblemsByExecutionResultMap]
 */
@JvmName("listUniqueProblemsResponseUniqueProblemsByExecutionResultMap")
public fun Flow<ListUniqueProblemsResponse>.uniqueProblems(): Flow<Map.Entry<String, List<UniqueProblem>>> =
    transform() { response ->
        response.uniqueProblems?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUploadsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUploadsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUploadsResponse]
 */
public fun DeviceFarmClient.listUploadsPaginated(initialRequest: ListUploadsRequest): Flow<ListUploadsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUploadsPaginated.listUploads(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUploadsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUploadsResponse]
 */
public fun DeviceFarmClient.listUploadsPaginated(block: ListUploadsRequest.Builder.() -> Unit): Flow<ListUploadsResponse> =
    listUploadsPaginated(ListUploadsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUploadsPaginated]
 * to access the nested member [Upload]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Upload]
 */
@JvmName("listUploadsResponseUpload")
public fun Flow<ListUploadsResponse>.uploads(): Flow<Upload> =
    transform() { response ->
        response.uploads?.forEach {
            emit(it)
        }
    }
