// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model



/**
 * Represents test settings. This data structure is passed in as the test parameter to ScheduleRun. For an example of the JSON request syntax, see ScheduleRun.
 */
public class ScheduleRunTest private constructor(builder: Builder) {
    /**
     * The test's filter.
     */
    public val filter: kotlin.String? = builder.filter
    /**
     * The test's parameters, such as test framework parameters and fixture settings. Parameters are represented by name-value pairs of strings.
     *
     * For all tests:
     * + `app_performance_monitoring`: Performance monitoring is enabled by default. Set this parameter to false to disable it.
     *
     * For Calabash tests:
     * + profile: A cucumber profile (for example, `my_profile_name`).
     * + tags: You can limit execution to features or scenarios that have (or don't have) certain tags (for example, @smoke or @smoke,~@wip).
     *
     * For Appium tests (all types):
     * + appium_version: The Appium version. Currently supported values are 1.6.5 (and later), latest, and default.
     *    + latest runs the latest Appium version supported by Device Farm (1.9.1).
     *    + For default, Device Farm selects a compatible version of Appium for the device. The current behavior is to run 1.7.2 on Android devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.
     *    + This behavior is subject to change.
     *
     * For fuzz tests (Android only):
     * + event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.
     * + throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.
     * + seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures identical event sequences.
     *
     * For Explorer tests:
     * + username: A user name to use if the Explorer encounters a login form. If not supplied, no user name is inserted.
     * + password: A password to use if the Explorer encounters a login form. If not supplied, no password is inserted.
     *
     * For Instrumentation:
     * + filter: A test filter string. Examples:
     *    + Running a single test case: `com.android.abc.Test1`
     *    + Running a single test: `com.android.abc.Test1#smoke`
     *    + Running multiple tests: `com.android.abc.Test1,com.android.abc.Test2`
     *
     * For XCTest and XCTestUI:
     * + filter: A test filter string. Examples:
     *    + Running a single test class: `LoginTests`
     *    + Running a multiple test classes: `LoginTests,SmokeTests`
     *    + Running a single test: `LoginTests/testValid`
     *    + Running multiple tests: `LoginTests/testValid,LoginTests/testInvalid`
     *
     * For UIAutomator:
     * + filter: A test filter string. Examples:
     *    + Running a single test case: `com.android.abc.Test1`
     *    + Running a single test: `com.android.abc.Test1#smoke`
     *    + Running multiple tests: `com.android.abc.Test1,com.android.abc.Test2`
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * The ARN of the uploaded test to be run.
     */
    public val testPackageArn: kotlin.String? = builder.testPackageArn
    /**
     * The ARN of the YAML-formatted test specification.
     */
    public val testSpecArn: kotlin.String? = builder.testSpecArn
    /**
     * The test's type.
     *
     * Must be one of the following values:
     * + BUILTIN_FUZZ
     * + BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing screenshots at the same time.
     * + APPIUM_JAVA_JUNIT
     * + APPIUM_JAVA_TESTNG
     * + APPIUM_PYTHON
     * + APPIUM_NODE
     * + APPIUM_RUBY
     * + APPIUM_WEB_JAVA_JUNIT
     * + APPIUM_WEB_JAVA_TESTNG
     * + APPIUM_WEB_PYTHON
     * + APPIUM_WEB_NODE
     * + APPIUM_WEB_RUBY
     * + CALABASH
     * + INSTRUMENTATION
     * + UIAUTOMATION
     * + UIAUTOMATOR
     * + XCTEST
     * + XCTEST_UI
     */
    public val type: aws.sdk.kotlin.services.devicefarm.model.TestType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.ScheduleRunTest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduleRunTest(")
        append("filter=$filter,")
        append("parameters=$parameters,")
        append("testPackageArn=$testPackageArn,")
        append("testSpecArn=$testSpecArn,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (testPackageArn?.hashCode() ?: 0)
        result = 31 * result + (testSpecArn?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduleRunTest

        if (filter != other.filter) return false
        if (parameters != other.parameters) return false
        if (testPackageArn != other.testPackageArn) return false
        if (testSpecArn != other.testSpecArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.ScheduleRunTest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The test's filter.
         */
        public var filter: kotlin.String? = null
        /**
         * The test's parameters, such as test framework parameters and fixture settings. Parameters are represented by name-value pairs of strings.
         *
         * For all tests:
         * + `app_performance_monitoring`: Performance monitoring is enabled by default. Set this parameter to false to disable it.
         *
         * For Calabash tests:
         * + profile: A cucumber profile (for example, `my_profile_name`).
         * + tags: You can limit execution to features or scenarios that have (or don't have) certain tags (for example, @smoke or @smoke,~@wip).
         *
         * For Appium tests (all types):
         * + appium_version: The Appium version. Currently supported values are 1.6.5 (and later), latest, and default.
         *    + latest runs the latest Appium version supported by Device Farm (1.9.1).
         *    + For default, Device Farm selects a compatible version of Appium for the device. The current behavior is to run 1.7.2 on Android devices and iOS 9 and earlier and 1.7.2 for iOS 10 and later.
         *    + This behavior is subject to change.
         *
         * For fuzz tests (Android only):
         * + event_count: The number of events, between 1 and 10000, that the UI fuzz test should perform.
         * + throttle: The time, in ms, between 0 and 1000, that the UI fuzz test should wait between events.
         * + seed: A seed to use for randomizing the UI fuzz test. Using the same seed value between tests ensures identical event sequences.
         *
         * For Explorer tests:
         * + username: A user name to use if the Explorer encounters a login form. If not supplied, no user name is inserted.
         * + password: A password to use if the Explorer encounters a login form. If not supplied, no password is inserted.
         *
         * For Instrumentation:
         * + filter: A test filter string. Examples:
         *    + Running a single test case: `com.android.abc.Test1`
         *    + Running a single test: `com.android.abc.Test1#smoke`
         *    + Running multiple tests: `com.android.abc.Test1,com.android.abc.Test2`
         *
         * For XCTest and XCTestUI:
         * + filter: A test filter string. Examples:
         *    + Running a single test class: `LoginTests`
         *    + Running a multiple test classes: `LoginTests,SmokeTests`
         *    + Running a single test: `LoginTests/testValid`
         *    + Running multiple tests: `LoginTests/testValid,LoginTests/testInvalid`
         *
         * For UIAutomator:
         * + filter: A test filter string. Examples:
         *    + Running a single test case: `com.android.abc.Test1`
         *    + Running a single test: `com.android.abc.Test1#smoke`
         *    + Running multiple tests: `com.android.abc.Test1,com.android.abc.Test2`
         */
        public var parameters: Map<String, String>? = null
        /**
         * The ARN of the uploaded test to be run.
         */
        public var testPackageArn: kotlin.String? = null
        /**
         * The ARN of the YAML-formatted test specification.
         */
        public var testSpecArn: kotlin.String? = null
        /**
         * The test's type.
         *
         * Must be one of the following values:
         * + BUILTIN_FUZZ
         * + BUILTIN_EXPLORER. For Android, an app explorer that traverses an Android app, interacting with it and capturing screenshots at the same time.
         * + APPIUM_JAVA_JUNIT
         * + APPIUM_JAVA_TESTNG
         * + APPIUM_PYTHON
         * + APPIUM_NODE
         * + APPIUM_RUBY
         * + APPIUM_WEB_JAVA_JUNIT
         * + APPIUM_WEB_JAVA_TESTNG
         * + APPIUM_WEB_PYTHON
         * + APPIUM_WEB_NODE
         * + APPIUM_WEB_RUBY
         * + CALABASH
         * + INSTRUMENTATION
         * + UIAUTOMATION
         * + UIAUTOMATOR
         * + XCTEST
         * + XCTEST_UI
         */
        public var type: aws.sdk.kotlin.services.devicefarm.model.TestType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.ScheduleRunTest) : this() {
            this.filter = x.filter
            this.parameters = x.parameters
            this.testPackageArn = x.testPackageArn
            this.testSpecArn = x.testSpecArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.ScheduleRunTest = ScheduleRunTest(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = TestType.SdkUnknown("no value provided")
            return this
        }
    }
}
