// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model



/**
 * Represents a sample of performance data.
 */
public class Sample private constructor(builder: Builder) {
    /**
     * The sample's ARN.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The sample's type.
     *
     * Must be one of the following values:
     * + CPU: A CPU sample type. This is expressed as the app processing CPU time (including child processes) as reported by process, as a percentage.
     * + MEMORY: A memory usage sample type. This is expressed as the total proportional set size of an app process, in kilobytes.
     * + NATIVE_AVG_DRAWTIME
     * + NATIVE_FPS
     * + NATIVE_FRAMES
     * + NATIVE_MAX_DRAWTIME
     * + NATIVE_MIN_DRAWTIME
     * + OPENGL_AVG_DRAWTIME
     * + OPENGL_FPS
     * + OPENGL_FRAMES
     * + OPENGL_MAX_DRAWTIME
     * + OPENGL_MIN_DRAWTIME
     * + RX
     * + RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app process.
     * + THREADS: A threads sample type. This is expressed as the total number of threads per app process.
     * + TX
     * + TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app process.
     */
    public val type: aws.sdk.kotlin.services.devicefarm.model.SampleType? = builder.type
    /**
     * The presigned Amazon S3 URL that can be used with a GET request to download the sample's file.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.Sample = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Sample(")
        append("arn=$arn,")
        append("type=$type,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Sample

        if (arn != other.arn) return false
        if (type != other.type) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.Sample = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The sample's ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * The sample's type.
         *
         * Must be one of the following values:
         * + CPU: A CPU sample type. This is expressed as the app processing CPU time (including child processes) as reported by process, as a percentage.
         * + MEMORY: A memory usage sample type. This is expressed as the total proportional set size of an app process, in kilobytes.
         * + NATIVE_AVG_DRAWTIME
         * + NATIVE_FPS
         * + NATIVE_FRAMES
         * + NATIVE_MAX_DRAWTIME
         * + NATIVE_MIN_DRAWTIME
         * + OPENGL_AVG_DRAWTIME
         * + OPENGL_FPS
         * + OPENGL_FRAMES
         * + OPENGL_MAX_DRAWTIME
         * + OPENGL_MIN_DRAWTIME
         * + RX
         * + RX_RATE: The total number of bytes per second (TCP and UDP) that are sent, by app process.
         * + THREADS: A threads sample type. This is expressed as the total number of threads per app process.
         * + TX
         * + TX_RATE: The total number of bytes per second (TCP and UDP) that are received, by app process.
         */
        public var type: aws.sdk.kotlin.services.devicefarm.model.SampleType? = null
        /**
         * The presigned Amazon S3 URL that can be used with a GET request to download the sample's file.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.Sample) : this() {
            this.arn = x.arn
            this.type = x.type
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.Sample = Sample(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
