// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model



/**
 * Represents a condition for a device pool.
 */
public class Rule private constructor(builder: Builder) {
    /**
     * The rule's stringified attribute. For example, specify the value as `"\"abc\""`.
     *
     * The supported operators for each attribute are provided in the following list.
     *
     * ## APPIUM_VERSION
     * The Appium version for the test.
     *
     * Supported operators: `CONTAINS`
     *
     * ## ARN
     * The Amazon Resource Name (ARN) of the device (for example, `arn:aws:devicefarm:us-west-2::device:12345Example`.
     *
     * Supported operators: `EQUALS`, `IN`, `NOT_IN`
     *
     * ## AVAILABILITY
     * The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
     *
     * Supported operators: `EQUALS`
     *
     * ## FLEET_TYPE
     * The fleet type. Valid values are PUBLIC or PRIVATE.
     *
     * Supported operators: `EQUALS`
     *
     * ## FORM_FACTOR
     * The device form factor. Valid values are PHONE or TABLET.
     *
     * Supported operators: `EQUALS`, `IN`, `NOT_IN`
     *
     * ## INSTANCE_ARN
     * The Amazon Resource Name (ARN) of the device instance.
     *
     * Supported operators: `IN`, `NOT_IN`
     *
     * ## INSTANCE_LABELS
     * The label of the device instance.
     *
     * Supported operators: `CONTAINS`
     *
     * ## MANUFACTURER
     * The device manufacturer (for example, Apple).
     *
     * Supported operators: `EQUALS`, `IN`, `NOT_IN`
     *
     * ## MODEL
     * The device model, such as Apple iPad Air 2 or Google Pixel.
     *
     * Supported operators: `CONTAINS`, `EQUALS`, `IN`, `NOT_IN`
     *
     * ## OS_VERSION
     * The operating system version (for example, 10.3.2).
     *
     * Supported operators: `EQUALS`, `GREATER_THAN`, `GREATER_THAN_OR_EQUALS`, `IN`, `LESS_THAN`, `LESS_THAN_OR_EQUALS`, `NOT_IN`
     *
     * ## PLATFORM
     * The device platform. Valid values are ANDROID or IOS.
     *
     * Supported operators: `EQUALS`, `IN`, `NOT_IN`
     *
     * ## REMOTE_ACCESS_ENABLED
     * Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
     *
     * Supported operators: `EQUALS`
     *
     * ## REMOTE_DEBUG_ENABLED
     * Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
     *
     * Supported operators: `EQUALS`
     *
     * Because remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html), this filter is ignored.
     */
    public val attribute: aws.sdk.kotlin.services.devicefarm.model.DeviceAttribute? = builder.attribute
    /**
     * Specifies how Device Farm compares the rule's attribute to the value. For the operators that are supported by each attribute, see the attribute descriptions.
     */
    public val operator: aws.sdk.kotlin.services.devicefarm.model.RuleOperator? = builder.operator
    /**
     * The rule's value.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.Rule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Rule(")
        append("attribute=$attribute,")
        append("operator=$operator,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute?.hashCode() ?: 0
        result = 31 * result + (operator?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Rule

        if (attribute != other.attribute) return false
        if (operator != other.operator) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.Rule = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The rule's stringified attribute. For example, specify the value as `"\"abc\""`.
         *
         * The supported operators for each attribute are provided in the following list.
         *
         * ## APPIUM_VERSION
         * The Appium version for the test.
         *
         * Supported operators: `CONTAINS`
         *
         * ## ARN
         * The Amazon Resource Name (ARN) of the device (for example, `arn:aws:devicefarm:us-west-2::device:12345Example`.
         *
         * Supported operators: `EQUALS`, `IN`, `NOT_IN`
         *
         * ## AVAILABILITY
         * The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
         *
         * Supported operators: `EQUALS`
         *
         * ## FLEET_TYPE
         * The fleet type. Valid values are PUBLIC or PRIVATE.
         *
         * Supported operators: `EQUALS`
         *
         * ## FORM_FACTOR
         * The device form factor. Valid values are PHONE or TABLET.
         *
         * Supported operators: `EQUALS`, `IN`, `NOT_IN`
         *
         * ## INSTANCE_ARN
         * The Amazon Resource Name (ARN) of the device instance.
         *
         * Supported operators: `IN`, `NOT_IN`
         *
         * ## INSTANCE_LABELS
         * The label of the device instance.
         *
         * Supported operators: `CONTAINS`
         *
         * ## MANUFACTURER
         * The device manufacturer (for example, Apple).
         *
         * Supported operators: `EQUALS`, `IN`, `NOT_IN`
         *
         * ## MODEL
         * The device model, such as Apple iPad Air 2 or Google Pixel.
         *
         * Supported operators: `CONTAINS`, `EQUALS`, `IN`, `NOT_IN`
         *
         * ## OS_VERSION
         * The operating system version (for example, 10.3.2).
         *
         * Supported operators: `EQUALS`, `GREATER_THAN`, `GREATER_THAN_OR_EQUALS`, `IN`, `LESS_THAN`, `LESS_THAN_OR_EQUALS`, `NOT_IN`
         *
         * ## PLATFORM
         * The device platform. Valid values are ANDROID or IOS.
         *
         * Supported operators: `EQUALS`, `IN`, `NOT_IN`
         *
         * ## REMOTE_ACCESS_ENABLED
         * Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
         *
         * Supported operators: `EQUALS`
         *
         * ## REMOTE_DEBUG_ENABLED
         * Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
         *
         * Supported operators: `EQUALS`
         *
         * Because remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html), this filter is ignored.
         */
        public var attribute: aws.sdk.kotlin.services.devicefarm.model.DeviceAttribute? = null
        /**
         * Specifies how Device Farm compares the rule's attribute to the value. For the operators that are supported by each attribute, see the attribute descriptions.
         */
        public var operator: aws.sdk.kotlin.services.devicefarm.model.RuleOperator? = null
        /**
         * The rule's value.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.Rule) : this() {
            this.attribute = x.attribute
            this.operator = x.operator
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.Rule = Rule(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
