// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model



/**
 * Represents the result of a list devices request.
 */
public class ListDevicesRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the project.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more values.
     * + Attribute: The aspect of a device such as platform or model used as the selection criteria in a device filter.Allowed values include:
     *    + ARN: The Amazon Resource Name (ARN) of the device (for example, `arn:aws:devicefarm:us-west-2::device:12345Example`).
     *    + PLATFORM: The device platform. Valid values are ANDROID or IOS.
     *    + OS_VERSION: The operating system version (for example, 10.3.2).
     *    + MODEL: The device model (for example, iPad 5th Gen).
     *    + AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
     *    + FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.
     *    + MANUFACTURER: The device manufacturer (for example, Apple).
     *    + REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
     *    + REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE. Because remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html), this attribute is ignored.
     *    + INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
     *    + INSTANCE_LABELS: The label of the device instance.
     *    + FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
     * + Operator: The filter operator.
     *    + The EQUALS operator is available for every attribute except INSTANCE_LABELS.
     *    + The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.
     *    + The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN attributes.
     *    + The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION attribute.
     * + Values: An array of one or more filter values.
     *    + The IN and NOT_IN operators take a values array that has one or more elements.
     *    + The other operators require an array with a single element.
     *    + In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
     */
    public val filters: List<DeviceFilter>? = builder.filters
    /**
     * An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.ListDevicesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDevicesRequest(")
        append("arn=$arn,")
        append("filters=$filters,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDevicesRequest

        if (arn != other.arn) return false
        if (filters != other.filters) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.ListDevicesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the project.
         */
        public var arn: kotlin.String? = null
        /**
         * Used to select a set of devices. A filter is made up of an attribute, an operator, and one or more values.
         * + Attribute: The aspect of a device such as platform or model used as the selection criteria in a device filter.Allowed values include:
         *    + ARN: The Amazon Resource Name (ARN) of the device (for example, `arn:aws:devicefarm:us-west-2::device:12345Example`).
         *    + PLATFORM: The device platform. Valid values are ANDROID or IOS.
         *    + OS_VERSION: The operating system version (for example, 10.3.2).
         *    + MODEL: The device model (for example, iPad 5th Gen).
         *    + AVAILABILITY: The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
         *    + FORM_FACTOR: The device form factor. Valid values are PHONE or TABLET.
         *    + MANUFACTURER: The device manufacturer (for example, Apple).
         *    + REMOTE_ACCESS_ENABLED: Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
         *    + REMOTE_DEBUG_ENABLED: Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE. Because remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html), this attribute is ignored.
         *    + INSTANCE_ARN: The Amazon Resource Name (ARN) of the device instance.
         *    + INSTANCE_LABELS: The label of the device instance.
         *    + FLEET_TYPE: The fleet type. Valid values are PUBLIC or PRIVATE.
         * + Operator: The filter operator.
         *    + The EQUALS operator is available for every attribute except INSTANCE_LABELS.
         *    + The CONTAINS operator is available for the INSTANCE_LABELS and MODEL attributes.
         *    + The IN and NOT_IN operators are available for the ARN, OS_VERSION, MODEL, MANUFACTURER, and INSTANCE_ARN attributes.
         *    + The LESS_THAN, GREATER_THAN, LESS_THAN_OR_EQUALS, and GREATER_THAN_OR_EQUALS operators are also available for the OS_VERSION attribute.
         * + Values: An array of one or more filter values.
         *    + The IN and NOT_IN operators take a values array that has one or more elements.
         *    + The other operators require an array with a single element.
         *    + In a request, the AVAILABILITY attribute takes the following values: AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
         */
        public var filters: List<DeviceFilter>? = null
        /**
         * An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.ListDevicesRequest) : this() {
            this.arn = x.arn
            this.filters = x.filters
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.ListDevicesRequest = ListDevicesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
