// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model



/**
 * Represents the instance profile.
 */
public class InstanceProfile private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the instance profile.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The description of the instance profile.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An array of strings containing the list of app packages that should not be cleaned up from the device after a test run completes.
     *
     * The list of packages is considered only if you set `packageCleanup` to `true`.
     */
    public val excludeAppPackagesFromCleanup: List<String>? = builder.excludeAppPackagesFromCleanup
    /**
     * The name of the instance profile.
     */
    public val name: kotlin.String? = builder.name
    /**
     * When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
     */
    public val packageCleanup: kotlin.Boolean? = builder.packageCleanup
    /**
     * When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
     */
    public val rebootAfterUse: kotlin.Boolean? = builder.rebootAfterUse

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.InstanceProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceProfile(")
        append("arn=$arn,")
        append("description=$description,")
        append("excludeAppPackagesFromCleanup=$excludeAppPackagesFromCleanup,")
        append("name=$name,")
        append("packageCleanup=$packageCleanup,")
        append("rebootAfterUse=$rebootAfterUse")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (excludeAppPackagesFromCleanup?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (packageCleanup?.hashCode() ?: 0)
        result = 31 * result + (rebootAfterUse?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceProfile

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (excludeAppPackagesFromCleanup != other.excludeAppPackagesFromCleanup) return false
        if (name != other.name) return false
        if (packageCleanup != other.packageCleanup) return false
        if (rebootAfterUse != other.rebootAfterUse) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.InstanceProfile = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the instance profile.
         */
        public var arn: kotlin.String? = null
        /**
         * The description of the instance profile.
         */
        public var description: kotlin.String? = null
        /**
         * An array of strings containing the list of app packages that should not be cleaned up from the device after a test run completes.
         *
         * The list of packages is considered only if you set `packageCleanup` to `true`.
         */
        public var excludeAppPackagesFromCleanup: List<String>? = null
        /**
         * The name of the instance profile.
         */
        public var name: kotlin.String? = null
        /**
         * When set to `true`, Device Farm removes app packages after a test run. The default value is `false` for private devices.
         */
        public var packageCleanup: kotlin.Boolean? = null
        /**
         * When set to `true`, Device Farm reboots the instance after a test run. The default value is `true`.
         */
        public var rebootAfterUse: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.InstanceProfile) : this() {
            this.arn = x.arn
            this.description = x.description
            this.excludeAppPackagesFromCleanup = x.excludeAppPackagesFromCleanup
            this.name = x.name
            this.packageCleanup = x.packageCleanup
            this.rebootAfterUse = x.rebootAfterUse
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.InstanceProfile = InstanceProfile(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
