// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model



/**
 * Contains the run results requested by the device selection configuration and how many devices were returned. For an example of the JSON response syntax, see ScheduleRun.
 */
public class DeviceSelectionResult private constructor(builder: Builder) {
    /**
     * The filters in a device selection result.
     */
    public val filters: List<DeviceFilter>? = builder.filters
    /**
     * The number of devices that matched the device filter selection criteria.
     */
    public val matchedDevicesCount: kotlin.Int? = builder.matchedDevicesCount
    /**
     * The maximum number of devices to be selected by a device filter and included in a test run.
     */
    public val maxDevices: kotlin.Int? = builder.maxDevices

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.DeviceSelectionResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceSelectionResult(")
        append("filters=$filters,")
        append("matchedDevicesCount=$matchedDevicesCount,")
        append("maxDevices=$maxDevices")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (matchedDevicesCount ?: 0)
        result = 31 * result + (maxDevices ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeviceSelectionResult

        if (filters != other.filters) return false
        if (matchedDevicesCount != other.matchedDevicesCount) return false
        if (maxDevices != other.maxDevices) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.DeviceSelectionResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filters in a device selection result.
         */
        public var filters: List<DeviceFilter>? = null
        /**
         * The number of devices that matched the device filter selection criteria.
         */
        public var matchedDevicesCount: kotlin.Int? = null
        /**
         * The maximum number of devices to be selected by a device filter and included in a test run.
         */
        public var maxDevices: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.DeviceSelectionResult) : this() {
            this.filters = x.filters
            this.matchedDevicesCount = x.matchedDevicesCount
            this.maxDevices = x.maxDevices
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.DeviceSelectionResult = DeviceSelectionResult(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
