// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model



/**
 * Represents a device filter used to select a set of devices to be included in a test run. This data structure is passed in as the `deviceSelectionConfiguration` parameter to `ScheduleRun`. For an example of the JSON request syntax, see ScheduleRun.
 *
 * It is also passed in as the `filters` parameter to `ListDevices`. For an example of the JSON request syntax, see ListDevices.
 */
public class DeviceFilter private constructor(builder: Builder) {
    /**
     * The aspect of a device such as platform or model used as the selection criteria in a device filter.
     *
     * The supported operators for each attribute are provided in the following list.
     *
     * ## ARN
     * The Amazon Resource Name (ARN) of the device (for example, `arn:aws:devicefarm:us-west-2::device:12345Example`).
     *
     * Supported operators: `EQUALS`, `IN`, `NOT_IN`
     *
     * ## PLATFORM
     * The device platform. Valid values are ANDROID or IOS.
     *
     * Supported operators: `EQUALS`
     *
     * ## OS_VERSION
     * The operating system version (for example, 10.3.2).
     *
     * Supported operators: `EQUALS`, `GREATER_THAN`, `GREATER_THAN_OR_EQUALS`, `IN`, `LESS_THAN`, `LESS_THAN_OR_EQUALS`, `NOT_IN`
     *
     * ## MODEL
     * The device model (for example, iPad 5th Gen).
     *
     * Supported operators: `CONTAINS`, `EQUALS`, `IN`, `NOT_IN`
     *
     * ## AVAILABILITY
     * The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
     *
     * Supported operators: `EQUALS`
     *
     * ## FORM_FACTOR
     * The device form factor. Valid values are PHONE or TABLET.
     *
     * Supported operators: `EQUALS`
     *
     * ## MANUFACTURER
     * The device manufacturer (for example, Apple).
     *
     * Supported operators: `EQUALS`, `IN`, `NOT_IN`
     *
     * ## REMOTE_ACCESS_ENABLED
     * Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
     *
     * Supported operators: `EQUALS`
     *
     * ## REMOTE_DEBUG_ENABLED
     * Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
     *
     * Supported operators: `EQUALS`
     *
     * Because remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html), this filter is ignored.
     *
     * ## INSTANCE_ARN
     * The Amazon Resource Name (ARN) of the device instance.
     *
     * Supported operators: `EQUALS`, `IN`, `NOT_IN`
     *
     * ## INSTANCE_LABELS
     * The label of the device instance.
     *
     * Supported operators: `CONTAINS`
     *
     * ## FLEET_TYPE
     * The fleet type. Valid values are PUBLIC or PRIVATE.
     *
     * Supported operators: `EQUALS`
     */
    public val attribute: aws.sdk.kotlin.services.devicefarm.model.DeviceFilterAttribute = requireNotNull(builder.attribute) { "A non-null value must be provided for attribute" }
    /**
     * Specifies how Device Farm compares the filter's attribute to the value. See the attribute descriptions.
     */
    public val operator: aws.sdk.kotlin.services.devicefarm.model.RuleOperator = requireNotNull(builder.operator) { "A non-null value must be provided for operator" }
    /**
     * An array of one or more filter values used in a device filter.
     *
     * **Operator Values**
     * + The IN and NOT_IN operators can take a values array that has more than one element.
     * + The other operators require an array with a single element.
     *
     * **Attribute Values**
     * + The PLATFORM attribute can be set to ANDROID or IOS.
     * + The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
     * + The FORM_FACTOR attribute can be set to PHONE or TABLET.
     * + The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.DeviceFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceFilter(")
        append("attribute=$attribute,")
        append("operator=$operator,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute.hashCode()
        result = 31 * result + (operator.hashCode())
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeviceFilter

        if (attribute != other.attribute) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.DeviceFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The aspect of a device such as platform or model used as the selection criteria in a device filter.
         *
         * The supported operators for each attribute are provided in the following list.
         *
         * ## ARN
         * The Amazon Resource Name (ARN) of the device (for example, `arn:aws:devicefarm:us-west-2::device:12345Example`).
         *
         * Supported operators: `EQUALS`, `IN`, `NOT_IN`
         *
         * ## PLATFORM
         * The device platform. Valid values are ANDROID or IOS.
         *
         * Supported operators: `EQUALS`
         *
         * ## OS_VERSION
         * The operating system version (for example, 10.3.2).
         *
         * Supported operators: `EQUALS`, `GREATER_THAN`, `GREATER_THAN_OR_EQUALS`, `IN`, `LESS_THAN`, `LESS_THAN_OR_EQUALS`, `NOT_IN`
         *
         * ## MODEL
         * The device model (for example, iPad 5th Gen).
         *
         * Supported operators: `CONTAINS`, `EQUALS`, `IN`, `NOT_IN`
         *
         * ## AVAILABILITY
         * The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
         *
         * Supported operators: `EQUALS`
         *
         * ## FORM_FACTOR
         * The device form factor. Valid values are PHONE or TABLET.
         *
         * Supported operators: `EQUALS`
         *
         * ## MANUFACTURER
         * The device manufacturer (for example, Apple).
         *
         * Supported operators: `EQUALS`, `IN`, `NOT_IN`
         *
         * ## REMOTE_ACCESS_ENABLED
         * Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
         *
         * Supported operators: `EQUALS`
         *
         * ## REMOTE_DEBUG_ENABLED
         * Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
         *
         * Supported operators: `EQUALS`
         *
         * Because remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html), this filter is ignored.
         *
         * ## INSTANCE_ARN
         * The Amazon Resource Name (ARN) of the device instance.
         *
         * Supported operators: `EQUALS`, `IN`, `NOT_IN`
         *
         * ## INSTANCE_LABELS
         * The label of the device instance.
         *
         * Supported operators: `CONTAINS`
         *
         * ## FLEET_TYPE
         * The fleet type. Valid values are PUBLIC or PRIVATE.
         *
         * Supported operators: `EQUALS`
         */
        public var attribute: aws.sdk.kotlin.services.devicefarm.model.DeviceFilterAttribute? = null
        /**
         * Specifies how Device Farm compares the filter's attribute to the value. See the attribute descriptions.
         */
        public var operator: aws.sdk.kotlin.services.devicefarm.model.RuleOperator? = null
        /**
         * An array of one or more filter values used in a device filter.
         *
         * **Operator Values**
         * + The IN and NOT_IN operators can take a values array that has more than one element.
         * + The other operators require an array with a single element.
         *
         * **Attribute Values**
         * + The PLATFORM attribute can be set to ANDROID or IOS.
         * + The AVAILABILITY attribute can be set to AVAILABLE, HIGHLY_AVAILABLE, BUSY, or TEMPORARY_NOT_AVAILABLE.
         * + The FORM_FACTOR attribute can be set to PHONE or TABLET.
         * + The FLEET_TYPE attribute can be set to PUBLIC or PRIVATE.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.DeviceFilter) : this() {
            this.attribute = x.attribute
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.DeviceFilter = DeviceFilter(this)

        internal fun correctErrors(): Builder {
            if (attribute == null) attribute = DeviceFilterAttribute.SdkUnknown("no value provided")
            if (operator == null) operator = RuleOperator.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
