// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model



/**
 * Represents a device type that an app is tested against.
 */
public class Device private constructor(builder: Builder) {
    /**
     * The device's ARN.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Indicates how likely a device is available for a test run. Currently available in the ListDevices and GetDevice API methods.
     */
    public val availability: aws.sdk.kotlin.services.devicefarm.model.DeviceAvailability? = builder.availability
    /**
     * The device's carrier.
     */
    public val carrier: kotlin.String? = builder.carrier
    /**
     * Information about the device's CPU.
     */
    public val cpu: aws.sdk.kotlin.services.devicefarm.model.Cpu? = builder.cpu
    /**
     * The name of the fleet to which this device belongs.
     */
    public val fleetName: kotlin.String? = builder.fleetName
    /**
     * The type of fleet to which this device belongs. Possible values are PRIVATE and PUBLIC.
     */
    public val fleetType: kotlin.String? = builder.fleetType
    /**
     * The device's form factor.
     *
     * Allowed values include:
     * + PHONE
     * + TABLET
     */
    public val formFactor: aws.sdk.kotlin.services.devicefarm.model.DeviceFormFactor? = builder.formFactor
    /**
     * The device's heap size, expressed in bytes.
     */
    public val heapSize: kotlin.Long? = builder.heapSize
    /**
     * The device's image name.
     */
    public val image: kotlin.String? = builder.image
    /**
     * The instances that belong to this device.
     */
    public val instances: List<DeviceInstance>? = builder.instances
    /**
     * The device's manufacturer name.
     */
    public val manufacturer: kotlin.String? = builder.manufacturer
    /**
     * The device's total memory size, expressed in bytes.
     */
    public val memory: kotlin.Long? = builder.memory
    /**
     * The device's model name.
     */
    public val model: kotlin.String? = builder.model
    /**
     * The device's model ID.
     */
    public val modelId: kotlin.String? = builder.modelId
    /**
     * The device's display name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The device's operating system type.
     */
    public val os: kotlin.String? = builder.os
    /**
     * The device's platform.
     *
     * Allowed values include:
     * + ANDROID
     * + IOS
     */
    public val platform: aws.sdk.kotlin.services.devicefarm.model.DevicePlatform? = builder.platform
    /**
     * The device's radio.
     */
    public val radio: kotlin.String? = builder.radio
    /**
     * Specifies whether remote access has been enabled for the specified device.
     */
    public val remoteAccessEnabled: kotlin.Boolean? = builder.remoteAccessEnabled
    /**
     * This flag is set to `true` if remote debugging is enabled for the device.
     *
     * Remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
     */
    public val remoteDebugEnabled: kotlin.Boolean? = builder.remoteDebugEnabled
    /**
     * The resolution of the device.
     */
    public val resolution: aws.sdk.kotlin.services.devicefarm.model.Resolution? = builder.resolution

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.Device = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Device(")
        append("arn=$arn,")
        append("availability=$availability,")
        append("carrier=$carrier,")
        append("cpu=$cpu,")
        append("fleetName=$fleetName,")
        append("fleetType=$fleetType,")
        append("formFactor=$formFactor,")
        append("heapSize=$heapSize,")
        append("image=$image,")
        append("instances=$instances,")
        append("manufacturer=$manufacturer,")
        append("memory=$memory,")
        append("model=$model,")
        append("modelId=$modelId,")
        append("name=$name,")
        append("os=$os,")
        append("platform=$platform,")
        append("radio=$radio,")
        append("remoteAccessEnabled=$remoteAccessEnabled,")
        append("remoteDebugEnabled=$remoteDebugEnabled,")
        append("resolution=$resolution")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (availability?.hashCode() ?: 0)
        result = 31 * result + (carrier?.hashCode() ?: 0)
        result = 31 * result + (cpu?.hashCode() ?: 0)
        result = 31 * result + (fleetName?.hashCode() ?: 0)
        result = 31 * result + (fleetType?.hashCode() ?: 0)
        result = 31 * result + (formFactor?.hashCode() ?: 0)
        result = 31 * result + (heapSize?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (manufacturer?.hashCode() ?: 0)
        result = 31 * result + (memory?.hashCode() ?: 0)
        result = 31 * result + (model?.hashCode() ?: 0)
        result = 31 * result + (modelId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (os?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (radio?.hashCode() ?: 0)
        result = 31 * result + (remoteAccessEnabled?.hashCode() ?: 0)
        result = 31 * result + (remoteDebugEnabled?.hashCode() ?: 0)
        result = 31 * result + (resolution?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Device

        if (arn != other.arn) return false
        if (availability != other.availability) return false
        if (carrier != other.carrier) return false
        if (cpu != other.cpu) return false
        if (fleetName != other.fleetName) return false
        if (fleetType != other.fleetType) return false
        if (formFactor != other.formFactor) return false
        if (heapSize != other.heapSize) return false
        if (image != other.image) return false
        if (instances != other.instances) return false
        if (manufacturer != other.manufacturer) return false
        if (memory != other.memory) return false
        if (model != other.model) return false
        if (modelId != other.modelId) return false
        if (name != other.name) return false
        if (os != other.os) return false
        if (platform != other.platform) return false
        if (radio != other.radio) return false
        if (remoteAccessEnabled != other.remoteAccessEnabled) return false
        if (remoteDebugEnabled != other.remoteDebugEnabled) return false
        if (resolution != other.resolution) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.Device = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The device's ARN.
         */
        public var arn: kotlin.String? = null
        /**
         * Indicates how likely a device is available for a test run. Currently available in the ListDevices and GetDevice API methods.
         */
        public var availability: aws.sdk.kotlin.services.devicefarm.model.DeviceAvailability? = null
        /**
         * The device's carrier.
         */
        public var carrier: kotlin.String? = null
        /**
         * Information about the device's CPU.
         */
        public var cpu: aws.sdk.kotlin.services.devicefarm.model.Cpu? = null
        /**
         * The name of the fleet to which this device belongs.
         */
        public var fleetName: kotlin.String? = null
        /**
         * The type of fleet to which this device belongs. Possible values are PRIVATE and PUBLIC.
         */
        public var fleetType: kotlin.String? = null
        /**
         * The device's form factor.
         *
         * Allowed values include:
         * + PHONE
         * + TABLET
         */
        public var formFactor: aws.sdk.kotlin.services.devicefarm.model.DeviceFormFactor? = null
        /**
         * The device's heap size, expressed in bytes.
         */
        public var heapSize: kotlin.Long? = null
        /**
         * The device's image name.
         */
        public var image: kotlin.String? = null
        /**
         * The instances that belong to this device.
         */
        public var instances: List<DeviceInstance>? = null
        /**
         * The device's manufacturer name.
         */
        public var manufacturer: kotlin.String? = null
        /**
         * The device's total memory size, expressed in bytes.
         */
        public var memory: kotlin.Long? = null
        /**
         * The device's model name.
         */
        public var model: kotlin.String? = null
        /**
         * The device's model ID.
         */
        public var modelId: kotlin.String? = null
        /**
         * The device's display name.
         */
        public var name: kotlin.String? = null
        /**
         * The device's operating system type.
         */
        public var os: kotlin.String? = null
        /**
         * The device's platform.
         *
         * Allowed values include:
         * + ANDROID
         * + IOS
         */
        public var platform: aws.sdk.kotlin.services.devicefarm.model.DevicePlatform? = null
        /**
         * The device's radio.
         */
        public var radio: kotlin.String? = null
        /**
         * Specifies whether remote access has been enabled for the specified device.
         */
        public var remoteAccessEnabled: kotlin.Boolean? = null
        /**
         * This flag is set to `true` if remote debugging is enabled for the device.
         *
         * Remote debugging is [no longer supported](https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html).
         */
        public var remoteDebugEnabled: kotlin.Boolean? = null
        /**
         * The resolution of the device.
         */
        public var resolution: aws.sdk.kotlin.services.devicefarm.model.Resolution? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.Device) : this() {
            this.arn = x.arn
            this.availability = x.availability
            this.carrier = x.carrier
            this.cpu = x.cpu
            this.fleetName = x.fleetName
            this.fleetType = x.fleetType
            this.formFactor = x.formFactor
            this.heapSize = x.heapSize
            this.image = x.image
            this.instances = x.instances
            this.manufacturer = x.manufacturer
            this.memory = x.memory
            this.model = x.model
            this.modelId = x.modelId
            this.name = x.name
            this.os = x.os
            this.platform = x.platform
            this.radio = x.radio
            this.remoteAccessEnabled = x.remoteAccessEnabled
            this.remoteDebugEnabled = x.remoteDebugEnabled
            this.resolution = x.resolution
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.Device = Device(this)

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.Cpu] inside the given [block]
         */
        public fun cpu(block: aws.sdk.kotlin.services.devicefarm.model.Cpu.Builder.() -> kotlin.Unit) {
            this.cpu = aws.sdk.kotlin.services.devicefarm.model.Cpu.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.devicefarm.model.Resolution] inside the given [block]
         */
        public fun resolution(block: aws.sdk.kotlin.services.devicefarm.model.Resolution.Builder.() -> kotlin.Unit) {
            this.resolution = aws.sdk.kotlin.services.devicefarm.model.Resolution.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
