// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm.model



/**
 * A JSON object that specifies the paths where the artifacts generated by the customer's tests, on the device or in the test environment, are pulled from.
 *
 * Specify `deviceHostPaths` and optionally specify either `iosPaths` or `androidPaths`.
 *
 * For web app tests, you can specify both `iosPaths` and `androidPaths`.
 */
public class CustomerArtifactPaths private constructor(builder: Builder) {
    /**
     * Comma-separated list of paths on the Android device where the artifacts generated by the customer's tests are pulled from.
     */
    public val androidPaths: List<String>? = builder.androidPaths
    /**
     * Comma-separated list of paths in the test execution environment where the artifacts generated by the customer's tests are pulled from.
     */
    public val deviceHostPaths: List<String>? = builder.deviceHostPaths
    /**
     * Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests are pulled from.
     */
    public val iosPaths: List<String>? = builder.iosPaths

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomerArtifactPaths(")
        append("androidPaths=$androidPaths,")
        append("deviceHostPaths=$deviceHostPaths,")
        append("iosPaths=$iosPaths")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = androidPaths?.hashCode() ?: 0
        result = 31 * result + (deviceHostPaths?.hashCode() ?: 0)
        result = 31 * result + (iosPaths?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomerArtifactPaths

        if (androidPaths != other.androidPaths) return false
        if (deviceHostPaths != other.deviceHostPaths) return false
        if (iosPaths != other.iosPaths) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Comma-separated list of paths on the Android device where the artifacts generated by the customer's tests are pulled from.
         */
        public var androidPaths: List<String>? = null
        /**
         * Comma-separated list of paths in the test execution environment where the artifacts generated by the customer's tests are pulled from.
         */
        public var deviceHostPaths: List<String>? = null
        /**
         * Comma-separated list of paths on the iOS device where the artifacts generated by the customer's tests are pulled from.
         */
        public var iosPaths: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths) : this() {
            this.androidPaths = x.androidPaths
            this.deviceHostPaths = x.deviceHostPaths
            this.iosPaths = x.iosPaths
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.devicefarm.model.CustomerArtifactPaths = CustomerArtifactPaths(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
