// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.devicefarm

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.devicefarm.auth.DefaultDeviceFarmAuthSchemeProvider
import aws.sdk.kotlin.services.devicefarm.auth.DeviceFarmAuthSchemeProvider
import aws.sdk.kotlin.services.devicefarm.endpoints.DefaultDeviceFarmEndpointProvider
import aws.sdk.kotlin.services.devicefarm.endpoints.DeviceFarmEndpointParameters
import aws.sdk.kotlin.services.devicefarm.endpoints.DeviceFarmEndpointProvider
import aws.sdk.kotlin.services.devicefarm.model.CreateDevicePoolRequest
import aws.sdk.kotlin.services.devicefarm.model.CreateDevicePoolResponse
import aws.sdk.kotlin.services.devicefarm.model.CreateInstanceProfileRequest
import aws.sdk.kotlin.services.devicefarm.model.CreateInstanceProfileResponse
import aws.sdk.kotlin.services.devicefarm.model.CreateNetworkProfileRequest
import aws.sdk.kotlin.services.devicefarm.model.CreateNetworkProfileResponse
import aws.sdk.kotlin.services.devicefarm.model.CreateProjectRequest
import aws.sdk.kotlin.services.devicefarm.model.CreateProjectResponse
import aws.sdk.kotlin.services.devicefarm.model.CreateRemoteAccessSessionRequest
import aws.sdk.kotlin.services.devicefarm.model.CreateRemoteAccessSessionResponse
import aws.sdk.kotlin.services.devicefarm.model.CreateTestGridProjectRequest
import aws.sdk.kotlin.services.devicefarm.model.CreateTestGridProjectResponse
import aws.sdk.kotlin.services.devicefarm.model.CreateTestGridUrlRequest
import aws.sdk.kotlin.services.devicefarm.model.CreateTestGridUrlResponse
import aws.sdk.kotlin.services.devicefarm.model.CreateUploadRequest
import aws.sdk.kotlin.services.devicefarm.model.CreateUploadResponse
import aws.sdk.kotlin.services.devicefarm.model.CreateVpceConfigurationRequest
import aws.sdk.kotlin.services.devicefarm.model.CreateVpceConfigurationResponse
import aws.sdk.kotlin.services.devicefarm.model.DeleteDevicePoolRequest
import aws.sdk.kotlin.services.devicefarm.model.DeleteDevicePoolResponse
import aws.sdk.kotlin.services.devicefarm.model.DeleteInstanceProfileRequest
import aws.sdk.kotlin.services.devicefarm.model.DeleteInstanceProfileResponse
import aws.sdk.kotlin.services.devicefarm.model.DeleteNetworkProfileRequest
import aws.sdk.kotlin.services.devicefarm.model.DeleteNetworkProfileResponse
import aws.sdk.kotlin.services.devicefarm.model.DeleteProjectRequest
import aws.sdk.kotlin.services.devicefarm.model.DeleteProjectResponse
import aws.sdk.kotlin.services.devicefarm.model.DeleteRemoteAccessSessionRequest
import aws.sdk.kotlin.services.devicefarm.model.DeleteRemoteAccessSessionResponse
import aws.sdk.kotlin.services.devicefarm.model.DeleteRunRequest
import aws.sdk.kotlin.services.devicefarm.model.DeleteRunResponse
import aws.sdk.kotlin.services.devicefarm.model.DeleteTestGridProjectRequest
import aws.sdk.kotlin.services.devicefarm.model.DeleteTestGridProjectResponse
import aws.sdk.kotlin.services.devicefarm.model.DeleteUploadRequest
import aws.sdk.kotlin.services.devicefarm.model.DeleteUploadResponse
import aws.sdk.kotlin.services.devicefarm.model.DeleteVpceConfigurationRequest
import aws.sdk.kotlin.services.devicefarm.model.DeleteVpceConfigurationResponse
import aws.sdk.kotlin.services.devicefarm.model.GetAccountSettingsRequest
import aws.sdk.kotlin.services.devicefarm.model.GetAccountSettingsResponse
import aws.sdk.kotlin.services.devicefarm.model.GetDeviceInstanceRequest
import aws.sdk.kotlin.services.devicefarm.model.GetDeviceInstanceResponse
import aws.sdk.kotlin.services.devicefarm.model.GetDevicePoolCompatibilityRequest
import aws.sdk.kotlin.services.devicefarm.model.GetDevicePoolCompatibilityResponse
import aws.sdk.kotlin.services.devicefarm.model.GetDevicePoolRequest
import aws.sdk.kotlin.services.devicefarm.model.GetDevicePoolResponse
import aws.sdk.kotlin.services.devicefarm.model.GetDeviceRequest
import aws.sdk.kotlin.services.devicefarm.model.GetDeviceResponse
import aws.sdk.kotlin.services.devicefarm.model.GetInstanceProfileRequest
import aws.sdk.kotlin.services.devicefarm.model.GetInstanceProfileResponse
import aws.sdk.kotlin.services.devicefarm.model.GetJobRequest
import aws.sdk.kotlin.services.devicefarm.model.GetJobResponse
import aws.sdk.kotlin.services.devicefarm.model.GetNetworkProfileRequest
import aws.sdk.kotlin.services.devicefarm.model.GetNetworkProfileResponse
import aws.sdk.kotlin.services.devicefarm.model.GetOfferingStatusRequest
import aws.sdk.kotlin.services.devicefarm.model.GetOfferingStatusResponse
import aws.sdk.kotlin.services.devicefarm.model.GetProjectRequest
import aws.sdk.kotlin.services.devicefarm.model.GetProjectResponse
import aws.sdk.kotlin.services.devicefarm.model.GetRemoteAccessSessionRequest
import aws.sdk.kotlin.services.devicefarm.model.GetRemoteAccessSessionResponse
import aws.sdk.kotlin.services.devicefarm.model.GetRunRequest
import aws.sdk.kotlin.services.devicefarm.model.GetRunResponse
import aws.sdk.kotlin.services.devicefarm.model.GetSuiteRequest
import aws.sdk.kotlin.services.devicefarm.model.GetSuiteResponse
import aws.sdk.kotlin.services.devicefarm.model.GetTestGridProjectRequest
import aws.sdk.kotlin.services.devicefarm.model.GetTestGridProjectResponse
import aws.sdk.kotlin.services.devicefarm.model.GetTestGridSessionRequest
import aws.sdk.kotlin.services.devicefarm.model.GetTestGridSessionResponse
import aws.sdk.kotlin.services.devicefarm.model.GetTestRequest
import aws.sdk.kotlin.services.devicefarm.model.GetTestResponse
import aws.sdk.kotlin.services.devicefarm.model.GetUploadRequest
import aws.sdk.kotlin.services.devicefarm.model.GetUploadResponse
import aws.sdk.kotlin.services.devicefarm.model.GetVpceConfigurationRequest
import aws.sdk.kotlin.services.devicefarm.model.GetVpceConfigurationResponse
import aws.sdk.kotlin.services.devicefarm.model.InstallToRemoteAccessSessionRequest
import aws.sdk.kotlin.services.devicefarm.model.InstallToRemoteAccessSessionResponse
import aws.sdk.kotlin.services.devicefarm.model.ListArtifactsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListArtifactsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListDeviceInstancesRequest
import aws.sdk.kotlin.services.devicefarm.model.ListDeviceInstancesResponse
import aws.sdk.kotlin.services.devicefarm.model.ListDevicePoolsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListDevicePoolsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListDevicesRequest
import aws.sdk.kotlin.services.devicefarm.model.ListDevicesResponse
import aws.sdk.kotlin.services.devicefarm.model.ListInstanceProfilesRequest
import aws.sdk.kotlin.services.devicefarm.model.ListInstanceProfilesResponse
import aws.sdk.kotlin.services.devicefarm.model.ListJobsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListJobsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListNetworkProfilesRequest
import aws.sdk.kotlin.services.devicefarm.model.ListNetworkProfilesResponse
import aws.sdk.kotlin.services.devicefarm.model.ListOfferingPromotionsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListOfferingPromotionsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListOfferingTransactionsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListOfferingTransactionsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListOfferingsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListOfferingsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListProjectsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListProjectsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListRemoteAccessSessionsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListRemoteAccessSessionsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListRunsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListRunsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListSamplesRequest
import aws.sdk.kotlin.services.devicefarm.model.ListSamplesResponse
import aws.sdk.kotlin.services.devicefarm.model.ListSuitesRequest
import aws.sdk.kotlin.services.devicefarm.model.ListSuitesResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridProjectsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridProjectsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionActionsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionActionsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionArtifactsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionArtifactsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTestGridSessionsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListTestsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListTestsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListUniqueProblemsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListUniqueProblemsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListUploadsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListUploadsResponse
import aws.sdk.kotlin.services.devicefarm.model.ListVpceConfigurationsRequest
import aws.sdk.kotlin.services.devicefarm.model.ListVpceConfigurationsResponse
import aws.sdk.kotlin.services.devicefarm.model.PurchaseOfferingRequest
import aws.sdk.kotlin.services.devicefarm.model.PurchaseOfferingResponse
import aws.sdk.kotlin.services.devicefarm.model.RenewOfferingRequest
import aws.sdk.kotlin.services.devicefarm.model.RenewOfferingResponse
import aws.sdk.kotlin.services.devicefarm.model.ScheduleRunRequest
import aws.sdk.kotlin.services.devicefarm.model.ScheduleRunResponse
import aws.sdk.kotlin.services.devicefarm.model.StopJobRequest
import aws.sdk.kotlin.services.devicefarm.model.StopJobResponse
import aws.sdk.kotlin.services.devicefarm.model.StopRemoteAccessSessionRequest
import aws.sdk.kotlin.services.devicefarm.model.StopRemoteAccessSessionResponse
import aws.sdk.kotlin.services.devicefarm.model.StopRunRequest
import aws.sdk.kotlin.services.devicefarm.model.StopRunResponse
import aws.sdk.kotlin.services.devicefarm.model.TagResourceRequest
import aws.sdk.kotlin.services.devicefarm.model.TagResourceResponse
import aws.sdk.kotlin.services.devicefarm.model.UntagResourceRequest
import aws.sdk.kotlin.services.devicefarm.model.UntagResourceResponse
import aws.sdk.kotlin.services.devicefarm.model.UpdateDeviceInstanceRequest
import aws.sdk.kotlin.services.devicefarm.model.UpdateDeviceInstanceResponse
import aws.sdk.kotlin.services.devicefarm.model.UpdateDevicePoolRequest
import aws.sdk.kotlin.services.devicefarm.model.UpdateDevicePoolResponse
import aws.sdk.kotlin.services.devicefarm.model.UpdateInstanceProfileRequest
import aws.sdk.kotlin.services.devicefarm.model.UpdateInstanceProfileResponse
import aws.sdk.kotlin.services.devicefarm.model.UpdateNetworkProfileRequest
import aws.sdk.kotlin.services.devicefarm.model.UpdateNetworkProfileResponse
import aws.sdk.kotlin.services.devicefarm.model.UpdateProjectRequest
import aws.sdk.kotlin.services.devicefarm.model.UpdateProjectResponse
import aws.sdk.kotlin.services.devicefarm.model.UpdateTestGridProjectRequest
import aws.sdk.kotlin.services.devicefarm.model.UpdateTestGridProjectResponse
import aws.sdk.kotlin.services.devicefarm.model.UpdateUploadRequest
import aws.sdk.kotlin.services.devicefarm.model.UpdateUploadResponse
import aws.sdk.kotlin.services.devicefarm.model.UpdateVpceConfigurationRequest
import aws.sdk.kotlin.services.devicefarm.model.UpdateVpceConfigurationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Device Farm"
public const val SdkVersion: String = "1.0.12"

/**
 * Welcome to the AWS Device Farm API documentation, which contains APIs for:
 * + Testing on desktop browsers Device Farm makes it possible for you to test your web applications on desktop browsers using Selenium. The APIs for desktop browser testing contain `TestGrid` in their names. For more information, see [Testing Web Applications on Selenium with Device Farm](https://docs.aws.amazon.com/devicefarm/latest/testgrid/).
 * + Testing on real mobile devicesDevice Farm makes it possible for you to test apps on physical phones, tablets, and other devices in the cloud. For more information, see the [Device Farm Developer Guide](https://docs.aws.amazon.com/devicefarm/latest/developerguide/).
 */
public interface DeviceFarmClient : SdkClient {
    /**
     * DeviceFarmClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, DeviceFarmClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "DeviceFarm",
                "DEVICE_FARM",
                "device_farm",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, DeviceFarmClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): DeviceFarmClient = DefaultDeviceFarmClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: DeviceFarmEndpointProvider = builder.endpointProvider ?: DefaultDeviceFarmEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: DeviceFarmAuthSchemeProvider = builder.authSchemeProvider ?: DefaultDeviceFarmAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Device Farm"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: DeviceFarmEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: DeviceFarmAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a device pool.
     */
    public suspend fun createDevicePool(input: CreateDevicePoolRequest): CreateDevicePoolResponse

    /**
     * Creates a profile that can be applied to one or more private fleet device instances.
     */
    public suspend fun createInstanceProfile(input: CreateInstanceProfileRequest): CreateInstanceProfileResponse

    /**
     * Creates a network profile.
     */
    public suspend fun createNetworkProfile(input: CreateNetworkProfileRequest): CreateNetworkProfileResponse

    /**
     * Creates a project.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Specifies and starts a remote access session.
     */
    public suspend fun createRemoteAccessSession(input: CreateRemoteAccessSessionRequest): CreateRemoteAccessSessionResponse

    /**
     * Creates a Selenium testing project. Projects are used to track TestGridSession instances.
     */
    public suspend fun createTestGridProject(input: CreateTestGridProjectRequest): CreateTestGridProjectResponse

    /**
     * Creates a signed, short-term URL that can be passed to a Selenium `RemoteWebDriver` constructor.
     */
    public suspend fun createTestGridUrl(input: CreateTestGridUrlRequest): CreateTestGridUrlResponse

    /**
     * Uploads an app or test scripts.
     */
    public suspend fun createUpload(input: CreateUploadRequest): CreateUploadResponse

    /**
     * Creates a configuration record in Device Farm for your Amazon Virtual Private Cloud (VPC) endpoint.
     */
    public suspend fun createVpceConfiguration(input: CreateVpceConfigurationRequest): CreateVpceConfigurationResponse

    /**
     * Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by the system.
     */
    public suspend fun deleteDevicePool(input: DeleteDevicePoolRequest): DeleteDevicePoolResponse

    /**
     * Deletes a profile that can be applied to one or more private device instances.
     */
    public suspend fun deleteInstanceProfile(input: DeleteInstanceProfileRequest): DeleteInstanceProfileResponse

    /**
     * Deletes a network profile.
     */
    public suspend fun deleteNetworkProfile(input: DeleteNetworkProfileRequest): DeleteNetworkProfileResponse

    /**
     * Deletes an AWS Device Farm project, given the project ARN.
     *
     *  Deleting this resource does not stop an in-progress run.
     */
    public suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Deletes a completed remote access session and its results.
     */
    public suspend fun deleteRemoteAccessSession(input: DeleteRemoteAccessSessionRequest): DeleteRemoteAccessSessionResponse

    /**
     * Deletes the run, given the run ARN.
     *
     *  Deleting this resource does not stop an in-progress run.
     */
    public suspend fun deleteRun(input: DeleteRunRequest): DeleteRunResponse

    /**
     * Deletes a Selenium testing project and all content generated under it.
     *
     * You cannot undo this operation.
     *
     * You cannot delete a project if it has active sessions.
     */
    public suspend fun deleteTestGridProject(input: DeleteTestGridProjectRequest): DeleteTestGridProjectResponse

    /**
     * Deletes an upload given the upload ARN.
     */
    public suspend fun deleteUpload(input: DeleteUploadRequest): DeleteUploadResponse

    /**
     * Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.
     */
    public suspend fun deleteVpceConfiguration(input: DeleteVpceConfigurationRequest): DeleteVpceConfigurationResponse

    /**
     * Returns the number of unmetered iOS or unmetered Android devices that have been purchased by the account.
     */
    public suspend fun getAccountSettings(input: GetAccountSettingsRequest = GetAccountSettingsRequest { }): GetAccountSettingsResponse

    /**
     * Gets information about a unique device type.
     */
    public suspend fun getDevice(input: GetDeviceRequest): GetDeviceResponse

    /**
     * Returns information about a device instance that belongs to a private device fleet.
     */
    public suspend fun getDeviceInstance(input: GetDeviceInstanceRequest): GetDeviceInstanceResponse

    /**
     * Gets information about a device pool.
     */
    public suspend fun getDevicePool(input: GetDevicePoolRequest): GetDevicePoolResponse

    /**
     * Gets information about compatibility with a device pool.
     */
    public suspend fun getDevicePoolCompatibility(input: GetDevicePoolCompatibilityRequest): GetDevicePoolCompatibilityResponse

    /**
     * Returns information about the specified instance profile.
     */
    public suspend fun getInstanceProfile(input: GetInstanceProfileRequest): GetInstanceProfileResponse

    /**
     * Gets information about a job.
     */
    public suspend fun getJob(input: GetJobRequest): GetJobResponse

    /**
     * Returns information about a network profile.
     */
    public suspend fun getNetworkProfile(input: GetNetworkProfileRequest): GetNetworkProfileResponse

    /**
     * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates how many offerings are currently available and the offerings that will be available in the next period. The API returns a `NotEligible` error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com).
     */
    public suspend fun getOfferingStatus(input: GetOfferingStatusRequest = GetOfferingStatusRequest { }): GetOfferingStatusResponse

    /**
     * Gets information about a project.
     */
    public suspend fun getProject(input: GetProjectRequest): GetProjectResponse

    /**
     * Returns a link to a currently running remote access session.
     */
    public suspend fun getRemoteAccessSession(input: GetRemoteAccessSessionRequest): GetRemoteAccessSessionResponse

    /**
     * Gets information about a run.
     */
    public suspend fun getRun(input: GetRunRequest): GetRunResponse

    /**
     * Gets information about a suite.
     */
    public suspend fun getSuite(input: GetSuiteRequest): GetSuiteResponse

    /**
     * Gets information about a test.
     */
    public suspend fun getTest(input: GetTestRequest): GetTestResponse

    /**
     * Retrieves information about a Selenium testing project.
     */
    public suspend fun getTestGridProject(input: GetTestGridProjectRequest): GetTestGridProjectResponse

    /**
     * A session is an instance of a browser created through a `RemoteWebDriver` with the URL from CreateTestGridUrlResult$url. You can use the following to look up sessions:
     * + The session ARN (GetTestGridSessionRequest$sessionArn).
     * + The project ARN and a session ID (GetTestGridSessionRequest$projectArn and GetTestGridSessionRequest$sessionId).
     */
    public suspend fun getTestGridSession(input: GetTestGridSessionRequest = GetTestGridSessionRequest { }): GetTestGridSessionResponse

    /**
     * Gets information about an upload.
     */
    public suspend fun getUpload(input: GetUploadRequest): GetUploadResponse

    /**
     * Returns information about the configuration settings for your Amazon Virtual Private Cloud (VPC) endpoint.
     */
    public suspend fun getVpceConfiguration(input: GetVpceConfigurationRequest): GetVpceConfigurationResponse

    /**
     * Installs an application to the device in a remote access session. For Android applications, the file must be in .apk format. For iOS applications, the file must be in .ipa format.
     */
    public suspend fun installToRemoteAccessSession(input: InstallToRemoteAccessSessionRequest): InstallToRemoteAccessSessionResponse

    /**
     * Gets information about artifacts.
     */
    public suspend fun listArtifacts(input: ListArtifactsRequest): ListArtifactsResponse

    /**
     * Returns information about the private device instances associated with one or more AWS accounts.
     */
    public suspend fun listDeviceInstances(input: ListDeviceInstancesRequest = ListDeviceInstancesRequest { }): ListDeviceInstancesResponse

    /**
     * Gets information about device pools.
     */
    public suspend fun listDevicePools(input: ListDevicePoolsRequest): ListDevicePoolsResponse

    /**
     * Gets information about unique device types.
     */
    public suspend fun listDevices(input: ListDevicesRequest = ListDevicesRequest { }): ListDevicesResponse

    /**
     * Returns information about all the instance profiles in an AWS account.
     */
    public suspend fun listInstanceProfiles(input: ListInstanceProfilesRequest = ListInstanceProfilesRequest { }): ListInstanceProfilesResponse

    /**
     * Gets information about jobs for a given test run.
     */
    public suspend fun listJobs(input: ListJobsRequest): ListJobsResponse

    /**
     * Returns the list of available network profiles.
     */
    public suspend fun listNetworkProfiles(input: ListNetworkProfilesRequest): ListNetworkProfilesResponse

    /**
     * Returns a list of offering promotions. Each offering promotion record contains the ID and description of the promotion. The API returns a `NotEligible` error if the caller is not permitted to invoke the operation. Contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com) if you must be able to invoke this operation.
     */
    public suspend fun listOfferingPromotions(input: ListOfferingPromotionsRequest = ListOfferingPromotionsRequest { }): ListOfferingPromotionsResponse

    /**
     * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a `NotEligible` error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com).
     */
    public suspend fun listOfferingTransactions(input: ListOfferingTransactionsRequest = ListOfferingTransactionsRequest { }): ListOfferingTransactionsResponse

    /**
     * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates the recurring price per unit and the frequency for that offering. The API returns a `NotEligible` error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com).
     */
    public suspend fun listOfferings(input: ListOfferingsRequest = ListOfferingsRequest { }): ListOfferingsResponse

    /**
     * Gets information about projects.
     */
    public suspend fun listProjects(input: ListProjectsRequest = ListProjectsRequest { }): ListProjectsResponse

    /**
     * Returns a list of all currently running remote access sessions.
     */
    public suspend fun listRemoteAccessSessions(input: ListRemoteAccessSessionsRequest): ListRemoteAccessSessionsResponse

    /**
     * Gets information about runs, given an AWS Device Farm project ARN.
     */
    public suspend fun listRuns(input: ListRunsRequest): ListRunsResponse

    /**
     * Gets information about samples, given an AWS Device Farm job ARN.
     */
    public suspend fun listSamples(input: ListSamplesRequest): ListSamplesResponse

    /**
     * Gets information about test suites for a given job.
     */
    public suspend fun listSuites(input: ListSuitesRequest): ListSuitesResponse

    /**
     * List the tags for an AWS Device Farm resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Gets a list of all Selenium testing projects in your account.
     */
    public suspend fun listTestGridProjects(input: ListTestGridProjectsRequest = ListTestGridProjectsRequest { }): ListTestGridProjectsResponse

    /**
     * Returns a list of the actions taken in a TestGridSession.
     */
    public suspend fun listTestGridSessionActions(input: ListTestGridSessionActionsRequest): ListTestGridSessionActionsResponse

    /**
     * Retrieves a list of artifacts created during the session.
     */
    public suspend fun listTestGridSessionArtifacts(input: ListTestGridSessionArtifactsRequest): ListTestGridSessionArtifactsResponse

    /**
     * Retrieves a list of sessions for a TestGridProject.
     */
    public suspend fun listTestGridSessions(input: ListTestGridSessionsRequest): ListTestGridSessionsResponse

    /**
     * Gets information about tests in a given test suite.
     */
    public suspend fun listTests(input: ListTestsRequest): ListTestsResponse

    /**
     * Gets information about unique problems, such as exceptions or crashes.
     *
     * Unique problems are defined as a single instance of an error across a run, job, or suite. For example, if a call in your application consistently raises an exception (`OutOfBoundsException in MyActivity.java:386`), `ListUniqueProblems` returns a single entry instead of many individual entries for that exception.
     */
    public suspend fun listUniqueProblems(input: ListUniqueProblemsRequest): ListUniqueProblemsResponse

    /**
     * Gets information about uploads, given an AWS Device Farm project ARN.
     */
    public suspend fun listUploads(input: ListUploadsRequest): ListUploadsResponse

    /**
     * Returns information about all Amazon Virtual Private Cloud (VPC) endpoint configurations in the AWS account.
     */
    public suspend fun listVpceConfigurations(input: ListVpceConfigurationsRequest = ListVpceConfigurationsRequest { }): ListVpceConfigurationsResponse

    /**
     * Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased quantity for an offering, unless the renewal was overridden. The API returns a `NotEligible` error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com).
     */
    public suspend fun purchaseOffering(input: PurchaseOfferingRequest): PurchaseOfferingResponse

    /**
     * Explicitly sets the quantity of devices to renew for an offering, starting from the `effectiveDate` of the next period. The API returns a `NotEligible` error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com).
     */
    public suspend fun renewOffering(input: RenewOfferingRequest): RenewOfferingResponse

    /**
     * Schedules a run.
     */
    public suspend fun scheduleRun(input: ScheduleRunRequest): ScheduleRunResponse

    /**
     * Initiates a stop request for the current job. AWS Device Farm immediately stops the job on the device where tests have not started. You are not billed for this device. On the device where tests have started, setup suite and teardown suite tests run to completion on the device. You are billed for setup, teardown, and any tests that were in progress or already completed.
     */
    public suspend fun stopJob(input: StopJobRequest): StopJobResponse

    /**
     * Ends a specified remote access session.
     */
    public suspend fun stopRemoteAccessSession(input: StopRemoteAccessSessionRequest): StopRemoteAccessSessionResponse

    /**
     * Initiates a stop request for the current test run. AWS Device Farm immediately stops the run on devices where tests have not started. You are not billed for these devices. On devices where tests have started executing, setup suite and teardown suite tests run to completion on those devices. You are billed for setup, teardown, and any tests that were in progress or already completed.
     */
    public suspend fun stopRun(input: StopRunRequest): StopRunResponse

    /**
     * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are also deleted.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes the specified tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates information about a private device instance.
     */
    public suspend fun updateDeviceInstance(input: UpdateDeviceInstanceRequest): UpdateDeviceInstanceResponse

    /**
     * Modifies the name, description, and rules in a device pool given the attributes and the pool ARN. Rule updates are all-or-nothing, meaning they can only be updated as a whole (or not at all).
     */
    public suspend fun updateDevicePool(input: UpdateDevicePoolRequest): UpdateDevicePoolResponse

    /**
     * Updates information about an existing private device instance profile.
     */
    public suspend fun updateInstanceProfile(input: UpdateInstanceProfileRequest): UpdateInstanceProfileResponse

    /**
     * Updates the network profile.
     */
    public suspend fun updateNetworkProfile(input: UpdateNetworkProfileRequest): UpdateNetworkProfileResponse

    /**
     * Modifies the specified project name, given the project ARN and a new name.
     */
    public suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Change details of a project.
     */
    public suspend fun updateTestGridProject(input: UpdateTestGridProjectRequest): UpdateTestGridProjectResponse

    /**
     * Updates an uploaded test spec.
     */
    public suspend fun updateUpload(input: UpdateUploadRequest): UpdateUploadResponse

    /**
     * Updates information about an Amazon Virtual Private Cloud (VPC) endpoint configuration.
     */
    public suspend fun updateVpceConfiguration(input: UpdateVpceConfigurationRequest): UpdateVpceConfigurationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun DeviceFarmClient.withConfig(block: DeviceFarmClient.Config.Builder.() -> Unit): DeviceFarmClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultDeviceFarmClient(newConfig)
}

/**
 * Creates a device pool.
 */
public suspend inline fun DeviceFarmClient.createDevicePool(crossinline block: CreateDevicePoolRequest.Builder.() -> Unit): CreateDevicePoolResponse = createDevicePool(CreateDevicePoolRequest.Builder().apply(block).build())

/**
 * Creates a profile that can be applied to one or more private fleet device instances.
 */
public suspend inline fun DeviceFarmClient.createInstanceProfile(crossinline block: CreateInstanceProfileRequest.Builder.() -> Unit): CreateInstanceProfileResponse = createInstanceProfile(CreateInstanceProfileRequest.Builder().apply(block).build())

/**
 * Creates a network profile.
 */
public suspend inline fun DeviceFarmClient.createNetworkProfile(crossinline block: CreateNetworkProfileRequest.Builder.() -> Unit): CreateNetworkProfileResponse = createNetworkProfile(CreateNetworkProfileRequest.Builder().apply(block).build())

/**
 * Creates a project.
 */
public suspend inline fun DeviceFarmClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Specifies and starts a remote access session.
 */
public suspend inline fun DeviceFarmClient.createRemoteAccessSession(crossinline block: CreateRemoteAccessSessionRequest.Builder.() -> Unit): CreateRemoteAccessSessionResponse = createRemoteAccessSession(CreateRemoteAccessSessionRequest.Builder().apply(block).build())

/**
 * Creates a Selenium testing project. Projects are used to track TestGridSession instances.
 */
public suspend inline fun DeviceFarmClient.createTestGridProject(crossinline block: CreateTestGridProjectRequest.Builder.() -> Unit): CreateTestGridProjectResponse = createTestGridProject(CreateTestGridProjectRequest.Builder().apply(block).build())

/**
 * Creates a signed, short-term URL that can be passed to a Selenium `RemoteWebDriver` constructor.
 */
public suspend inline fun DeviceFarmClient.createTestGridUrl(crossinline block: CreateTestGridUrlRequest.Builder.() -> Unit): CreateTestGridUrlResponse = createTestGridUrl(CreateTestGridUrlRequest.Builder().apply(block).build())

/**
 * Uploads an app or test scripts.
 */
public suspend inline fun DeviceFarmClient.createUpload(crossinline block: CreateUploadRequest.Builder.() -> Unit): CreateUploadResponse = createUpload(CreateUploadRequest.Builder().apply(block).build())

/**
 * Creates a configuration record in Device Farm for your Amazon Virtual Private Cloud (VPC) endpoint.
 */
public suspend inline fun DeviceFarmClient.createVpceConfiguration(crossinline block: CreateVpceConfigurationRequest.Builder.() -> Unit): CreateVpceConfigurationResponse = createVpceConfiguration(CreateVpceConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a device pool given the pool ARN. Does not allow deletion of curated pools owned by the system.
 */
public suspend inline fun DeviceFarmClient.deleteDevicePool(crossinline block: DeleteDevicePoolRequest.Builder.() -> Unit): DeleteDevicePoolResponse = deleteDevicePool(DeleteDevicePoolRequest.Builder().apply(block).build())

/**
 * Deletes a profile that can be applied to one or more private device instances.
 */
public suspend inline fun DeviceFarmClient.deleteInstanceProfile(crossinline block: DeleteInstanceProfileRequest.Builder.() -> Unit): DeleteInstanceProfileResponse = deleteInstanceProfile(DeleteInstanceProfileRequest.Builder().apply(block).build())

/**
 * Deletes a network profile.
 */
public suspend inline fun DeviceFarmClient.deleteNetworkProfile(crossinline block: DeleteNetworkProfileRequest.Builder.() -> Unit): DeleteNetworkProfileResponse = deleteNetworkProfile(DeleteNetworkProfileRequest.Builder().apply(block).build())

/**
 * Deletes an AWS Device Farm project, given the project ARN.
 *
 *  Deleting this resource does not stop an in-progress run.
 */
public suspend inline fun DeviceFarmClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit): DeleteProjectResponse = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Deletes a completed remote access session and its results.
 */
public suspend inline fun DeviceFarmClient.deleteRemoteAccessSession(crossinline block: DeleteRemoteAccessSessionRequest.Builder.() -> Unit): DeleteRemoteAccessSessionResponse = deleteRemoteAccessSession(DeleteRemoteAccessSessionRequest.Builder().apply(block).build())

/**
 * Deletes the run, given the run ARN.
 *
 *  Deleting this resource does not stop an in-progress run.
 */
public suspend inline fun DeviceFarmClient.deleteRun(crossinline block: DeleteRunRequest.Builder.() -> Unit): DeleteRunResponse = deleteRun(DeleteRunRequest.Builder().apply(block).build())

/**
 * Deletes a Selenium testing project and all content generated under it.
 *
 * You cannot undo this operation.
 *
 * You cannot delete a project if it has active sessions.
 */
public suspend inline fun DeviceFarmClient.deleteTestGridProject(crossinline block: DeleteTestGridProjectRequest.Builder.() -> Unit): DeleteTestGridProjectResponse = deleteTestGridProject(DeleteTestGridProjectRequest.Builder().apply(block).build())

/**
 * Deletes an upload given the upload ARN.
 */
public suspend inline fun DeviceFarmClient.deleteUpload(crossinline block: DeleteUploadRequest.Builder.() -> Unit): DeleteUploadResponse = deleteUpload(DeleteUploadRequest.Builder().apply(block).build())

/**
 * Deletes a configuration for your Amazon Virtual Private Cloud (VPC) endpoint.
 */
public suspend inline fun DeviceFarmClient.deleteVpceConfiguration(crossinline block: DeleteVpceConfigurationRequest.Builder.() -> Unit): DeleteVpceConfigurationResponse = deleteVpceConfiguration(DeleteVpceConfigurationRequest.Builder().apply(block).build())

/**
 * Returns the number of unmetered iOS or unmetered Android devices that have been purchased by the account.
 */
public suspend inline fun DeviceFarmClient.getAccountSettings(crossinline block: GetAccountSettingsRequest.Builder.() -> Unit): GetAccountSettingsResponse = getAccountSettings(GetAccountSettingsRequest.Builder().apply(block).build())

/**
 * Gets information about a unique device type.
 */
public suspend inline fun DeviceFarmClient.getDevice(crossinline block: GetDeviceRequest.Builder.() -> Unit): GetDeviceResponse = getDevice(GetDeviceRequest.Builder().apply(block).build())

/**
 * Returns information about a device instance that belongs to a private device fleet.
 */
public suspend inline fun DeviceFarmClient.getDeviceInstance(crossinline block: GetDeviceInstanceRequest.Builder.() -> Unit): GetDeviceInstanceResponse = getDeviceInstance(GetDeviceInstanceRequest.Builder().apply(block).build())

/**
 * Gets information about a device pool.
 */
public suspend inline fun DeviceFarmClient.getDevicePool(crossinline block: GetDevicePoolRequest.Builder.() -> Unit): GetDevicePoolResponse = getDevicePool(GetDevicePoolRequest.Builder().apply(block).build())

/**
 * Gets information about compatibility with a device pool.
 */
public suspend inline fun DeviceFarmClient.getDevicePoolCompatibility(crossinline block: GetDevicePoolCompatibilityRequest.Builder.() -> Unit): GetDevicePoolCompatibilityResponse = getDevicePoolCompatibility(GetDevicePoolCompatibilityRequest.Builder().apply(block).build())

/**
 * Returns information about the specified instance profile.
 */
public suspend inline fun DeviceFarmClient.getInstanceProfile(crossinline block: GetInstanceProfileRequest.Builder.() -> Unit): GetInstanceProfileResponse = getInstanceProfile(GetInstanceProfileRequest.Builder().apply(block).build())

/**
 * Gets information about a job.
 */
public suspend inline fun DeviceFarmClient.getJob(crossinline block: GetJobRequest.Builder.() -> Unit): GetJobResponse = getJob(GetJobRequest.Builder().apply(block).build())

/**
 * Returns information about a network profile.
 */
public suspend inline fun DeviceFarmClient.getNetworkProfile(crossinline block: GetNetworkProfileRequest.Builder.() -> Unit): GetNetworkProfileResponse = getNetworkProfile(GetNetworkProfileRequest.Builder().apply(block).build())

/**
 * Gets the current status and future status of all offerings purchased by an AWS account. The response indicates how many offerings are currently available and the offerings that will be available in the next period. The API returns a `NotEligible` error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com).
 */
public suspend inline fun DeviceFarmClient.getOfferingStatus(crossinline block: GetOfferingStatusRequest.Builder.() -> Unit): GetOfferingStatusResponse = getOfferingStatus(GetOfferingStatusRequest.Builder().apply(block).build())

/**
 * Gets information about a project.
 */
public suspend inline fun DeviceFarmClient.getProject(crossinline block: GetProjectRequest.Builder.() -> Unit): GetProjectResponse = getProject(GetProjectRequest.Builder().apply(block).build())

/**
 * Returns a link to a currently running remote access session.
 */
public suspend inline fun DeviceFarmClient.getRemoteAccessSession(crossinline block: GetRemoteAccessSessionRequest.Builder.() -> Unit): GetRemoteAccessSessionResponse = getRemoteAccessSession(GetRemoteAccessSessionRequest.Builder().apply(block).build())

/**
 * Gets information about a run.
 */
public suspend inline fun DeviceFarmClient.getRun(crossinline block: GetRunRequest.Builder.() -> Unit): GetRunResponse = getRun(GetRunRequest.Builder().apply(block).build())

/**
 * Gets information about a suite.
 */
public suspend inline fun DeviceFarmClient.getSuite(crossinline block: GetSuiteRequest.Builder.() -> Unit): GetSuiteResponse = getSuite(GetSuiteRequest.Builder().apply(block).build())

/**
 * Gets information about a test.
 */
public suspend inline fun DeviceFarmClient.getTest(crossinline block: GetTestRequest.Builder.() -> Unit): GetTestResponse = getTest(GetTestRequest.Builder().apply(block).build())

/**
 * Retrieves information about a Selenium testing project.
 */
public suspend inline fun DeviceFarmClient.getTestGridProject(crossinline block: GetTestGridProjectRequest.Builder.() -> Unit): GetTestGridProjectResponse = getTestGridProject(GetTestGridProjectRequest.Builder().apply(block).build())

/**
 * A session is an instance of a browser created through a `RemoteWebDriver` with the URL from CreateTestGridUrlResult$url. You can use the following to look up sessions:
 * + The session ARN (GetTestGridSessionRequest$sessionArn).
 * + The project ARN and a session ID (GetTestGridSessionRequest$projectArn and GetTestGridSessionRequest$sessionId).
 */
public suspend inline fun DeviceFarmClient.getTestGridSession(crossinline block: GetTestGridSessionRequest.Builder.() -> Unit): GetTestGridSessionResponse = getTestGridSession(GetTestGridSessionRequest.Builder().apply(block).build())

/**
 * Gets information about an upload.
 */
public suspend inline fun DeviceFarmClient.getUpload(crossinline block: GetUploadRequest.Builder.() -> Unit): GetUploadResponse = getUpload(GetUploadRequest.Builder().apply(block).build())

/**
 * Returns information about the configuration settings for your Amazon Virtual Private Cloud (VPC) endpoint.
 */
public suspend inline fun DeviceFarmClient.getVpceConfiguration(crossinline block: GetVpceConfigurationRequest.Builder.() -> Unit): GetVpceConfigurationResponse = getVpceConfiguration(GetVpceConfigurationRequest.Builder().apply(block).build())

/**
 * Installs an application to the device in a remote access session. For Android applications, the file must be in .apk format. For iOS applications, the file must be in .ipa format.
 */
public suspend inline fun DeviceFarmClient.installToRemoteAccessSession(crossinline block: InstallToRemoteAccessSessionRequest.Builder.() -> Unit): InstallToRemoteAccessSessionResponse = installToRemoteAccessSession(InstallToRemoteAccessSessionRequest.Builder().apply(block).build())

/**
 * Gets information about artifacts.
 */
public suspend inline fun DeviceFarmClient.listArtifacts(crossinline block: ListArtifactsRequest.Builder.() -> Unit): ListArtifactsResponse = listArtifacts(ListArtifactsRequest.Builder().apply(block).build())

/**
 * Returns information about the private device instances associated with one or more AWS accounts.
 */
public suspend inline fun DeviceFarmClient.listDeviceInstances(crossinline block: ListDeviceInstancesRequest.Builder.() -> Unit): ListDeviceInstancesResponse = listDeviceInstances(ListDeviceInstancesRequest.Builder().apply(block).build())

/**
 * Gets information about device pools.
 */
public suspend inline fun DeviceFarmClient.listDevicePools(crossinline block: ListDevicePoolsRequest.Builder.() -> Unit): ListDevicePoolsResponse = listDevicePools(ListDevicePoolsRequest.Builder().apply(block).build())

/**
 * Gets information about unique device types.
 */
public suspend inline fun DeviceFarmClient.listDevices(crossinline block: ListDevicesRequest.Builder.() -> Unit): ListDevicesResponse = listDevices(ListDevicesRequest.Builder().apply(block).build())

/**
 * Returns information about all the instance profiles in an AWS account.
 */
public suspend inline fun DeviceFarmClient.listInstanceProfiles(crossinline block: ListInstanceProfilesRequest.Builder.() -> Unit): ListInstanceProfilesResponse = listInstanceProfiles(ListInstanceProfilesRequest.Builder().apply(block).build())

/**
 * Gets information about jobs for a given test run.
 */
public suspend inline fun DeviceFarmClient.listJobs(crossinline block: ListJobsRequest.Builder.() -> Unit): ListJobsResponse = listJobs(ListJobsRequest.Builder().apply(block).build())

/**
 * Returns the list of available network profiles.
 */
public suspend inline fun DeviceFarmClient.listNetworkProfiles(crossinline block: ListNetworkProfilesRequest.Builder.() -> Unit): ListNetworkProfilesResponse = listNetworkProfiles(ListNetworkProfilesRequest.Builder().apply(block).build())

/**
 * Returns a list of offering promotions. Each offering promotion record contains the ID and description of the promotion. The API returns a `NotEligible` error if the caller is not permitted to invoke the operation. Contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com) if you must be able to invoke this operation.
 */
public suspend inline fun DeviceFarmClient.listOfferingPromotions(crossinline block: ListOfferingPromotionsRequest.Builder.() -> Unit): ListOfferingPromotionsResponse = listOfferingPromotions(ListOfferingPromotionsRequest.Builder().apply(block).build())

/**
 * Returns a list of all historical purchases, renewals, and system renewal transactions for an AWS account. The list is paginated and ordered by a descending timestamp (most recent transactions are first). The API returns a `NotEligible` error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com).
 */
public suspend inline fun DeviceFarmClient.listOfferingTransactions(crossinline block: ListOfferingTransactionsRequest.Builder.() -> Unit): ListOfferingTransactionsResponse = listOfferingTransactions(ListOfferingTransactionsRequest.Builder().apply(block).build())

/**
 * Returns a list of products or offerings that the user can manage through the API. Each offering record indicates the recurring price per unit and the frequency for that offering. The API returns a `NotEligible` error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com).
 */
public suspend inline fun DeviceFarmClient.listOfferings(crossinline block: ListOfferingsRequest.Builder.() -> Unit): ListOfferingsResponse = listOfferings(ListOfferingsRequest.Builder().apply(block).build())

/**
 * Gets information about projects.
 */
public suspend inline fun DeviceFarmClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Returns a list of all currently running remote access sessions.
 */
public suspend inline fun DeviceFarmClient.listRemoteAccessSessions(crossinline block: ListRemoteAccessSessionsRequest.Builder.() -> Unit): ListRemoteAccessSessionsResponse = listRemoteAccessSessions(ListRemoteAccessSessionsRequest.Builder().apply(block).build())

/**
 * Gets information about runs, given an AWS Device Farm project ARN.
 */
public suspend inline fun DeviceFarmClient.listRuns(crossinline block: ListRunsRequest.Builder.() -> Unit): ListRunsResponse = listRuns(ListRunsRequest.Builder().apply(block).build())

/**
 * Gets information about samples, given an AWS Device Farm job ARN.
 */
public suspend inline fun DeviceFarmClient.listSamples(crossinline block: ListSamplesRequest.Builder.() -> Unit): ListSamplesResponse = listSamples(ListSamplesRequest.Builder().apply(block).build())

/**
 * Gets information about test suites for a given job.
 */
public suspend inline fun DeviceFarmClient.listSuites(crossinline block: ListSuitesRequest.Builder.() -> Unit): ListSuitesResponse = listSuites(ListSuitesRequest.Builder().apply(block).build())

/**
 * List the tags for an AWS Device Farm resource.
 */
public suspend inline fun DeviceFarmClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Gets a list of all Selenium testing projects in your account.
 */
public suspend inline fun DeviceFarmClient.listTestGridProjects(crossinline block: ListTestGridProjectsRequest.Builder.() -> Unit): ListTestGridProjectsResponse = listTestGridProjects(ListTestGridProjectsRequest.Builder().apply(block).build())

/**
 * Returns a list of the actions taken in a TestGridSession.
 */
public suspend inline fun DeviceFarmClient.listTestGridSessionActions(crossinline block: ListTestGridSessionActionsRequest.Builder.() -> Unit): ListTestGridSessionActionsResponse = listTestGridSessionActions(ListTestGridSessionActionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of artifacts created during the session.
 */
public suspend inline fun DeviceFarmClient.listTestGridSessionArtifacts(crossinline block: ListTestGridSessionArtifactsRequest.Builder.() -> Unit): ListTestGridSessionArtifactsResponse = listTestGridSessionArtifacts(ListTestGridSessionArtifactsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of sessions for a TestGridProject.
 */
public suspend inline fun DeviceFarmClient.listTestGridSessions(crossinline block: ListTestGridSessionsRequest.Builder.() -> Unit): ListTestGridSessionsResponse = listTestGridSessions(ListTestGridSessionsRequest.Builder().apply(block).build())

/**
 * Gets information about tests in a given test suite.
 */
public suspend inline fun DeviceFarmClient.listTests(crossinline block: ListTestsRequest.Builder.() -> Unit): ListTestsResponse = listTests(ListTestsRequest.Builder().apply(block).build())

/**
 * Gets information about unique problems, such as exceptions or crashes.
 *
 * Unique problems are defined as a single instance of an error across a run, job, or suite. For example, if a call in your application consistently raises an exception (`OutOfBoundsException in MyActivity.java:386`), `ListUniqueProblems` returns a single entry instead of many individual entries for that exception.
 */
public suspend inline fun DeviceFarmClient.listUniqueProblems(crossinline block: ListUniqueProblemsRequest.Builder.() -> Unit): ListUniqueProblemsResponse = listUniqueProblems(ListUniqueProblemsRequest.Builder().apply(block).build())

/**
 * Gets information about uploads, given an AWS Device Farm project ARN.
 */
public suspend inline fun DeviceFarmClient.listUploads(crossinline block: ListUploadsRequest.Builder.() -> Unit): ListUploadsResponse = listUploads(ListUploadsRequest.Builder().apply(block).build())

/**
 * Returns information about all Amazon Virtual Private Cloud (VPC) endpoint configurations in the AWS account.
 */
public suspend inline fun DeviceFarmClient.listVpceConfigurations(crossinline block: ListVpceConfigurationsRequest.Builder.() -> Unit): ListVpceConfigurationsResponse = listVpceConfigurations(ListVpceConfigurationsRequest.Builder().apply(block).build())

/**
 * Immediately purchases offerings for an AWS account. Offerings renew with the latest total purchased quantity for an offering, unless the renewal was overridden. The API returns a `NotEligible` error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com).
 */
public suspend inline fun DeviceFarmClient.purchaseOffering(crossinline block: PurchaseOfferingRequest.Builder.() -> Unit): PurchaseOfferingResponse = purchaseOffering(PurchaseOfferingRequest.Builder().apply(block).build())

/**
 * Explicitly sets the quantity of devices to renew for an offering, starting from the `effectiveDate` of the next period. The API returns a `NotEligible` error if the user is not permitted to invoke the operation. If you must be able to invoke this operation, contact [aws-devicefarm-support@amazon.com](mailto:aws-devicefarm-support@amazon.com).
 */
public suspend inline fun DeviceFarmClient.renewOffering(crossinline block: RenewOfferingRequest.Builder.() -> Unit): RenewOfferingResponse = renewOffering(RenewOfferingRequest.Builder().apply(block).build())

/**
 * Schedules a run.
 */
public suspend inline fun DeviceFarmClient.scheduleRun(crossinline block: ScheduleRunRequest.Builder.() -> Unit): ScheduleRunResponse = scheduleRun(ScheduleRunRequest.Builder().apply(block).build())

/**
 * Initiates a stop request for the current job. AWS Device Farm immediately stops the job on the device where tests have not started. You are not billed for this device. On the device where tests have started, setup suite and teardown suite tests run to completion on the device. You are billed for setup, teardown, and any tests that were in progress or already completed.
 */
public suspend inline fun DeviceFarmClient.stopJob(crossinline block: StopJobRequest.Builder.() -> Unit): StopJobResponse = stopJob(StopJobRequest.Builder().apply(block).build())

/**
 * Ends a specified remote access session.
 */
public suspend inline fun DeviceFarmClient.stopRemoteAccessSession(crossinline block: StopRemoteAccessSessionRequest.Builder.() -> Unit): StopRemoteAccessSessionResponse = stopRemoteAccessSession(StopRemoteAccessSessionRequest.Builder().apply(block).build())

/**
 * Initiates a stop request for the current test run. AWS Device Farm immediately stops the run on devices where tests have not started. You are not billed for these devices. On devices where tests have started executing, setup suite and teardown suite tests run to completion on those devices. You are billed for setup, teardown, and any tests that were in progress or already completed.
 */
public suspend inline fun DeviceFarmClient.stopRun(crossinline block: StopRunRequest.Builder.() -> Unit): StopRunResponse = stopRun(StopRunRequest.Builder().apply(block).build())

/**
 * Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are also deleted.
 */
public suspend inline fun DeviceFarmClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes the specified tags from a resource.
 */
public suspend inline fun DeviceFarmClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates information about a private device instance.
 */
public suspend inline fun DeviceFarmClient.updateDeviceInstance(crossinline block: UpdateDeviceInstanceRequest.Builder.() -> Unit): UpdateDeviceInstanceResponse = updateDeviceInstance(UpdateDeviceInstanceRequest.Builder().apply(block).build())

/**
 * Modifies the name, description, and rules in a device pool given the attributes and the pool ARN. Rule updates are all-or-nothing, meaning they can only be updated as a whole (or not at all).
 */
public suspend inline fun DeviceFarmClient.updateDevicePool(crossinline block: UpdateDevicePoolRequest.Builder.() -> Unit): UpdateDevicePoolResponse = updateDevicePool(UpdateDevicePoolRequest.Builder().apply(block).build())

/**
 * Updates information about an existing private device instance profile.
 */
public suspend inline fun DeviceFarmClient.updateInstanceProfile(crossinline block: UpdateInstanceProfileRequest.Builder.() -> Unit): UpdateInstanceProfileResponse = updateInstanceProfile(UpdateInstanceProfileRequest.Builder().apply(block).build())

/**
 * Updates the network profile.
 */
public suspend inline fun DeviceFarmClient.updateNetworkProfile(crossinline block: UpdateNetworkProfileRequest.Builder.() -> Unit): UpdateNetworkProfileResponse = updateNetworkProfile(UpdateNetworkProfileRequest.Builder().apply(block).build())

/**
 * Modifies the specified project name, given the project ARN and a new name.
 */
public suspend inline fun DeviceFarmClient.updateProject(crossinline block: UpdateProjectRequest.Builder.() -> Unit): UpdateProjectResponse = updateProject(UpdateProjectRequest.Builder().apply(block).build())

/**
 * Change details of a project.
 */
public suspend inline fun DeviceFarmClient.updateTestGridProject(crossinline block: UpdateTestGridProjectRequest.Builder.() -> Unit): UpdateTestGridProjectResponse = updateTestGridProject(UpdateTestGridProjectRequest.Builder().apply(block).build())

/**
 * Updates an uploaded test spec.
 */
public suspend inline fun DeviceFarmClient.updateUpload(crossinline block: UpdateUploadRequest.Builder.() -> Unit): UpdateUploadResponse = updateUpload(UpdateUploadRequest.Builder().apply(block).build())

/**
 * Updates information about an Amazon Virtual Private Cloud (VPC) endpoint configuration.
 */
public suspend inline fun DeviceFarmClient.updateVpceConfiguration(crossinline block: UpdateVpceConfigurationRequest.Builder.() -> Unit): UpdateVpceConfigurationResponse = updateVpceConfiguration(UpdateVpceConfigurationRequest.Builder().apply(block).build())
