// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.detective.model.DetectiveException
import aws.sdk.kotlin.services.detective.model.GetMembersResponse
import aws.sdk.kotlin.services.detective.model.MemberDetail
import aws.sdk.kotlin.services.detective.model.UnprocessedAccount
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetMembersOperationDeserializer: HttpDeserialize<GetMembersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMembersResponse {
        if (!response.status.isSuccess()) {
            throwGetMembersError(context, response)
        }
        val builder = GetMembersResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMembersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetMembersOperationBody(builder: GetMembersResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MEMBERDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MemberDetails"))
    val UNPROCESSEDACCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedAccounts"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MEMBERDETAILS_DESCRIPTOR)
        field(UNPROCESSEDACCOUNTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MEMBERDETAILS_DESCRIPTOR.index -> builder.memberDetails =
                    deserializer.deserializeList(MEMBERDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<MemberDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMemberDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDACCOUNTS_DESCRIPTOR.index -> builder.unprocessedAccounts =
                    deserializer.deserializeList(UNPROCESSEDACCOUNTS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedAccount>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedAccountDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetMembersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw DetectiveException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
