// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.model



/**
 * A member account that was included in a request but for which the request could not be
 * processed.
 */
class UnprocessedAccount private constructor(builder: BuilderImpl) {
    /**
     * The AWS account identifier of the member account that was not processed.
     */
    val accountId: String? = builder.accountId
    /**
     * The reason that the member account request could not be processed.
     */
    val reason: String? = builder.reason

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UnprocessedAccount = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UnprocessedAccount(")
        append("accountId=$accountId,")
        append("reason=$reason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (reason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UnprocessedAccount

        if (accountId != other.accountId) return false
        if (reason != other.reason) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UnprocessedAccount = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UnprocessedAccount
        /**
         * The AWS account identifier of the member account that was not processed.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The reason that the member account request could not be processed.
         */
        fun reason(reason: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The AWS account identifier of the member account that was not processed.
         */
        var accountId: String?
        /**
         * The reason that the member account request could not be processed.
         */
        var reason: String?

        fun build(): UnprocessedAccount
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var reason: String? = null

        constructor(x: UnprocessedAccount) : this() {
            this.accountId = x.accountId
            this.reason = x.reason
        }

        override fun build(): UnprocessedAccount = UnprocessedAccount(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun reason(reason: String): FluentBuilder = apply { this.reason = reason }
    }
}
