// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about a member account that was invited to contribute to a behavior
 * graph.
 */
class MemberDetail private constructor(builder: BuilderImpl) {
    /**
     * The AWS account identifier for the member account.
     */
    val accountId: String? = builder.accountId
    /**
     * The AWS account identifier of the administrator account for the behavior graph.
     */
    val administratorId: String? = builder.administratorId
    /**
     * For member accounts with a status of ACCEPTED_BUT_DISABLED, the reason that
     * the member account is not enabled.
     * The reason can have one of the following values:
     * VOLUME_TOO_HIGH - Indicates that adding the member account would
     * cause the data volume for the behavior graph to be too high.
     * VOLUME_UNKNOWN - Indicates that Detective is unable to verify the data
     * volume for the member account. This is usually because the member account is not
     * enrolled in Amazon GuardDuty.
     */
    val disabledReason: MemberDisabledReason? = builder.disabledReason
    /**
     * The AWS account root user email address for the member account.
     */
    val emailAddress: String? = builder.emailAddress
    /**
     * The ARN of the behavior graph that the member account was invited to.
     */
    val graphArn: String? = builder.graphArn
    /**
     * The date and time that Detective sent the invitation to the member account. The value is in
     * milliseconds since the epoch.
     */
    val invitedTime: Instant? = builder.invitedTime
    /**
     * The AWS account identifier of the administrator account for the behavior graph.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val masterId: String? = builder.masterId
    /**
     * The member account data volume as a percentage of the maximum allowed data volume. 0
     * indicates 0 percent, and 100 indicates 100 percent.
     * Note that this is not the percentage of the behavior graph data volume.
     * For example, the data volume for the behavior graph is 80 GB per day. The maximum data
     * volume is 160 GB per day. If the data volume for the member account is 40 GB per day, then
     * PercentOfGraphUtilization is 25. It represents 25% of the maximum allowed
     * data volume.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val percentOfGraphUtilization: Double? = builder.percentOfGraphUtilization
    /**
     * The date and time when the graph utilization percentage was last updated.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val percentOfGraphUtilizationUpdatedTime: Instant? = builder.percentOfGraphUtilizationUpdatedTime
    /**
     * The current membership status of the member account. The status can have one of the
     * following values:
     * INVITED - Indicates that the member was sent an invitation but has
     * not yet responded.
     * VERIFICATION_IN_PROGRESS - Indicates that Detective is verifying that the
     * account identifier and email address provided for the member account match. If they
     * do match, then Detective sends the invitation. If the email address and account
     * identifier don't match, then the member cannot be added to the behavior graph.
     * VERIFICATION_FAILED - Indicates that the account and email address
     * provided for the member account do not match, and Detective did not send an invitation to
     * the account.
     * ENABLED - Indicates that the member account accepted the invitation
     * to contribute to the behavior graph.
     * ACCEPTED_BUT_DISABLED - Indicates that the member account accepted
     * the invitation but is prevented from contributing data to the behavior graph.
     * DisabledReason provides the reason why the member account is not
     * enabled.
     * Member accounts that declined an invitation or that were removed from the behavior graph
     * are not included.
     */
    val status: MemberStatus? = builder.status
    /**
     * The date and time that the member account was last updated. The value is in milliseconds
     * since the epoch.
     */
    val updatedTime: Instant? = builder.updatedTime
    /**
     * The data volume in bytes per day for the member account.
     */
    val volumeUsageInBytes: Long? = builder.volumeUsageInBytes
    /**
     * The data and time when the member account data volume was last updated.
     */
    val volumeUsageUpdatedTime: Instant? = builder.volumeUsageUpdatedTime

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): MemberDetail = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("MemberDetail(")
        append("accountId=$accountId,")
        append("administratorId=$administratorId,")
        append("disabledReason=$disabledReason,")
        append("emailAddress=$emailAddress,")
        append("graphArn=$graphArn,")
        append("invitedTime=$invitedTime,")
        append("masterId=$masterId,")
        append("percentOfGraphUtilization=$percentOfGraphUtilization,")
        append("percentOfGraphUtilizationUpdatedTime=$percentOfGraphUtilizationUpdatedTime,")
        append("status=$status,")
        append("updatedTime=$updatedTime,")
        append("volumeUsageInBytes=$volumeUsageInBytes,")
        append("volumeUsageUpdatedTime=$volumeUsageUpdatedTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (administratorId?.hashCode() ?: 0)
        result = 31 * result + (disabledReason?.hashCode() ?: 0)
        result = 31 * result + (emailAddress?.hashCode() ?: 0)
        result = 31 * result + (graphArn?.hashCode() ?: 0)
        result = 31 * result + (invitedTime?.hashCode() ?: 0)
        result = 31 * result + (masterId?.hashCode() ?: 0)
        result = 31 * result + (percentOfGraphUtilization?.hashCode() ?: 0)
        result = 31 * result + (percentOfGraphUtilizationUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedTime?.hashCode() ?: 0)
        result = 31 * result + (volumeUsageInBytes?.hashCode() ?: 0)
        result = 31 * result + (volumeUsageUpdatedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as MemberDetail

        if (accountId != other.accountId) return false
        if (administratorId != other.administratorId) return false
        if (disabledReason != other.disabledReason) return false
        if (emailAddress != other.emailAddress) return false
        if (graphArn != other.graphArn) return false
        if (invitedTime != other.invitedTime) return false
        if (masterId != other.masterId) return false
        if (percentOfGraphUtilization != other.percentOfGraphUtilization) return false
        if (percentOfGraphUtilizationUpdatedTime != other.percentOfGraphUtilizationUpdatedTime) return false
        if (status != other.status) return false
        if (updatedTime != other.updatedTime) return false
        if (volumeUsageInBytes != other.volumeUsageInBytes) return false
        if (volumeUsageUpdatedTime != other.volumeUsageUpdatedTime) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): MemberDetail = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): MemberDetail
        /**
         * The AWS account identifier for the member account.
         */
        fun accountId(accountId: String): FluentBuilder
        /**
         * The AWS account identifier of the administrator account for the behavior graph.
         */
        fun administratorId(administratorId: String): FluentBuilder
        /**
         * For member accounts with a status of ACCEPTED_BUT_DISABLED, the reason that
         * the member account is not enabled.
         * The reason can have one of the following values:
         * VOLUME_TOO_HIGH - Indicates that adding the member account would
         * cause the data volume for the behavior graph to be too high.
         * VOLUME_UNKNOWN - Indicates that Detective is unable to verify the data
         * volume for the member account. This is usually because the member account is not
         * enrolled in Amazon GuardDuty.
         */
        fun disabledReason(disabledReason: MemberDisabledReason): FluentBuilder
        /**
         * The AWS account root user email address for the member account.
         */
        fun emailAddress(emailAddress: String): FluentBuilder
        /**
         * The ARN of the behavior graph that the member account was invited to.
         */
        fun graphArn(graphArn: String): FluentBuilder
        /**
         * The date and time that Detective sent the invitation to the member account. The value is in
         * milliseconds since the epoch.
         */
        fun invitedTime(invitedTime: Instant): FluentBuilder
        /**
         * The AWS account identifier of the administrator account for the behavior graph.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        fun masterId(masterId: String): FluentBuilder
        /**
         * The member account data volume as a percentage of the maximum allowed data volume. 0
         * indicates 0 percent, and 100 indicates 100 percent.
         * Note that this is not the percentage of the behavior graph data volume.
         * For example, the data volume for the behavior graph is 80 GB per day. The maximum data
         * volume is 160 GB per day. If the data volume for the member account is 40 GB per day, then
         * PercentOfGraphUtilization is 25. It represents 25% of the maximum allowed
         * data volume.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        fun percentOfGraphUtilization(percentOfGraphUtilization: Double): FluentBuilder
        /**
         * The date and time when the graph utilization percentage was last updated.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        fun percentOfGraphUtilizationUpdatedTime(percentOfGraphUtilizationUpdatedTime: Instant): FluentBuilder
        /**
         * The current membership status of the member account. The status can have one of the
         * following values:
         * INVITED - Indicates that the member was sent an invitation but has
         * not yet responded.
         * VERIFICATION_IN_PROGRESS - Indicates that Detective is verifying that the
         * account identifier and email address provided for the member account match. If they
         * do match, then Detective sends the invitation. If the email address and account
         * identifier don't match, then the member cannot be added to the behavior graph.
         * VERIFICATION_FAILED - Indicates that the account and email address
         * provided for the member account do not match, and Detective did not send an invitation to
         * the account.
         * ENABLED - Indicates that the member account accepted the invitation
         * to contribute to the behavior graph.
         * ACCEPTED_BUT_DISABLED - Indicates that the member account accepted
         * the invitation but is prevented from contributing data to the behavior graph.
         * DisabledReason provides the reason why the member account is not
         * enabled.
         * Member accounts that declined an invitation or that were removed from the behavior graph
         * are not included.
         */
        fun status(status: MemberStatus): FluentBuilder
        /**
         * The date and time that the member account was last updated. The value is in milliseconds
         * since the epoch.
         */
        fun updatedTime(updatedTime: Instant): FluentBuilder
        /**
         * The data volume in bytes per day for the member account.
         */
        fun volumeUsageInBytes(volumeUsageInBytes: Long): FluentBuilder
        /**
         * The data and time when the member account data volume was last updated.
         */
        fun volumeUsageUpdatedTime(volumeUsageUpdatedTime: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The AWS account identifier for the member account.
         */
        var accountId: String?
        /**
         * The AWS account identifier of the administrator account for the behavior graph.
         */
        var administratorId: String?
        /**
         * For member accounts with a status of ACCEPTED_BUT_DISABLED, the reason that
         * the member account is not enabled.
         * The reason can have one of the following values:
         * VOLUME_TOO_HIGH - Indicates that adding the member account would
         * cause the data volume for the behavior graph to be too high.
         * VOLUME_UNKNOWN - Indicates that Detective is unable to verify the data
         * volume for the member account. This is usually because the member account is not
         * enrolled in Amazon GuardDuty.
         */
        var disabledReason: MemberDisabledReason?
        /**
         * The AWS account root user email address for the member account.
         */
        var emailAddress: String?
        /**
         * The ARN of the behavior graph that the member account was invited to.
         */
        var graphArn: String?
        /**
         * The date and time that Detective sent the invitation to the member account. The value is in
         * milliseconds since the epoch.
         */
        var invitedTime: Instant?
        /**
         * The AWS account identifier of the administrator account for the behavior graph.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var masterId: String?
        /**
         * The member account data volume as a percentage of the maximum allowed data volume. 0
         * indicates 0 percent, and 100 indicates 100 percent.
         * Note that this is not the percentage of the behavior graph data volume.
         * For example, the data volume for the behavior graph is 80 GB per day. The maximum data
         * volume is 160 GB per day. If the data volume for the member account is 40 GB per day, then
         * PercentOfGraphUtilization is 25. It represents 25% of the maximum allowed
         * data volume.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var percentOfGraphUtilization: Double?
        /**
         * The date and time when the graph utilization percentage was last updated.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var percentOfGraphUtilizationUpdatedTime: Instant?
        /**
         * The current membership status of the member account. The status can have one of the
         * following values:
         * INVITED - Indicates that the member was sent an invitation but has
         * not yet responded.
         * VERIFICATION_IN_PROGRESS - Indicates that Detective is verifying that the
         * account identifier and email address provided for the member account match. If they
         * do match, then Detective sends the invitation. If the email address and account
         * identifier don't match, then the member cannot be added to the behavior graph.
         * VERIFICATION_FAILED - Indicates that the account and email address
         * provided for the member account do not match, and Detective did not send an invitation to
         * the account.
         * ENABLED - Indicates that the member account accepted the invitation
         * to contribute to the behavior graph.
         * ACCEPTED_BUT_DISABLED - Indicates that the member account accepted
         * the invitation but is prevented from contributing data to the behavior graph.
         * DisabledReason provides the reason why the member account is not
         * enabled.
         * Member accounts that declined an invitation or that were removed from the behavior graph
         * are not included.
         */
        var status: MemberStatus?
        /**
         * The date and time that the member account was last updated. The value is in milliseconds
         * since the epoch.
         */
        var updatedTime: Instant?
        /**
         * The data volume in bytes per day for the member account.
         */
        var volumeUsageInBytes: Long?
        /**
         * The data and time when the member account data volume was last updated.
         */
        var volumeUsageUpdatedTime: Instant?

        fun build(): MemberDetail
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accountId: String? = null
        override var administratorId: String? = null
        override var disabledReason: MemberDisabledReason? = null
        override var emailAddress: String? = null
        override var graphArn: String? = null
        override var invitedTime: Instant? = null
        override var masterId: String? = null
        override var percentOfGraphUtilization: Double? = null
        override var percentOfGraphUtilizationUpdatedTime: Instant? = null
        override var status: MemberStatus? = null
        override var updatedTime: Instant? = null
        override var volumeUsageInBytes: Long? = null
        override var volumeUsageUpdatedTime: Instant? = null

        constructor(x: MemberDetail) : this() {
            this.accountId = x.accountId
            this.administratorId = x.administratorId
            this.disabledReason = x.disabledReason
            this.emailAddress = x.emailAddress
            this.graphArn = x.graphArn
            this.invitedTime = x.invitedTime
            this.masterId = x.masterId
            this.percentOfGraphUtilization = x.percentOfGraphUtilization
            this.percentOfGraphUtilizationUpdatedTime = x.percentOfGraphUtilizationUpdatedTime
            this.status = x.status
            this.updatedTime = x.updatedTime
            this.volumeUsageInBytes = x.volumeUsageInBytes
            this.volumeUsageUpdatedTime = x.volumeUsageUpdatedTime
        }

        override fun build(): MemberDetail = MemberDetail(this)
        override fun accountId(accountId: String): FluentBuilder = apply { this.accountId = accountId }
        override fun administratorId(administratorId: String): FluentBuilder = apply { this.administratorId = administratorId }
        override fun disabledReason(disabledReason: MemberDisabledReason): FluentBuilder = apply { this.disabledReason = disabledReason }
        override fun emailAddress(emailAddress: String): FluentBuilder = apply { this.emailAddress = emailAddress }
        override fun graphArn(graphArn: String): FluentBuilder = apply { this.graphArn = graphArn }
        override fun invitedTime(invitedTime: Instant): FluentBuilder = apply { this.invitedTime = invitedTime }
        override fun masterId(masterId: String): FluentBuilder = apply { this.masterId = masterId }
        override fun percentOfGraphUtilization(percentOfGraphUtilization: Double): FluentBuilder = apply { this.percentOfGraphUtilization = percentOfGraphUtilization }
        override fun percentOfGraphUtilizationUpdatedTime(percentOfGraphUtilizationUpdatedTime: Instant): FluentBuilder = apply { this.percentOfGraphUtilizationUpdatedTime = percentOfGraphUtilizationUpdatedTime }
        override fun status(status: MemberStatus): FluentBuilder = apply { this.status = status }
        override fun updatedTime(updatedTime: Instant): FluentBuilder = apply { this.updatedTime = updatedTime }
        override fun volumeUsageInBytes(volumeUsageInBytes: Long): FluentBuilder = apply { this.volumeUsageInBytes = volumeUsageInBytes }
        override fun volumeUsageUpdatedTime(volumeUsageUpdatedTime: Instant): FluentBuilder = apply { this.volumeUsageUpdatedTime = volumeUsageUpdatedTime }
    }
}
