// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.model



class ListMembersRequest private constructor(builder: BuilderImpl) {
    /**
     * The ARN of the behavior graph for which to retrieve the list of member accounts.
     */
    val graphArn: String? = builder.graphArn
    /**
     * The maximum number of member accounts to include in the response. The total must be less
     * than the overall limit on the number of results to return, which is currently 200.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * For requests to retrieve the next page of member account results, the pagination token
     * that was returned with the previous page of results. The initial request does not include a
     * pagination token.
     */
    val nextToken: String? = builder.nextToken

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListMembersRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListMembersRequest(")
        append("graphArn=$graphArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = graphArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListMembersRequest

        if (graphArn != other.graphArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListMembersRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListMembersRequest
        /**
         * The ARN of the behavior graph for which to retrieve the list of member accounts.
         */
        fun graphArn(graphArn: String): FluentBuilder
        /**
         * The maximum number of member accounts to include in the response. The total must be less
         * than the overall limit on the number of results to return, which is currently 200.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * For requests to retrieve the next page of member account results, the pagination token
         * that was returned with the previous page of results. The initial request does not include a
         * pagination token.
         */
        fun nextToken(nextToken: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ARN of the behavior graph for which to retrieve the list of member accounts.
         */
        var graphArn: String?
        /**
         * The maximum number of member accounts to include in the response. The total must be less
         * than the overall limit on the number of results to return, which is currently 200.
         */
        var maxResults: Int?
        /**
         * For requests to retrieve the next page of member account results, the pagination token
         * that was returned with the previous page of results. The initial request does not include a
         * pagination token.
         */
        var nextToken: String?

        fun build(): ListMembersRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var graphArn: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null

        constructor(x: ListMembersRequest) : this() {
            this.graphArn = x.graphArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        override fun build(): ListMembersRequest = ListMembersRequest(this)
        override fun graphArn(graphArn: String): FluentBuilder = apply { this.graphArn = graphArn }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
    }
}
