// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.model



class CreateMembersRequest private constructor(builder: BuilderImpl) {
    /**
     * The list of AWS accounts to invite to become member accounts in the behavior graph.
     * You can invite up to 50 accounts at a time. For each invited account, the account list
     * contains the account identifier and the AWS account root user email address.
     */
    val accounts: List<Account>? = builder.accounts
    /**
     * if set to true, then the member accounts do not receive email
     * notifications. By default, this is set to false, and the member accounts
     * receive email notifications.
     */
    val disableEmailNotification: Boolean = builder.disableEmailNotification
    /**
     * The ARN of the behavior graph to invite the member accounts to contribute their data
     * to.
     */
    val graphArn: String? = builder.graphArn
    /**
     * Customized message text to include in the invitation email message to the invited member
     * accounts.
     */
    val message: String? = builder.message

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateMembersRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMembersRequest(")
        append("accounts=$accounts,")
        append("disableEmailNotification=$disableEmailNotification,")
        append("graphArn=$graphArn,")
        append("message=$message)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accounts?.hashCode() ?: 0
        result = 31 * result + (disableEmailNotification.hashCode())
        result = 31 * result + (graphArn?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateMembersRequest

        if (accounts != other.accounts) return false
        if (disableEmailNotification != other.disableEmailNotification) return false
        if (graphArn != other.graphArn) return false
        if (message != other.message) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateMembersRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateMembersRequest
        /**
         * The list of AWS accounts to invite to become member accounts in the behavior graph.
         * You can invite up to 50 accounts at a time. For each invited account, the account list
         * contains the account identifier and the AWS account root user email address.
         */
        fun accounts(accounts: List<Account>): FluentBuilder
        /**
         * if set to true, then the member accounts do not receive email
         * notifications. By default, this is set to false, and the member accounts
         * receive email notifications.
         */
        fun disableEmailNotification(disableEmailNotification: Boolean): FluentBuilder
        /**
         * The ARN of the behavior graph to invite the member accounts to contribute their data
         * to.
         */
        fun graphArn(graphArn: String): FluentBuilder
        /**
         * Customized message text to include in the invitation email message to the invited member
         * accounts.
         */
        fun message(message: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The list of AWS accounts to invite to become member accounts in the behavior graph.
         * You can invite up to 50 accounts at a time. For each invited account, the account list
         * contains the account identifier and the AWS account root user email address.
         */
        var accounts: List<Account>?
        /**
         * if set to true, then the member accounts do not receive email
         * notifications. By default, this is set to false, and the member accounts
         * receive email notifications.
         */
        var disableEmailNotification: Boolean
        /**
         * The ARN of the behavior graph to invite the member accounts to contribute their data
         * to.
         */
        var graphArn: String?
        /**
         * Customized message text to include in the invitation email message to the invited member
         * accounts.
         */
        var message: String?

        fun build(): CreateMembersRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accounts: List<Account>? = null
        override var disableEmailNotification: Boolean = false
        override var graphArn: String? = null
        override var message: String? = null

        constructor(x: CreateMembersRequest) : this() {
            this.accounts = x.accounts
            this.disableEmailNotification = x.disableEmailNotification
            this.graphArn = x.graphArn
            this.message = x.message
        }

        override fun build(): CreateMembersRequest = CreateMembersRequest(this)
        override fun accounts(accounts: List<Account>): FluentBuilder = apply { this.accounts = accounts }
        override fun disableEmailNotification(disableEmailNotification: Boolean): FluentBuilder = apply { this.disableEmailNotification = disableEmailNotification }
        override fun graphArn(graphArn: String): FluentBuilder = apply { this.graphArn = graphArn }
        override fun message(message: String): FluentBuilder = apply { this.message = message }
    }
}
