// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.regions.RegionConfig
import aws.sdk.kotlin.services.detective.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine

/**
 * Detective uses machine learning and purpose-built visualizations to help you analyze and
 * investigate security issues across your Amazon Web Services (AWS) workloads. Detective automatically
 * extracts time-based events such as login attempts, API calls, and network traffic from
 * AWS CloudTrail and Amazon Virtual Private Cloud (Amazon VPC) flow logs. It also extracts findings detected by
 * Amazon GuardDuty.
 * The Detective API primarily supports the creation and management of behavior graphs. A
 * behavior graph contains the extracted data from a set of member accounts, and is created
 * and managed by an administrator account.
 * Every behavior graph is specific to a Region. You can only use the API to manage graphs
 * that belong to the Region that is associated with the currently selected endpoint.
 * A Detective administrator account can use the Detective API to do the following:
 * Enable and disable Detective. Enabling Detective creates a new behavior graph.
 * View the list of member accounts in a behavior graph.
 * Add member accounts to a behavior graph.
 * Remove member accounts from a behavior graph.
 * A member account can use the Detective API to do the following:
 * View the list of behavior graphs that they are invited to.
 * Accept an invitation to contribute to a behavior graph.
 * Decline an invitation to contribute to a behavior graph.
 * Remove their account from a behavior graph.
 * All API actions are logged as CloudTrail events. See <a href="https://docs.aws.amazon.com/detective/latest/adminguide/logging-using-cloudtrail.html">Logging Detective API Calls with CloudTrail.
 * We replaced the term "master account" with the term "administrator account." An
 * administrator account is used to centrally manage multiple accounts. In the case of
 * Detective, the administrator account manages the accounts in their behavior graph.
 */
interface DetectiveClient : SdkClient {

    override val serviceName: String
        get() = "Detective"
    /**
     * DetectiveClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): DetectiveClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultDetectiveClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String? = builder.region
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Accepts an invitation for the member account to contribute data to a behavior graph.
     * This operation can only be called by an invited member account.
     * The request provides the ARN of behavior graph.
     * The member account status in the graph must be INVITED.
     */
    suspend fun acceptInvitation(input: AcceptInvitationRequest): AcceptInvitationResponse

    /**
     * Accepts an invitation for the member account to contribute data to a behavior graph.
     * This operation can only be called by an invited member account.
     * The request provides the ARN of behavior graph.
     * The member account status in the graph must be INVITED.
     */
    suspend fun acceptInvitation(block: AcceptInvitationRequest.DslBuilder.() -> Unit) = acceptInvitation(AcceptInvitationRequest.builder().apply(block).build())

    /**
     * Creates a new behavior graph for the calling account, and sets that account as the
     * administrator account. This operation is called by the account that is enabling
     * Detective.
     * Before you try to enable Detective, make sure that your account has been enrolled in
     * Amazon GuardDuty for at least 48 hours. If you do not meet this requirement, you cannot enable
     * Detective. If you do meet the GuardDuty prerequisite, then when you make the request to enable
     * Detective, it checks whether your data volume is within the Detective quota. If it exceeds the
     * quota, then you cannot enable Detective.
     * The operation also enables Detective for the calling account in the currently selected
     * Region. It returns the ARN of the new behavior graph.
     * CreateGraph triggers a process to create the corresponding data tables for
     * the new behavior graph.
     * An account can only be the administrator account for one behavior graph within a Region.
     * If the same account calls CreateGraph with the same administrator account, it
     * always returns the same behavior graph ARN. It does not create a new behavior graph.
     */
    suspend fun createGraph(input: CreateGraphRequest): CreateGraphResponse

    /**
     * Creates a new behavior graph for the calling account, and sets that account as the
     * administrator account. This operation is called by the account that is enabling
     * Detective.
     * Before you try to enable Detective, make sure that your account has been enrolled in
     * Amazon GuardDuty for at least 48 hours. If you do not meet this requirement, you cannot enable
     * Detective. If you do meet the GuardDuty prerequisite, then when you make the request to enable
     * Detective, it checks whether your data volume is within the Detective quota. If it exceeds the
     * quota, then you cannot enable Detective.
     * The operation also enables Detective for the calling account in the currently selected
     * Region. It returns the ARN of the new behavior graph.
     * CreateGraph triggers a process to create the corresponding data tables for
     * the new behavior graph.
     * An account can only be the administrator account for one behavior graph within a Region.
     * If the same account calls CreateGraph with the same administrator account, it
     * always returns the same behavior graph ARN. It does not create a new behavior graph.
     */
    suspend fun createGraph(block: CreateGraphRequest.DslBuilder.() -> Unit) = createGraph(CreateGraphRequest.builder().apply(block).build())

    /**
     * Sends a request to invite the specified AWS accounts to be member accounts in the
     * behavior graph. This operation can only be called by the administrator account for a
     * behavior graph.
     * CreateMembers verifies the accounts and then invites the verified accounts.
     * The administrator can optionally specify to not send invitation emails to the member
     * accounts. This would be used when the administrator manages their member accounts
     * centrally.
     * The request provides the behavior graph ARN and the list of accounts to invite.
     * The response separates the requested accounts into two lists:
     * The accounts that CreateMembers was able to start the verification
     * for. This list includes member accounts that are being verified, that have passed
     * verification and are to be invited, and that have failed verification.
     * The accounts that CreateMembers was unable to process. This list
     * includes accounts that were already invited to be member accounts in the behavior
     * graph.
     */
    suspend fun createMembers(input: CreateMembersRequest): CreateMembersResponse

    /**
     * Sends a request to invite the specified AWS accounts to be member accounts in the
     * behavior graph. This operation can only be called by the administrator account for a
     * behavior graph.
     * CreateMembers verifies the accounts and then invites the verified accounts.
     * The administrator can optionally specify to not send invitation emails to the member
     * accounts. This would be used when the administrator manages their member accounts
     * centrally.
     * The request provides the behavior graph ARN and the list of accounts to invite.
     * The response separates the requested accounts into two lists:
     * The accounts that CreateMembers was able to start the verification
     * for. This list includes member accounts that are being verified, that have passed
     * verification and are to be invited, and that have failed verification.
     * The accounts that CreateMembers was unable to process. This list
     * includes accounts that were already invited to be member accounts in the behavior
     * graph.
     */
    suspend fun createMembers(block: CreateMembersRequest.DslBuilder.() -> Unit) = createMembers(CreateMembersRequest.builder().apply(block).build())

    /**
     * Disables the specified behavior graph and queues it to be deleted. This operation
     * removes the graph from each member account's list of behavior graphs.
     * DeleteGraph can only be called by the administrator account for a behavior
     * graph.
     */
    suspend fun deleteGraph(input: DeleteGraphRequest): DeleteGraphResponse

    /**
     * Disables the specified behavior graph and queues it to be deleted. This operation
     * removes the graph from each member account's list of behavior graphs.
     * DeleteGraph can only be called by the administrator account for a behavior
     * graph.
     */
    suspend fun deleteGraph(block: DeleteGraphRequest.DslBuilder.() -> Unit) = deleteGraph(DeleteGraphRequest.builder().apply(block).build())

    /**
     * Deletes one or more member accounts from the administrator account's behavior graph.
     * This operation can only be called by a Detective administrator account. That account cannot use
     * DeleteMembers to delete their own account from the behavior graph. To
     * disable a behavior graph, the administrator account uses the DeleteGraph API
     * method.
     */
    suspend fun deleteMembers(input: DeleteMembersRequest): DeleteMembersResponse

    /**
     * Deletes one or more member accounts from the administrator account's behavior graph.
     * This operation can only be called by a Detective administrator account. That account cannot use
     * DeleteMembers to delete their own account from the behavior graph. To
     * disable a behavior graph, the administrator account uses the DeleteGraph API
     * method.
     */
    suspend fun deleteMembers(block: DeleteMembersRequest.DslBuilder.() -> Unit) = deleteMembers(DeleteMembersRequest.builder().apply(block).build())

    /**
     * Removes the member account from the specified behavior graph. This operation can only be
     * called by a member account that has the ENABLED status.
     */
    suspend fun disassociateMembership(input: DisassociateMembershipRequest): DisassociateMembershipResponse

    /**
     * Removes the member account from the specified behavior graph. This operation can only be
     * called by a member account that has the ENABLED status.
     */
    suspend fun disassociateMembership(block: DisassociateMembershipRequest.DslBuilder.() -> Unit) = disassociateMembership(DisassociateMembershipRequest.builder().apply(block).build())

    /**
     * Returns the membership details for specified member accounts for a behavior
     * graph.
     */
    suspend fun getMembers(input: GetMembersRequest): GetMembersResponse

    /**
     * Returns the membership details for specified member accounts for a behavior
     * graph.
     */
    suspend fun getMembers(block: GetMembersRequest.DslBuilder.() -> Unit) = getMembers(GetMembersRequest.builder().apply(block).build())

    /**
     * Returns the list of behavior graphs that the calling account is an administrator account
     * of. This operation can only be called by an administrator account.
     * Because an account can currently only be the administrator of one behavior graph within
     * a Region, the results always contain a single behavior graph.
     */
    suspend fun listGraphs(input: ListGraphsRequest): ListGraphsResponse

    /**
     * Returns the list of behavior graphs that the calling account is an administrator account
     * of. This operation can only be called by an administrator account.
     * Because an account can currently only be the administrator of one behavior graph within
     * a Region, the results always contain a single behavior graph.
     */
    suspend fun listGraphs(block: ListGraphsRequest.DslBuilder.() -> Unit) = listGraphs(ListGraphsRequest.builder().apply(block).build())

    /**
     * Retrieves the list of open and accepted behavior graph invitations for the member
     * account. This operation can only be called by a member account.
     * Open invitations are invitations that the member account has not responded to.
     * The results do not include behavior graphs for which the member account declined the
     * invitation. The results also do not include behavior graphs that the member account
     * resigned from or was removed from.
     */
    suspend fun listInvitations(input: ListInvitationsRequest): ListInvitationsResponse

    /**
     * Retrieves the list of open and accepted behavior graph invitations for the member
     * account. This operation can only be called by a member account.
     * Open invitations are invitations that the member account has not responded to.
     * The results do not include behavior graphs for which the member account declined the
     * invitation. The results also do not include behavior graphs that the member account
     * resigned from or was removed from.
     */
    suspend fun listInvitations(block: ListInvitationsRequest.DslBuilder.() -> Unit) = listInvitations(ListInvitationsRequest.builder().apply(block).build())

    /**
     * Retrieves the list of member accounts for a behavior graph. Does not return member
     * accounts that were removed from the behavior graph.
     */
    suspend fun listMembers(input: ListMembersRequest): ListMembersResponse

    /**
     * Retrieves the list of member accounts for a behavior graph. Does not return member
     * accounts that were removed from the behavior graph.
     */
    suspend fun listMembers(block: ListMembersRequest.DslBuilder.() -> Unit) = listMembers(ListMembersRequest.builder().apply(block).build())

    /**
     * Returns the tag values that are assigned to a behavior graph.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns the tag values that are assigned to a behavior graph.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Rejects an invitation to contribute the account data to a behavior graph. This operation
     * must be called by a member account that has the INVITED status.
     */
    suspend fun rejectInvitation(input: RejectInvitationRequest): RejectInvitationResponse

    /**
     * Rejects an invitation to contribute the account data to a behavior graph. This operation
     * must be called by a member account that has the INVITED status.
     */
    suspend fun rejectInvitation(block: RejectInvitationRequest.DslBuilder.() -> Unit) = rejectInvitation(RejectInvitationRequest.builder().apply(block).build())

    /**
     * Sends a request to enable data ingest for a member account that has a status of
     * ACCEPTED_BUT_DISABLED.
     * For valid member accounts, the status is updated as follows.
     * If Detective enabled the member account, then the new status is
     * ENABLED.
     * If Detective cannot enable the member account, the status remains
     * ACCEPTED_BUT_DISABLED.
     */
    suspend fun startMonitoringMember(input: StartMonitoringMemberRequest): StartMonitoringMemberResponse

    /**
     * Sends a request to enable data ingest for a member account that has a status of
     * ACCEPTED_BUT_DISABLED.
     * For valid member accounts, the status is updated as follows.
     * If Detective enabled the member account, then the new status is
     * ENABLED.
     * If Detective cannot enable the member account, the status remains
     * ACCEPTED_BUT_DISABLED.
     */
    suspend fun startMonitoringMember(block: StartMonitoringMemberRequest.DslBuilder.() -> Unit) = startMonitoringMember(StartMonitoringMemberRequest.builder().apply(block).build())

    /**
     * Applies tag values to a behavior graph.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Applies tag values to a behavior graph.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes tags from a behavior graph.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from a behavior graph.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())
}
