// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.regions.resolveRegionForOperation
import aws.sdk.kotlin.services.detective.model.*
import aws.sdk.kotlin.services.detective.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngineConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Detective"
const val ServiceApiVersion: String = "2018-10-26"
const val SdkVersion: String = "0.6.0-alpha"

internal class DefaultDetectiveClient(override val config: DetectiveClient.Config) : DetectiveClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine(HttpClientEngineConfig())
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Accepts an invitation for the member account to contribute data to a behavior graph.
     * This operation can only be called by an invited member account.
     * The request provides the ARN of behavior graph.
     * The member account status in the graph must be INVITED.
     */
    override suspend fun acceptInvitation(input: AcceptInvitationRequest): AcceptInvitationResponse {
        val op = SdkHttpOperation.build<AcceptInvitationRequest, AcceptInvitationResponse> {
            serializer = AcceptInvitationOperationSerializer()
            deserializer = AcceptInvitationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptInvitation"
            }
        }
        registerAcceptInvitationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new behavior graph for the calling account, and sets that account as the
     * administrator account. This operation is called by the account that is enabling
     * Detective.
     * Before you try to enable Detective, make sure that your account has been enrolled in
     * Amazon GuardDuty for at least 48 hours. If you do not meet this requirement, you cannot enable
     * Detective. If you do meet the GuardDuty prerequisite, then when you make the request to enable
     * Detective, it checks whether your data volume is within the Detective quota. If it exceeds the
     * quota, then you cannot enable Detective.
     * The operation also enables Detective for the calling account in the currently selected
     * Region. It returns the ARN of the new behavior graph.
     * CreateGraph triggers a process to create the corresponding data tables for
     * the new behavior graph.
     * An account can only be the administrator account for one behavior graph within a Region.
     * If the same account calls CreateGraph with the same administrator account, it
     * always returns the same behavior graph ARN. It does not create a new behavior graph.
     */
    override suspend fun createGraph(input: CreateGraphRequest): CreateGraphResponse {
        val op = SdkHttpOperation.build<CreateGraphRequest, CreateGraphResponse> {
            serializer = CreateGraphOperationSerializer()
            deserializer = CreateGraphOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGraph"
            }
        }
        registerCreateGraphMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sends a request to invite the specified AWS accounts to be member accounts in the
     * behavior graph. This operation can only be called by the administrator account for a
     * behavior graph.
     * CreateMembers verifies the accounts and then invites the verified accounts.
     * The administrator can optionally specify to not send invitation emails to the member
     * accounts. This would be used when the administrator manages their member accounts
     * centrally.
     * The request provides the behavior graph ARN and the list of accounts to invite.
     * The response separates the requested accounts into two lists:
     * The accounts that CreateMembers was able to start the verification
     * for. This list includes member accounts that are being verified, that have passed
     * verification and are to be invited, and that have failed verification.
     * The accounts that CreateMembers was unable to process. This list
     * includes accounts that were already invited to be member accounts in the behavior
     * graph.
     */
    override suspend fun createMembers(input: CreateMembersRequest): CreateMembersResponse {
        val op = SdkHttpOperation.build<CreateMembersRequest, CreateMembersResponse> {
            serializer = CreateMembersOperationSerializer()
            deserializer = CreateMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMembers"
            }
        }
        registerCreateMembersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the specified behavior graph and queues it to be deleted. This operation
     * removes the graph from each member account's list of behavior graphs.
     * DeleteGraph can only be called by the administrator account for a behavior
     * graph.
     */
    override suspend fun deleteGraph(input: DeleteGraphRequest): DeleteGraphResponse {
        val op = SdkHttpOperation.build<DeleteGraphRequest, DeleteGraphResponse> {
            serializer = DeleteGraphOperationSerializer()
            deserializer = DeleteGraphOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGraph"
            }
        }
        registerDeleteGraphMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes one or more member accounts from the administrator account's behavior graph.
     * This operation can only be called by a Detective administrator account. That account cannot use
     * DeleteMembers to delete their own account from the behavior graph. To
     * disable a behavior graph, the administrator account uses the DeleteGraph API
     * method.
     */
    override suspend fun deleteMembers(input: DeleteMembersRequest): DeleteMembersResponse {
        val op = SdkHttpOperation.build<DeleteMembersRequest, DeleteMembersResponse> {
            serializer = DeleteMembersOperationSerializer()
            deserializer = DeleteMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMembers"
            }
        }
        registerDeleteMembersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the member account from the specified behavior graph. This operation can only be
     * called by a member account that has the ENABLED status.
     */
    override suspend fun disassociateMembership(input: DisassociateMembershipRequest): DisassociateMembershipResponse {
        val op = SdkHttpOperation.build<DisassociateMembershipRequest, DisassociateMembershipResponse> {
            serializer = DisassociateMembershipOperationSerializer()
            deserializer = DisassociateMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateMembership"
            }
        }
        registerDisassociateMembershipMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the membership details for specified member accounts for a behavior
     * graph.
     */
    override suspend fun getMembers(input: GetMembersRequest): GetMembersResponse {
        val op = SdkHttpOperation.build<GetMembersRequest, GetMembersResponse> {
            serializer = GetMembersOperationSerializer()
            deserializer = GetMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMembers"
            }
        }
        registerGetMembersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of behavior graphs that the calling account is an administrator account
     * of. This operation can only be called by an administrator account.
     * Because an account can currently only be the administrator of one behavior graph within
     * a Region, the results always contain a single behavior graph.
     */
    override suspend fun listGraphs(input: ListGraphsRequest): ListGraphsResponse {
        val op = SdkHttpOperation.build<ListGraphsRequest, ListGraphsResponse> {
            serializer = ListGraphsOperationSerializer()
            deserializer = ListGraphsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGraphs"
            }
        }
        registerListGraphsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the list of open and accepted behavior graph invitations for the member
     * account. This operation can only be called by a member account.
     * Open invitations are invitations that the member account has not responded to.
     * The results do not include behavior graphs for which the member account declined the
     * invitation. The results also do not include behavior graphs that the member account
     * resigned from or was removed from.
     */
    override suspend fun listInvitations(input: ListInvitationsRequest): ListInvitationsResponse {
        val op = SdkHttpOperation.build<ListInvitationsRequest, ListInvitationsResponse> {
            serializer = ListInvitationsOperationSerializer()
            deserializer = ListInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInvitations"
            }
        }
        registerListInvitationsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the list of member accounts for a behavior graph. Does not return member
     * accounts that were removed from the behavior graph.
     */
    override suspend fun listMembers(input: ListMembersRequest): ListMembersResponse {
        val op = SdkHttpOperation.build<ListMembersRequest, ListMembersResponse> {
            serializer = ListMembersOperationSerializer()
            deserializer = ListMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMembers"
            }
        }
        registerListMembersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the tag values that are assigned to a behavior graph.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Rejects an invitation to contribute the account data to a behavior graph. This operation
     * must be called by a member account that has the INVITED status.
     */
    override suspend fun rejectInvitation(input: RejectInvitationRequest): RejectInvitationResponse {
        val op = SdkHttpOperation.build<RejectInvitationRequest, RejectInvitationResponse> {
            serializer = RejectInvitationOperationSerializer()
            deserializer = RejectInvitationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RejectInvitation"
            }
        }
        registerRejectInvitationMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Sends a request to enable data ingest for a member account that has a status of
     * ACCEPTED_BUT_DISABLED.
     * For valid member accounts, the status is updated as follows.
     * If Detective enabled the member account, then the new status is
     * ENABLED.
     * If Detective cannot enable the member account, the status remains
     * ACCEPTED_BUT_DISABLED.
     */
    override suspend fun startMonitoringMember(input: StartMonitoringMemberRequest): StartMonitoringMemberResponse {
        val op = SdkHttpOperation.build<StartMonitoringMemberRequest, StartMonitoringMemberResponse> {
            serializer = StartMonitoringMemberOperationSerializer()
            deserializer = StartMonitoringMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartMonitoringMember"
            }
        }
        registerStartMonitoringMemberMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Applies tag values to a behavior graph.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from a behavior graph.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        val region = resolveRegionForOperation(ctx, config)
        ctx.putIfAbsent(AwsClientOption.Region, region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.signingRegion ?: region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
