// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.serde

import aws.sdk.kotlin.services.detective.model.DetectiveException
import aws.sdk.kotlin.services.detective.model.Indicator
import aws.sdk.kotlin.services.detective.model.ListIndicatorsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListIndicatorsOperationDeserializer: HttpDeserializer.NonStreaming<ListIndicatorsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListIndicatorsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListIndicatorsError(context, call, payload)
        }
        val builder = ListIndicatorsResponse.Builder()

        if (payload != null) {
            deserializeListIndicatorsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListIndicatorsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DetectiveException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DetectiveException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListIndicatorsOperationBody(builder: ListIndicatorsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val GRAPHARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GraphArn"))
    val INDICATORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Indicators"))
    val INVESTIGATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InvestigationId"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GRAPHARN_DESCRIPTOR)
        field(INDICATORS_DESCRIPTOR)
        field(INVESTIGATIONID_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GRAPHARN_DESCRIPTOR.index -> builder.graphArn = deserializeString()
                INDICATORS_DESCRIPTOR.index -> builder.indicators =
                    deserializer.deserializeList(INDICATORS_DESCRIPTOR) {
                        val col0 = mutableListOf<Indicator>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeIndicatorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INVESTIGATIONID_DESCRIPTOR.index -> builder.investigationId = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
