// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.serde

import aws.sdk.kotlin.services.detective.model.DetectiveException
import aws.sdk.kotlin.services.detective.model.EntityType
import aws.sdk.kotlin.services.detective.model.GetInvestigationResponse
import aws.sdk.kotlin.services.detective.model.Severity
import aws.sdk.kotlin.services.detective.model.State
import aws.sdk.kotlin.services.detective.model.Status
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetInvestigationOperationDeserializer: HttpDeserializer.NonStreaming<GetInvestigationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetInvestigationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetInvestigationError(context, call, payload)
        }
        val builder = GetInvestigationResponse.Builder()

        if (payload != null) {
            deserializeGetInvestigationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetInvestigationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DetectiveException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DetectiveException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetInvestigationOperationBody(builder: GetInvestigationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTime"))
    val ENTITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EntityArn"))
    val ENTITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("EntityType"))
    val GRAPHARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GraphArn"))
    val INVESTIGATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InvestigationId"))
    val SCOPEENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ScopeEndTime"))
    val SCOPESTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ScopeStartTime"))
    val SEVERITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Severity"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("State"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDTIME_DESCRIPTOR)
        field(ENTITYARN_DESCRIPTOR)
        field(ENTITYTYPE_DESCRIPTOR)
        field(GRAPHARN_DESCRIPTOR)
        field(INVESTIGATIONID_DESCRIPTOR)
        field(SCOPEENDTIME_DESCRIPTOR)
        field(SCOPESTARTTIME_DESCRIPTOR)
        field(SEVERITY_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDTIME_DESCRIPTOR.index -> builder.createdTime = deserializeInstant(TimestampFormat.ISO_8601)
                ENTITYARN_DESCRIPTOR.index -> builder.entityArn = deserializeString()
                ENTITYTYPE_DESCRIPTOR.index -> builder.entityType = deserializeString().let { EntityType.fromValue(it) }
                GRAPHARN_DESCRIPTOR.index -> builder.graphArn = deserializeString()
                INVESTIGATIONID_DESCRIPTOR.index -> builder.investigationId = deserializeString()
                SCOPEENDTIME_DESCRIPTOR.index -> builder.scopeEndTime = deserializeInstant(TimestampFormat.ISO_8601)
                SCOPESTARTTIME_DESCRIPTOR.index -> builder.scopeStartTime = deserializeInstant(TimestampFormat.ISO_8601)
                SEVERITY_DESCRIPTOR.index -> builder.severity = deserializeString().let { Severity.fromValue(it) }
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { State.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { Status.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
