// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.paginators

import aws.sdk.kotlin.services.detective.DetectiveClient
import aws.sdk.kotlin.services.detective.model.ListDatasourcePackagesRequest
import aws.sdk.kotlin.services.detective.model.ListDatasourcePackagesResponse
import aws.sdk.kotlin.services.detective.model.ListGraphsRequest
import aws.sdk.kotlin.services.detective.model.ListGraphsResponse
import aws.sdk.kotlin.services.detective.model.ListInvitationsRequest
import aws.sdk.kotlin.services.detective.model.ListInvitationsResponse
import aws.sdk.kotlin.services.detective.model.ListMembersRequest
import aws.sdk.kotlin.services.detective.model.ListMembersResponse
import aws.sdk.kotlin.services.detective.model.ListOrganizationAdminAccountsRequest
import aws.sdk.kotlin.services.detective.model.ListOrganizationAdminAccountsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListDatasourcePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasourcePackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasourcePackagesResponse]
 */
public fun DetectiveClient.listDatasourcePackagesPaginated(initialRequest: ListDatasourcePackagesRequest): Flow<ListDatasourcePackagesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasourcePackagesPaginated.listDatasourcePackages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasourcePackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasourcePackagesResponse]
 */
public fun DetectiveClient.listDatasourcePackagesPaginated(block: ListDatasourcePackagesRequest.Builder.() -> Unit): Flow<ListDatasourcePackagesResponse> =
    listDatasourcePackagesPaginated(ListDatasourcePackagesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListGraphsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGraphsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGraphsResponse]
 */
public fun DetectiveClient.listGraphsPaginated(initialRequest: ListGraphsRequest = ListGraphsRequest { }): Flow<ListGraphsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGraphsPaginated.listGraphs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGraphsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGraphsResponse]
 */
public fun DetectiveClient.listGraphsPaginated(block: ListGraphsRequest.Builder.() -> Unit): Flow<ListGraphsResponse> =
    listGraphsPaginated(ListGraphsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInvitationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvitationsResponse]
 */
public fun DetectiveClient.listInvitationsPaginated(initialRequest: ListInvitationsRequest = ListInvitationsRequest { }): Flow<ListInvitationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInvitationsPaginated.listInvitations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListInvitationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInvitationsResponse]
 */
public fun DetectiveClient.listInvitationsPaginated(block: ListInvitationsRequest.Builder.() -> Unit): Flow<ListInvitationsResponse> =
    listInvitationsPaginated(ListInvitationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMembersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun DetectiveClient.listMembersPaginated(initialRequest: ListMembersRequest): Flow<ListMembersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMembersPaginated.listMembers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun DetectiveClient.listMembersPaginated(block: ListMembersRequest.Builder.() -> Unit): Flow<ListMembersResponse> =
    listMembersPaginated(ListMembersRequest.Builder().apply(block).build())

/**
 * Paginate over [ListOrganizationAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOrganizationAdminAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationAdminAccountsResponse]
 */
public fun DetectiveClient.listOrganizationAdminAccountsPaginated(initialRequest: ListOrganizationAdminAccountsRequest = ListOrganizationAdminAccountsRequest { }): Flow<ListOrganizationAdminAccountsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOrganizationAdminAccountsPaginated.listOrganizationAdminAccounts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListOrganizationAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOrganizationAdminAccountsResponse]
 */
public fun DetectiveClient.listOrganizationAdminAccountsPaginated(block: ListOrganizationAdminAccountsRequest.Builder.() -> Unit): Flow<ListOrganizationAdminAccountsResponse> =
    listOrganizationAdminAccountsPaginated(ListOrganizationAdminAccountsRequest.Builder().apply(block).build())
