// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details tactics, techniques, and procedures (TTPs) used in a potential security event. Tactics are based on [MITRE ATT&CK Matrix for Enterprise](https://attack.mitre.org/matrices/enterprise/).
 */
public class TtpsObservedDetail private constructor(builder: Builder) {
    /**
     * The total number of failed API requests.
     */
    public val apiFailureCount: kotlin.Long = builder.apiFailureCount
    /**
     * The name of the API where the tactics, techniques, and procedure (TTP) was observed.
     */
    public val apiName: kotlin.String? = builder.apiName
    /**
     * The total number of successful API requests.
     */
    public val apiSuccessCount: kotlin.Long = builder.apiSuccessCount
    /**
     * The IP address where the tactics, techniques, and procedure (TTP) was observed.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * The procedure used, identified by the investigation.
     */
    public val procedure: kotlin.String? = builder.procedure
    /**
     * The tactic used, identified by the investigation.
     */
    public val tactic: kotlin.String? = builder.tactic
    /**
     * The technique used, identified by the investigation.
     */
    public val technique: kotlin.String? = builder.technique

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.detective.model.TtpsObservedDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TtpsObservedDetail(")
        append("apiFailureCount=$apiFailureCount,")
        append("apiName=$apiName,")
        append("apiSuccessCount=$apiSuccessCount,")
        append("ipAddress=$ipAddress,")
        append("procedure=$procedure,")
        append("tactic=$tactic,")
        append("technique=$technique")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiFailureCount.hashCode()
        result = 31 * result + (apiName?.hashCode() ?: 0)
        result = 31 * result + (apiSuccessCount.hashCode())
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (procedure?.hashCode() ?: 0)
        result = 31 * result + (tactic?.hashCode() ?: 0)
        result = 31 * result + (technique?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TtpsObservedDetail

        if (apiFailureCount != other.apiFailureCount) return false
        if (apiName != other.apiName) return false
        if (apiSuccessCount != other.apiSuccessCount) return false
        if (ipAddress != other.ipAddress) return false
        if (procedure != other.procedure) return false
        if (tactic != other.tactic) return false
        if (technique != other.technique) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.detective.model.TtpsObservedDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The total number of failed API requests.
         */
        public var apiFailureCount: kotlin.Long = 0L
        /**
         * The name of the API where the tactics, techniques, and procedure (TTP) was observed.
         */
        public var apiName: kotlin.String? = null
        /**
         * The total number of successful API requests.
         */
        public var apiSuccessCount: kotlin.Long = 0L
        /**
         * The IP address where the tactics, techniques, and procedure (TTP) was observed.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * The procedure used, identified by the investigation.
         */
        public var procedure: kotlin.String? = null
        /**
         * The tactic used, identified by the investigation.
         */
        public var tactic: kotlin.String? = null
        /**
         * The technique used, identified by the investigation.
         */
        public var technique: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.detective.model.TtpsObservedDetail) : this() {
            this.apiFailureCount = x.apiFailureCount
            this.apiName = x.apiName
            this.apiSuccessCount = x.apiSuccessCount
            this.ipAddress = x.ipAddress
            this.procedure = x.procedure
            this.tactic = x.tactic
            this.technique = x.technique
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.detective.model.TtpsObservedDetail = TtpsObservedDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
