// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about a member account in a behavior graph.
 */
public class MemberDetail private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account identifier for the member account.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Web Services account identifier of the administrator account for the behavior graph.
     */
    public val administratorId: kotlin.String? = builder.administratorId
    /**
     * The state of a data source package for the behavior graph.
     */
    public val datasourcePackageIngestStates: Map<DatasourcePackage, DatasourcePackageIngestState>? = builder.datasourcePackageIngestStates
    /**
     * For member accounts with a status of `ACCEPTED_BUT_DISABLED`, the reason that the member account is not enabled.
     *
     * The reason can have one of the following values:
     * + `VOLUME_TOO_HIGH` - Indicates that adding the member account would cause the data volume for the behavior graph to be too high.
     * + `VOLUME_UNKNOWN` - Indicates that Detective is unable to verify the data volume for the member account. This is usually because the member account is not enrolled in Amazon GuardDuty.
     */
    public val disabledReason: aws.sdk.kotlin.services.detective.model.MemberDisabledReason? = builder.disabledReason
    /**
     * The Amazon Web Services account root user email address for the member account.
     */
    public val emailAddress: kotlin.String? = builder.emailAddress
    /**
     * The ARN of the behavior graph.
     */
    public val graphArn: kotlin.String? = builder.graphArn
    /**
     * The type of behavior graph membership.
     *
     * For an organization account in the organization behavior graph, the type is `ORGANIZATION`.
     *
     * For an account that was invited to a behavior graph, the type is `INVITATION`.
     */
    public val invitationType: aws.sdk.kotlin.services.detective.model.InvitationType? = builder.invitationType
    /**
     * For invited accounts, the date and time that Detective sent the invitation to the account. The value is an ISO8601 formatted string. For example, `2021-08-18T16:35:56.284Z`.
     */
    public val invitedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.invitedTime
    /**
     * The Amazon Web Services account identifier of the administrator account for the behavior graph.
     */
    @Deprecated("This property is deprecated. Use AdministratorId instead.")
    public val masterId: kotlin.String? = builder.masterId
    /**
     * The member account data volume as a percentage of the maximum allowed data volume. 0 indicates 0 percent, and 100 indicates 100 percent.
     *
     * Note that this is not the percentage of the behavior graph data volume.
     *
     * For example, the data volume for the behavior graph is 80 GB per day. The maximum data volume is 160 GB per day. If the data volume for the member account is 40 GB per day, then `PercentOfGraphUtilization` is 25. It represents 25% of the maximum allowed data volume.
     */
    @Deprecated("This property is deprecated. Use VolumeUsageByDatasourcePackage instead.")
    public val percentOfGraphUtilization: kotlin.Double? = builder.percentOfGraphUtilization
    /**
     * The date and time when the graph utilization percentage was last updated. The value is an ISO8601 formatted string. For example, `2021-08-18T16:35:56.284Z`.
     */
    @Deprecated("This property is deprecated. Use VolumeUsageByDatasourcePackage instead.")
    public val percentOfGraphUtilizationUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.percentOfGraphUtilizationUpdatedTime
    /**
     * The current membership status of the member account. The status can have one of the following values:
     * + `INVITED` - For invited accounts only. Indicates that the member was sent an invitation but has not yet responded.
     * + `VERIFICATION_IN_PROGRESS` - For invited accounts only, indicates that Detective is verifying that the account identifier and email address provided for the member account match. If they do match, then Detective sends the invitation. If the email address and account identifier don't match, then the member cannot be added to the behavior graph.For organization accounts in the organization behavior graph, indicates that Detective is verifying that the account belongs to the organization.
     * + `VERIFICATION_FAILED` - For invited accounts only. Indicates that the account and email address provided for the member account do not match, and Detective did not send an invitation to the account.
     * + `ENABLED` - Indicates that the member account currently contributes data to the behavior graph. For invited accounts, the member account accepted the invitation. For organization accounts in the organization behavior graph, the Detective administrator account enabled the organization account as a member account.
     * + `ACCEPTED_BUT_DISABLED` - The account accepted the invitation, or was enabled by the Detective administrator account, but is prevented from contributing data to the behavior graph. `DisabledReason` provides the reason why the member account is not enabled.
     *
     * Invited accounts that declined an invitation or that were removed from the behavior graph are not included. In the organization behavior graph, organization accounts that the Detective administrator account did not enable are not included.
     */
    public val status: aws.sdk.kotlin.services.detective.model.MemberStatus? = builder.status
    /**
     * The date and time that the member account was last updated. The value is an ISO8601 formatted string. For example, `2021-08-18T16:35:56.284Z`.
     */
    public val updatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTime
    /**
     * Details on the volume of usage for each data source package in a behavior graph.
     */
    public val volumeUsageByDatasourcePackage: Map<DatasourcePackage, DatasourcePackageUsageInfo>? = builder.volumeUsageByDatasourcePackage
    /**
     * The data volume in bytes per day for the member account.
     */
    @Deprecated("This property is deprecated. Use VolumeUsageByDatasourcePackage instead.")
    public val volumeUsageInBytes: kotlin.Long? = builder.volumeUsageInBytes
    /**
     * The data and time when the member account data volume was last updated. The value is an ISO8601 formatted string. For example, `2021-08-18T16:35:56.284Z`.
     */
    @Deprecated("This property is deprecated. Use VolumeUsageByDatasourcePackage instead.")
    public val volumeUsageUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.volumeUsageUpdatedTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.detective.model.MemberDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MemberDetail(")
        append("accountId=$accountId,")
        append("administratorId=$administratorId,")
        append("datasourcePackageIngestStates=$datasourcePackageIngestStates,")
        append("disabledReason=$disabledReason,")
        append("emailAddress=*** Sensitive Data Redacted ***,")
        append("graphArn=$graphArn,")
        append("invitationType=$invitationType,")
        append("invitedTime=$invitedTime,")
        append("masterId=$masterId,")
        append("percentOfGraphUtilization=$percentOfGraphUtilization,")
        append("percentOfGraphUtilizationUpdatedTime=$percentOfGraphUtilizationUpdatedTime,")
        append("status=$status,")
        append("updatedTime=$updatedTime,")
        append("volumeUsageByDatasourcePackage=$volumeUsageByDatasourcePackage,")
        append("volumeUsageInBytes=$volumeUsageInBytes,")
        append("volumeUsageUpdatedTime=$volumeUsageUpdatedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (administratorId?.hashCode() ?: 0)
        result = 31 * result + (datasourcePackageIngestStates?.hashCode() ?: 0)
        result = 31 * result + (disabledReason?.hashCode() ?: 0)
        result = 31 * result + (emailAddress?.hashCode() ?: 0)
        result = 31 * result + (graphArn?.hashCode() ?: 0)
        result = 31 * result + (invitationType?.hashCode() ?: 0)
        result = 31 * result + (invitedTime?.hashCode() ?: 0)
        result = 31 * result + (masterId?.hashCode() ?: 0)
        result = 31 * result + (percentOfGraphUtilization?.hashCode() ?: 0)
        result = 31 * result + (percentOfGraphUtilizationUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedTime?.hashCode() ?: 0)
        result = 31 * result + (volumeUsageByDatasourcePackage?.hashCode() ?: 0)
        result = 31 * result + (volumeUsageInBytes?.hashCode() ?: 0)
        result = 31 * result + (volumeUsageUpdatedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MemberDetail

        if (accountId != other.accountId) return false
        if (administratorId != other.administratorId) return false
        if (datasourcePackageIngestStates != other.datasourcePackageIngestStates) return false
        if (disabledReason != other.disabledReason) return false
        if (emailAddress != other.emailAddress) return false
        if (graphArn != other.graphArn) return false
        if (invitationType != other.invitationType) return false
        if (invitedTime != other.invitedTime) return false
        if (masterId != other.masterId) return false
        if (!(percentOfGraphUtilization?.equals(other.percentOfGraphUtilization) ?: (other.percentOfGraphUtilization == null))) return false
        if (percentOfGraphUtilizationUpdatedTime != other.percentOfGraphUtilizationUpdatedTime) return false
        if (status != other.status) return false
        if (updatedTime != other.updatedTime) return false
        if (volumeUsageByDatasourcePackage != other.volumeUsageByDatasourcePackage) return false
        if (volumeUsageInBytes != other.volumeUsageInBytes) return false
        if (volumeUsageUpdatedTime != other.volumeUsageUpdatedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.detective.model.MemberDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account identifier for the member account.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Web Services account identifier of the administrator account for the behavior graph.
         */
        public var administratorId: kotlin.String? = null
        /**
         * The state of a data source package for the behavior graph.
         */
        public var datasourcePackageIngestStates: Map<DatasourcePackage, DatasourcePackageIngestState>? = null
        /**
         * For member accounts with a status of `ACCEPTED_BUT_DISABLED`, the reason that the member account is not enabled.
         *
         * The reason can have one of the following values:
         * + `VOLUME_TOO_HIGH` - Indicates that adding the member account would cause the data volume for the behavior graph to be too high.
         * + `VOLUME_UNKNOWN` - Indicates that Detective is unable to verify the data volume for the member account. This is usually because the member account is not enrolled in Amazon GuardDuty.
         */
        public var disabledReason: aws.sdk.kotlin.services.detective.model.MemberDisabledReason? = null
        /**
         * The Amazon Web Services account root user email address for the member account.
         */
        public var emailAddress: kotlin.String? = null
        /**
         * The ARN of the behavior graph.
         */
        public var graphArn: kotlin.String? = null
        /**
         * The type of behavior graph membership.
         *
         * For an organization account in the organization behavior graph, the type is `ORGANIZATION`.
         *
         * For an account that was invited to a behavior graph, the type is `INVITATION`.
         */
        public var invitationType: aws.sdk.kotlin.services.detective.model.InvitationType? = null
        /**
         * For invited accounts, the date and time that Detective sent the invitation to the account. The value is an ISO8601 formatted string. For example, `2021-08-18T16:35:56.284Z`.
         */
        public var invitedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services account identifier of the administrator account for the behavior graph.
         */
        @Deprecated("This property is deprecated. Use AdministratorId instead.")
        public var masterId: kotlin.String? = null
        /**
         * The member account data volume as a percentage of the maximum allowed data volume. 0 indicates 0 percent, and 100 indicates 100 percent.
         *
         * Note that this is not the percentage of the behavior graph data volume.
         *
         * For example, the data volume for the behavior graph is 80 GB per day. The maximum data volume is 160 GB per day. If the data volume for the member account is 40 GB per day, then `PercentOfGraphUtilization` is 25. It represents 25% of the maximum allowed data volume.
         */
        @Deprecated("This property is deprecated. Use VolumeUsageByDatasourcePackage instead.")
        public var percentOfGraphUtilization: kotlin.Double? = null
        /**
         * The date and time when the graph utilization percentage was last updated. The value is an ISO8601 formatted string. For example, `2021-08-18T16:35:56.284Z`.
         */
        @Deprecated("This property is deprecated. Use VolumeUsageByDatasourcePackage instead.")
        public var percentOfGraphUtilizationUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current membership status of the member account. The status can have one of the following values:
         * + `INVITED` - For invited accounts only. Indicates that the member was sent an invitation but has not yet responded.
         * + `VERIFICATION_IN_PROGRESS` - For invited accounts only, indicates that Detective is verifying that the account identifier and email address provided for the member account match. If they do match, then Detective sends the invitation. If the email address and account identifier don't match, then the member cannot be added to the behavior graph.For organization accounts in the organization behavior graph, indicates that Detective is verifying that the account belongs to the organization.
         * + `VERIFICATION_FAILED` - For invited accounts only. Indicates that the account and email address provided for the member account do not match, and Detective did not send an invitation to the account.
         * + `ENABLED` - Indicates that the member account currently contributes data to the behavior graph. For invited accounts, the member account accepted the invitation. For organization accounts in the organization behavior graph, the Detective administrator account enabled the organization account as a member account.
         * + `ACCEPTED_BUT_DISABLED` - The account accepted the invitation, or was enabled by the Detective administrator account, but is prevented from contributing data to the behavior graph. `DisabledReason` provides the reason why the member account is not enabled.
         *
         * Invited accounts that declined an invitation or that were removed from the behavior graph are not included. In the organization behavior graph, organization accounts that the Detective administrator account did not enable are not included.
         */
        public var status: aws.sdk.kotlin.services.detective.model.MemberStatus? = null
        /**
         * The date and time that the member account was last updated. The value is an ISO8601 formatted string. For example, `2021-08-18T16:35:56.284Z`.
         */
        public var updatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details on the volume of usage for each data source package in a behavior graph.
         */
        public var volumeUsageByDatasourcePackage: Map<DatasourcePackage, DatasourcePackageUsageInfo>? = null
        /**
         * The data volume in bytes per day for the member account.
         */
        @Deprecated("This property is deprecated. Use VolumeUsageByDatasourcePackage instead.")
        public var volumeUsageInBytes: kotlin.Long? = null
        /**
         * The data and time when the member account data volume was last updated. The value is an ISO8601 formatted string. For example, `2021-08-18T16:35:56.284Z`.
         */
        @Deprecated("This property is deprecated. Use VolumeUsageByDatasourcePackage instead.")
        public var volumeUsageUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.detective.model.MemberDetail) : this() {
            this.accountId = x.accountId
            this.administratorId = x.administratorId
            this.datasourcePackageIngestStates = x.datasourcePackageIngestStates
            this.disabledReason = x.disabledReason
            this.emailAddress = x.emailAddress
            this.graphArn = x.graphArn
            this.invitationType = x.invitationType
            this.invitedTime = x.invitedTime
            this.masterId = x.masterId
            this.percentOfGraphUtilization = x.percentOfGraphUtilization
            this.percentOfGraphUtilizationUpdatedTime = x.percentOfGraphUtilizationUpdatedTime
            this.status = x.status
            this.updatedTime = x.updatedTime
            this.volumeUsageByDatasourcePackage = x.volumeUsageByDatasourcePackage
            this.volumeUsageInBytes = x.volumeUsageInBytes
            this.volumeUsageUpdatedTime = x.volumeUsageUpdatedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.detective.model.MemberDetail = MemberDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
