// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about the investigation related to a potential security event identified by Detective.
 */
public class InvestigationDetail private constructor(builder: Builder) {
    /**
     * The time stamp of the creation time of the investigation report. The value is an UTC ISO8601 formatted string. For example, `2021-08-18T16:35:56.284Z`.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
     */
    public val entityArn: kotlin.String? = builder.entityArn
    /**
     * Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.
     */
    public val entityType: aws.sdk.kotlin.services.detective.model.EntityType? = builder.entityType
    /**
     * The investigation ID of the investigation report.
     */
    public val investigationId: kotlin.String? = builder.investigationId
    /**
     * Severity based on the likelihood and impact of the indicators of compromise discovered in the investigation.
     */
    public val severity: aws.sdk.kotlin.services.detective.model.Severity? = builder.severity
    /**
     * The current state of the investigation. An archived investigation indicates you have completed reviewing the investigation.
     */
    public val state: aws.sdk.kotlin.services.detective.model.State? = builder.state
    /**
     * Status based on the completion status of the investigation.
     */
    public val status: aws.sdk.kotlin.services.detective.model.Status? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.detective.model.InvestigationDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvestigationDetail(")
        append("createdTime=$createdTime,")
        append("entityArn=$entityArn,")
        append("entityType=$entityType,")
        append("investigationId=$investigationId,")
        append("severity=$severity,")
        append("state=$state,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime?.hashCode() ?: 0
        result = 31 * result + (entityArn?.hashCode() ?: 0)
        result = 31 * result + (entityType?.hashCode() ?: 0)
        result = 31 * result + (investigationId?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvestigationDetail

        if (createdTime != other.createdTime) return false
        if (entityArn != other.entityArn) return false
        if (entityType != other.entityType) return false
        if (investigationId != other.investigationId) return false
        if (severity != other.severity) return false
        if (state != other.state) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.detective.model.InvestigationDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time stamp of the creation time of the investigation report. The value is an UTC ISO8601 formatted string. For example, `2021-08-18T16:35:56.284Z`.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique Amazon Resource Name (ARN) of the IAM user and IAM role.
         */
        public var entityArn: kotlin.String? = null
        /**
         * Type of entity. For example, Amazon Web Services accounts, such as IAM user and role.
         */
        public var entityType: aws.sdk.kotlin.services.detective.model.EntityType? = null
        /**
         * The investigation ID of the investigation report.
         */
        public var investigationId: kotlin.String? = null
        /**
         * Severity based on the likelihood and impact of the indicators of compromise discovered in the investigation.
         */
        public var severity: aws.sdk.kotlin.services.detective.model.Severity? = null
        /**
         * The current state of the investigation. An archived investigation indicates you have completed reviewing the investigation.
         */
        public var state: aws.sdk.kotlin.services.detective.model.State? = null
        /**
         * Status based on the completion status of the investigation.
         */
        public var status: aws.sdk.kotlin.services.detective.model.Status? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.detective.model.InvestigationDetail) : this() {
            this.createdTime = x.createdTime
            this.entityArn = x.entityArn
            this.entityType = x.entityType
            this.investigationId = x.investigationId
            this.severity = x.severity
            this.state = x.state
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.detective.model.InvestigationDetail = InvestigationDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
