// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about the indicators of compromise which are used to determine if a resource is involved in a security incident. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. For the list of indicators of compromise that are generated by Detective investigations, see [Detective investigations](https://docs.aws.amazon.com/detective/latest/userguide/detective-investigation-about.html).
 */
public class IndicatorDetail private constructor(builder: Builder) {
    /**
     * Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat intelligence by Detective. This indicator is derived from Amazon Web Services threat intelligence.
     */
    public val flaggedIpAddressDetail: aws.sdk.kotlin.services.detective.model.FlaggedIpAddressDetail? = builder.flaggedIpAddressDetail
    /**
     * Identifies unusual and impossible user activity for an account.
     */
    public val impossibleTravelDetail: aws.sdk.kotlin.services.detective.model.ImpossibleTravelDetail? = builder.impossibleTravelDetail
    /**
     * Contains details about the new Autonomous System Organization (ASO).
     */
    public val newAsoDetail: aws.sdk.kotlin.services.detective.model.NewAsoDetail? = builder.newAsoDetail
    /**
     * Contains details about the new geographic location.
     */
    public val newGeolocationDetail: aws.sdk.kotlin.services.detective.model.NewGeolocationDetail? = builder.newGeolocationDetail
    /**
     * Contains details about the new user agent.
     */
    public val newUserAgentDetail: aws.sdk.kotlin.services.detective.model.NewUserAgentDetail? = builder.newUserAgentDetail
    /**
     * Contains details about related findings.
     */
    public val relatedFindingDetail: aws.sdk.kotlin.services.detective.model.RelatedFindingDetail? = builder.relatedFindingDetail
    /**
     * Contains details about related finding groups.
     */
    public val relatedFindingGroupDetail: aws.sdk.kotlin.services.detective.model.RelatedFindingGroupDetail? = builder.relatedFindingGroupDetail
    /**
     * Details about the indicator of compromise.
     */
    public val ttpsObservedDetail: aws.sdk.kotlin.services.detective.model.TtpsObservedDetail? = builder.ttpsObservedDetail

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.detective.model.IndicatorDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IndicatorDetail(")
        append("flaggedIpAddressDetail=$flaggedIpAddressDetail,")
        append("impossibleTravelDetail=$impossibleTravelDetail,")
        append("newAsoDetail=$newAsoDetail,")
        append("newGeolocationDetail=$newGeolocationDetail,")
        append("newUserAgentDetail=$newUserAgentDetail,")
        append("relatedFindingDetail=$relatedFindingDetail,")
        append("relatedFindingGroupDetail=$relatedFindingGroupDetail,")
        append("ttpsObservedDetail=$ttpsObservedDetail")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = flaggedIpAddressDetail?.hashCode() ?: 0
        result = 31 * result + (impossibleTravelDetail?.hashCode() ?: 0)
        result = 31 * result + (newAsoDetail?.hashCode() ?: 0)
        result = 31 * result + (newGeolocationDetail?.hashCode() ?: 0)
        result = 31 * result + (newUserAgentDetail?.hashCode() ?: 0)
        result = 31 * result + (relatedFindingDetail?.hashCode() ?: 0)
        result = 31 * result + (relatedFindingGroupDetail?.hashCode() ?: 0)
        result = 31 * result + (ttpsObservedDetail?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IndicatorDetail

        if (flaggedIpAddressDetail != other.flaggedIpAddressDetail) return false
        if (impossibleTravelDetail != other.impossibleTravelDetail) return false
        if (newAsoDetail != other.newAsoDetail) return false
        if (newGeolocationDetail != other.newGeolocationDetail) return false
        if (newUserAgentDetail != other.newUserAgentDetail) return false
        if (relatedFindingDetail != other.relatedFindingDetail) return false
        if (relatedFindingGroupDetail != other.relatedFindingGroupDetail) return false
        if (ttpsObservedDetail != other.ttpsObservedDetail) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.detective.model.IndicatorDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Suspicious IP addresses that are flagged, which indicates critical or severe threats based on threat intelligence by Detective. This indicator is derived from Amazon Web Services threat intelligence.
         */
        public var flaggedIpAddressDetail: aws.sdk.kotlin.services.detective.model.FlaggedIpAddressDetail? = null
        /**
         * Identifies unusual and impossible user activity for an account.
         */
        public var impossibleTravelDetail: aws.sdk.kotlin.services.detective.model.ImpossibleTravelDetail? = null
        /**
         * Contains details about the new Autonomous System Organization (ASO).
         */
        public var newAsoDetail: aws.sdk.kotlin.services.detective.model.NewAsoDetail? = null
        /**
         * Contains details about the new geographic location.
         */
        public var newGeolocationDetail: aws.sdk.kotlin.services.detective.model.NewGeolocationDetail? = null
        /**
         * Contains details about the new user agent.
         */
        public var newUserAgentDetail: aws.sdk.kotlin.services.detective.model.NewUserAgentDetail? = null
        /**
         * Contains details about related findings.
         */
        public var relatedFindingDetail: aws.sdk.kotlin.services.detective.model.RelatedFindingDetail? = null
        /**
         * Contains details about related finding groups.
         */
        public var relatedFindingGroupDetail: aws.sdk.kotlin.services.detective.model.RelatedFindingGroupDetail? = null
        /**
         * Details about the indicator of compromise.
         */
        public var ttpsObservedDetail: aws.sdk.kotlin.services.detective.model.TtpsObservedDetail? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.detective.model.IndicatorDetail) : this() {
            this.flaggedIpAddressDetail = x.flaggedIpAddressDetail
            this.impossibleTravelDetail = x.impossibleTravelDetail
            this.newAsoDetail = x.newAsoDetail
            this.newGeolocationDetail = x.newGeolocationDetail
            this.newUserAgentDetail = x.newUserAgentDetail
            this.relatedFindingDetail = x.relatedFindingDetail
            this.relatedFindingGroupDetail = x.relatedFindingGroupDetail
            this.ttpsObservedDetail = x.ttpsObservedDetail
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.detective.model.IndicatorDetail = IndicatorDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.detective.model.FlaggedIpAddressDetail] inside the given [block]
         */
        public fun flaggedIpAddressDetail(block: aws.sdk.kotlin.services.detective.model.FlaggedIpAddressDetail.Builder.() -> kotlin.Unit) {
            this.flaggedIpAddressDetail = aws.sdk.kotlin.services.detective.model.FlaggedIpAddressDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.detective.model.ImpossibleTravelDetail] inside the given [block]
         */
        public fun impossibleTravelDetail(block: aws.sdk.kotlin.services.detective.model.ImpossibleTravelDetail.Builder.() -> kotlin.Unit) {
            this.impossibleTravelDetail = aws.sdk.kotlin.services.detective.model.ImpossibleTravelDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.detective.model.NewAsoDetail] inside the given [block]
         */
        public fun newAsoDetail(block: aws.sdk.kotlin.services.detective.model.NewAsoDetail.Builder.() -> kotlin.Unit) {
            this.newAsoDetail = aws.sdk.kotlin.services.detective.model.NewAsoDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.detective.model.NewGeolocationDetail] inside the given [block]
         */
        public fun newGeolocationDetail(block: aws.sdk.kotlin.services.detective.model.NewGeolocationDetail.Builder.() -> kotlin.Unit) {
            this.newGeolocationDetail = aws.sdk.kotlin.services.detective.model.NewGeolocationDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.detective.model.NewUserAgentDetail] inside the given [block]
         */
        public fun newUserAgentDetail(block: aws.sdk.kotlin.services.detective.model.NewUserAgentDetail.Builder.() -> kotlin.Unit) {
            this.newUserAgentDetail = aws.sdk.kotlin.services.detective.model.NewUserAgentDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.detective.model.RelatedFindingDetail] inside the given [block]
         */
        public fun relatedFindingDetail(block: aws.sdk.kotlin.services.detective.model.RelatedFindingDetail.Builder.() -> kotlin.Unit) {
            this.relatedFindingDetail = aws.sdk.kotlin.services.detective.model.RelatedFindingDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.detective.model.RelatedFindingGroupDetail] inside the given [block]
         */
        public fun relatedFindingGroupDetail(block: aws.sdk.kotlin.services.detective.model.RelatedFindingGroupDetail.Builder.() -> kotlin.Unit) {
            this.relatedFindingGroupDetail = aws.sdk.kotlin.services.detective.model.RelatedFindingGroupDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.detective.model.TtpsObservedDetail] inside the given [block]
         */
        public fun ttpsObservedDetail(block: aws.sdk.kotlin.services.detective.model.TtpsObservedDetail.Builder.() -> kotlin.Unit) {
            this.ttpsObservedDetail = aws.sdk.kotlin.services.detective.model.TtpsObservedDetail.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
