// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.detective

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.detective.auth.DefaultDetectiveAuthSchemeProvider
import aws.sdk.kotlin.services.detective.auth.DetectiveAuthSchemeProvider
import aws.sdk.kotlin.services.detective.endpoints.DefaultDetectiveEndpointProvider
import aws.sdk.kotlin.services.detective.endpoints.DetectiveEndpointParameters
import aws.sdk.kotlin.services.detective.endpoints.DetectiveEndpointProvider
import aws.sdk.kotlin.services.detective.model.AcceptInvitationRequest
import aws.sdk.kotlin.services.detective.model.AcceptInvitationResponse
import aws.sdk.kotlin.services.detective.model.BatchGetGraphMemberDatasourcesRequest
import aws.sdk.kotlin.services.detective.model.BatchGetGraphMemberDatasourcesResponse
import aws.sdk.kotlin.services.detective.model.BatchGetMembershipDatasourcesRequest
import aws.sdk.kotlin.services.detective.model.BatchGetMembershipDatasourcesResponse
import aws.sdk.kotlin.services.detective.model.CreateGraphRequest
import aws.sdk.kotlin.services.detective.model.CreateGraphResponse
import aws.sdk.kotlin.services.detective.model.CreateMembersRequest
import aws.sdk.kotlin.services.detective.model.CreateMembersResponse
import aws.sdk.kotlin.services.detective.model.DeleteGraphRequest
import aws.sdk.kotlin.services.detective.model.DeleteGraphResponse
import aws.sdk.kotlin.services.detective.model.DeleteMembersRequest
import aws.sdk.kotlin.services.detective.model.DeleteMembersResponse
import aws.sdk.kotlin.services.detective.model.DescribeOrganizationConfigurationRequest
import aws.sdk.kotlin.services.detective.model.DescribeOrganizationConfigurationResponse
import aws.sdk.kotlin.services.detective.model.DisableOrganizationAdminAccountRequest
import aws.sdk.kotlin.services.detective.model.DisableOrganizationAdminAccountResponse
import aws.sdk.kotlin.services.detective.model.DisassociateMembershipRequest
import aws.sdk.kotlin.services.detective.model.DisassociateMembershipResponse
import aws.sdk.kotlin.services.detective.model.EnableOrganizationAdminAccountRequest
import aws.sdk.kotlin.services.detective.model.EnableOrganizationAdminAccountResponse
import aws.sdk.kotlin.services.detective.model.GetInvestigationRequest
import aws.sdk.kotlin.services.detective.model.GetInvestigationResponse
import aws.sdk.kotlin.services.detective.model.GetMembersRequest
import aws.sdk.kotlin.services.detective.model.GetMembersResponse
import aws.sdk.kotlin.services.detective.model.ListDatasourcePackagesRequest
import aws.sdk.kotlin.services.detective.model.ListDatasourcePackagesResponse
import aws.sdk.kotlin.services.detective.model.ListGraphsRequest
import aws.sdk.kotlin.services.detective.model.ListGraphsResponse
import aws.sdk.kotlin.services.detective.model.ListIndicatorsRequest
import aws.sdk.kotlin.services.detective.model.ListIndicatorsResponse
import aws.sdk.kotlin.services.detective.model.ListInvestigationsRequest
import aws.sdk.kotlin.services.detective.model.ListInvestigationsResponse
import aws.sdk.kotlin.services.detective.model.ListInvitationsRequest
import aws.sdk.kotlin.services.detective.model.ListInvitationsResponse
import aws.sdk.kotlin.services.detective.model.ListMembersRequest
import aws.sdk.kotlin.services.detective.model.ListMembersResponse
import aws.sdk.kotlin.services.detective.model.ListOrganizationAdminAccountsRequest
import aws.sdk.kotlin.services.detective.model.ListOrganizationAdminAccountsResponse
import aws.sdk.kotlin.services.detective.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.detective.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.detective.model.RejectInvitationRequest
import aws.sdk.kotlin.services.detective.model.RejectInvitationResponse
import aws.sdk.kotlin.services.detective.model.StartInvestigationRequest
import aws.sdk.kotlin.services.detective.model.StartInvestigationResponse
import aws.sdk.kotlin.services.detective.model.StartMonitoringMemberRequest
import aws.sdk.kotlin.services.detective.model.StartMonitoringMemberResponse
import aws.sdk.kotlin.services.detective.model.TagResourceRequest
import aws.sdk.kotlin.services.detective.model.TagResourceResponse
import aws.sdk.kotlin.services.detective.model.UntagResourceRequest
import aws.sdk.kotlin.services.detective.model.UntagResourceResponse
import aws.sdk.kotlin.services.detective.model.UpdateDatasourcePackagesRequest
import aws.sdk.kotlin.services.detective.model.UpdateDatasourcePackagesResponse
import aws.sdk.kotlin.services.detective.model.UpdateInvestigationStateRequest
import aws.sdk.kotlin.services.detective.model.UpdateInvestigationStateResponse
import aws.sdk.kotlin.services.detective.model.UpdateOrganizationConfigurationRequest
import aws.sdk.kotlin.services.detective.model.UpdateOrganizationConfigurationResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Detective"
public const val SdkVersion: String = "1.5.34"
public const val ServiceApiVersion: String = "2018-10-26"

/**
 * Detective uses machine learning and purpose-built visualizations to help you to analyze and investigate security issues across your Amazon Web Services (Amazon Web Services) workloads. Detective automatically extracts time-based events such as login attempts, API calls, and network traffic from CloudTrail and Amazon Virtual Private Cloud (Amazon VPC) flow logs. It also extracts findings detected by Amazon GuardDuty.
 *
 * The Detective API primarily supports the creation and management of behavior graphs. A behavior graph contains the extracted data from a set of member accounts, and is created and managed by an administrator account.
 *
 * To add a member account to the behavior graph, the administrator account sends an invitation to the account. When the account accepts the invitation, it becomes a member account in the behavior graph.
 *
 * Detective is also integrated with Organizations. The organization management account designates the Detective administrator account for the organization. That account becomes the administrator account for the organization behavior graph. The Detective administrator account is also the delegated administrator account for Detective in Organizations.
 *
 * The Detective administrator account can enable any organization account as a member account in the organization behavior graph. The organization accounts do not receive invitations. The Detective administrator account can also invite other accounts to the organization behavior graph.
 *
 * Every behavior graph is specific to a Region. You can only use the API to manage behavior graphs that belong to the Region that is associated with the currently selected endpoint.
 *
 * The administrator account for a behavior graph can use the Detective API to do the following:
 * + Enable and disable Detective. Enabling Detective creates a new behavior graph.
 * + View the list of member accounts in a behavior graph.
 * + Add member accounts to a behavior graph.
 * + Remove member accounts from a behavior graph.
 * + Apply tags to a behavior graph.
 *
 * The organization management account can use the Detective API to select the delegated administrator for Detective.
 *
 * The Detective administrator account for an organization can use the Detective API to do the following:
 * + Perform all of the functions of an administrator account.
 * + Determine whether to automatically enable new organization accounts as member accounts in the organization behavior graph.
 *
 * An invited member account can use the Detective API to do the following:
 * + View the list of behavior graphs that they are invited to.
 * + Accept an invitation to contribute to a behavior graph.
 * + Decline an invitation to contribute to a behavior graph.
 * + Remove their account from a behavior graph.
 *
 * All API actions are logged as CloudTrail events. See [Logging Detective API Calls with CloudTrail](https://docs.aws.amazon.com/detective/latest/userguide/logging-using-cloudtrail.html).
 *
 * We replaced the term "master account" with the term "administrator account". An administrator account is used to centrally manage multiple accounts. In the case of Detective, the administrator account manages the accounts in their behavior graph.
 */
public interface DetectiveClient : SdkClient {
    /**
     * DetectiveClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, DetectiveClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Detective",
                "DETECTIVE",
                "detective",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, DetectiveClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): DetectiveClient = DefaultDetectiveClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: DetectiveEndpointProvider = builder.endpointProvider ?: DefaultDetectiveEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: DetectiveAuthSchemeProvider = builder.authSchemeProvider ?: DefaultDetectiveAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Detective"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: DetectiveEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: DetectiveAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts an invitation for the member account to contribute data to a behavior graph. This operation can only be called by an invited member account.
     *
     * The request provides the ARN of behavior graph.
     *
     * The member account status in the graph must be `INVITED`.
     */
    public suspend fun acceptInvitation(input: AcceptInvitationRequest): AcceptInvitationResponse

    /**
     * Gets data source package information for the behavior graph.
     */
    public suspend fun batchGetGraphMemberDatasources(input: BatchGetGraphMemberDatasourcesRequest): BatchGetGraphMemberDatasourcesResponse

    /**
     * Gets information on the data source package history for an account.
     */
    public suspend fun batchGetMembershipDatasources(input: BatchGetMembershipDatasourcesRequest): BatchGetMembershipDatasourcesResponse

    /**
     * Creates a new behavior graph for the calling account, and sets that account as the administrator account. This operation is called by the account that is enabling Detective.
     *
     * The operation also enables Detective for the calling account in the currently selected Region. It returns the ARN of the new behavior graph.
     *
     * `CreateGraph` triggers a process to create the corresponding data tables for the new behavior graph.
     *
     * An account can only be the administrator account for one behavior graph within a Region. If the same account calls `CreateGraph` with the same administrator account, it always returns the same behavior graph ARN. It does not create a new behavior graph.
     */
    public suspend fun createGraph(input: CreateGraphRequest = CreateGraphRequest { }): CreateGraphResponse

    /**
     * `CreateMembers` is used to send invitations to accounts. For the organization behavior graph, the Detective administrator account uses `CreateMembers` to enable organization accounts as member accounts.
     *
     * For invited accounts, `CreateMembers` sends a request to invite the specified Amazon Web Services accounts to be member accounts in the behavior graph. This operation can only be called by the administrator account for a behavior graph.
     *
     * `CreateMembers` verifies the accounts and then invites the verified accounts. The administrator can optionally specify to not send invitation emails to the member accounts. This would be used when the administrator manages their member accounts centrally.
     *
     * For organization accounts in the organization behavior graph, `CreateMembers` attempts to enable the accounts. The organization accounts do not receive invitations.
     *
     * The request provides the behavior graph ARN and the list of accounts to invite or to enable.
     *
     * The response separates the requested accounts into two lists:
     * + The accounts that `CreateMembers` was able to process. For invited accounts, includes member accounts that are being verified, that have passed verification and are to be invited, and that have failed verification. For organization accounts in the organization behavior graph, includes accounts that can be enabled and that cannot be enabled.
     * + The accounts that `CreateMembers` was unable to process. This list includes accounts that were already invited to be member accounts in the behavior graph.
     */
    public suspend fun createMembers(input: CreateMembersRequest): CreateMembersResponse

    /**
     * Disables the specified behavior graph and queues it to be deleted. This operation removes the behavior graph from each member account's list of behavior graphs.
     *
     * `DeleteGraph` can only be called by the administrator account for a behavior graph.
     */
    public suspend fun deleteGraph(input: DeleteGraphRequest): DeleteGraphResponse

    /**
     * Removes the specified member accounts from the behavior graph. The removed accounts no longer contribute data to the behavior graph. This operation can only be called by the administrator account for the behavior graph.
     *
     * For invited accounts, the removed accounts are deleted from the list of accounts in the behavior graph. To restore the account, the administrator account must send another invitation.
     *
     * For organization accounts in the organization behavior graph, the Detective administrator account can always enable the organization account again. Organization accounts that are not enabled as member accounts are not included in the `ListMembers` results for the organization behavior graph.
     *
     * An administrator account cannot use `DeleteMembers` to remove their own account from the behavior graph. To disable a behavior graph, the administrator account uses the `DeleteGraph` API method.
     */
    public suspend fun deleteMembers(input: DeleteMembersRequest): DeleteMembersResponse

    /**
     * Returns information about the configuration for the organization behavior graph. Currently indicates whether to automatically enable new organization accounts as member accounts.
     *
     * Can only be called by the Detective administrator account for the organization.
     */
    public suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest): DescribeOrganizationConfigurationResponse

    /**
     * Removes the Detective administrator account in the current Region. Deletes the organization behavior graph.
     *
     * Can only be called by the organization management account.
     *
     * Removing the Detective administrator account does not affect the delegated administrator account for Detective in Organizations.
     *
     * To remove the delegated administrator account in Organizations, use the Organizations API. Removing the delegated administrator account also removes the Detective administrator account in all Regions, except for Regions where the Detective administrator account is the organization management account.
     */
    public suspend fun disableOrganizationAdminAccount(input: DisableOrganizationAdminAccountRequest = DisableOrganizationAdminAccountRequest { }): DisableOrganizationAdminAccountResponse

    /**
     * Removes the member account from the specified behavior graph. This operation can only be called by an invited member account that has the `ENABLED` status.
     *
     * `DisassociateMembership` cannot be called by an organization account in the organization behavior graph. For the organization behavior graph, the Detective administrator account determines which organization accounts to enable or disable as member accounts.
     */
    public suspend fun disassociateMembership(input: DisassociateMembershipRequest): DisassociateMembershipResponse

    /**
     * Designates the Detective administrator account for the organization in the current Region.
     *
     * If the account does not have Detective enabled, then enables Detective for that account and creates a new behavior graph.
     *
     * Can only be called by the organization management account.
     *
     * If the organization has a delegated administrator account in Organizations, then the Detective administrator account must be either the delegated administrator account or the organization management account.
     *
     * If the organization does not have a delegated administrator account in Organizations, then you can choose any account in the organization. If you choose an account other than the organization management account, Detective calls Organizations to make that account the delegated administrator account for Detective. The organization management account cannot be the delegated administrator account.
     */
    public suspend fun enableOrganizationAdminAccount(input: EnableOrganizationAdminAccountRequest): EnableOrganizationAdminAccountResponse

    /**
     * Detective investigations lets you investigate IAM users and IAM roles using indicators of compromise. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. `GetInvestigation` returns the investigation results of an investigation for a behavior graph.
     */
    public suspend fun getInvestigation(input: GetInvestigationRequest): GetInvestigationResponse

    /**
     * Returns the membership details for specified member accounts for a behavior graph.
     */
    public suspend fun getMembers(input: GetMembersRequest): GetMembersResponse

    /**
     * Lists data source packages in the behavior graph.
     */
    public suspend fun listDatasourcePackages(input: ListDatasourcePackagesRequest): ListDatasourcePackagesResponse

    /**
     * Returns the list of behavior graphs that the calling account is an administrator account of. This operation can only be called by an administrator account.
     *
     * Because an account can currently only be the administrator of one behavior graph within a Region, the results always contain a single behavior graph.
     */
    public suspend fun listGraphs(input: ListGraphsRequest = ListGraphsRequest { }): ListGraphsResponse

    /**
     * Gets the indicators from an investigation. You can use the information from the indicators to determine if an IAM user and/or IAM role is involved in an unusual activity that could indicate malicious behavior and its impact.
     */
    public suspend fun listIndicators(input: ListIndicatorsRequest): ListIndicatorsResponse

    /**
     * Detective investigations lets you investigate IAM users and IAM roles using indicators of compromise. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. `ListInvestigations` lists all active Detective investigations.
     */
    public suspend fun listInvestigations(input: ListInvestigationsRequest): ListInvestigationsResponse

    /**
     * Retrieves the list of open and accepted behavior graph invitations for the member account. This operation can only be called by an invited member account.
     *
     * Open invitations are invitations that the member account has not responded to.
     *
     * The results do not include behavior graphs for which the member account declined the invitation. The results also do not include behavior graphs that the member account resigned from or was removed from.
     */
    public suspend fun listInvitations(input: ListInvitationsRequest = ListInvitationsRequest { }): ListInvitationsResponse

    /**
     * Retrieves the list of member accounts for a behavior graph.
     *
     * For invited accounts, the results do not include member accounts that were removed from the behavior graph.
     *
     * For the organization behavior graph, the results do not include organization accounts that the Detective administrator account has not enabled as member accounts.
     */
    public suspend fun listMembers(input: ListMembersRequest): ListMembersResponse

    /**
     * Returns information about the Detective administrator account for an organization. Can only be called by the organization management account.
     */
    public suspend fun listOrganizationAdminAccounts(input: ListOrganizationAdminAccountsRequest = ListOrganizationAdminAccountsRequest { }): ListOrganizationAdminAccountsResponse

    /**
     * Returns the tag values that are assigned to a behavior graph.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Rejects an invitation to contribute the account data to a behavior graph. This operation must be called by an invited member account that has the `INVITED` status.
     *
     * `RejectInvitation` cannot be called by an organization account in the organization behavior graph. In the organization behavior graph, organization accounts do not receive an invitation.
     */
    public suspend fun rejectInvitation(input: RejectInvitationRequest): RejectInvitationResponse

    /**
     * Detective investigations lets you investigate IAM users and IAM roles using indicators of compromise. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. `StartInvestigation` initiates an investigation on an entity in a behavior graph.
     */
    public suspend fun startInvestigation(input: StartInvestigationRequest): StartInvestigationResponse

    /**
     * Sends a request to enable data ingest for a member account that has a status of `ACCEPTED_BUT_DISABLED`.
     *
     * For valid member accounts, the status is updated as follows.
     * + If Detective enabled the member account, then the new status is `ENABLED`.
     * + If Detective cannot enable the member account, the status remains `ACCEPTED_BUT_DISABLED`.
     */
    public suspend fun startMonitoringMember(input: StartMonitoringMemberRequest): StartMonitoringMemberResponse

    /**
     * Applies tag values to a behavior graph.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a behavior graph.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Starts a data source package for the Detective behavior graph.
     */
    public suspend fun updateDatasourcePackages(input: UpdateDatasourcePackagesRequest): UpdateDatasourcePackagesResponse

    /**
     * Updates the state of an investigation.
     */
    public suspend fun updateInvestigationState(input: UpdateInvestigationStateRequest): UpdateInvestigationStateResponse

    /**
     * Updates the configuration for the Organizations integration in the current Region. Can only be called by the Detective administrator account for the organization.
     */
    public suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun DetectiveClient.withConfig(block: DetectiveClient.Config.Builder.() -> Unit): DetectiveClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultDetectiveClient(newConfig)
}

/**
 * Accepts an invitation for the member account to contribute data to a behavior graph. This operation can only be called by an invited member account.
 *
 * The request provides the ARN of behavior graph.
 *
 * The member account status in the graph must be `INVITED`.
 */
public suspend inline fun DetectiveClient.acceptInvitation(crossinline block: AcceptInvitationRequest.Builder.() -> Unit): AcceptInvitationResponse = acceptInvitation(AcceptInvitationRequest.Builder().apply(block).build())

/**
 * Gets data source package information for the behavior graph.
 */
public suspend inline fun DetectiveClient.batchGetGraphMemberDatasources(crossinline block: BatchGetGraphMemberDatasourcesRequest.Builder.() -> Unit): BatchGetGraphMemberDatasourcesResponse = batchGetGraphMemberDatasources(BatchGetGraphMemberDatasourcesRequest.Builder().apply(block).build())

/**
 * Gets information on the data source package history for an account.
 */
public suspend inline fun DetectiveClient.batchGetMembershipDatasources(crossinline block: BatchGetMembershipDatasourcesRequest.Builder.() -> Unit): BatchGetMembershipDatasourcesResponse = batchGetMembershipDatasources(BatchGetMembershipDatasourcesRequest.Builder().apply(block).build())

/**
 * Creates a new behavior graph for the calling account, and sets that account as the administrator account. This operation is called by the account that is enabling Detective.
 *
 * The operation also enables Detective for the calling account in the currently selected Region. It returns the ARN of the new behavior graph.
 *
 * `CreateGraph` triggers a process to create the corresponding data tables for the new behavior graph.
 *
 * An account can only be the administrator account for one behavior graph within a Region. If the same account calls `CreateGraph` with the same administrator account, it always returns the same behavior graph ARN. It does not create a new behavior graph.
 */
public suspend inline fun DetectiveClient.createGraph(crossinline block: CreateGraphRequest.Builder.() -> Unit): CreateGraphResponse = createGraph(CreateGraphRequest.Builder().apply(block).build())

/**
 * `CreateMembers` is used to send invitations to accounts. For the organization behavior graph, the Detective administrator account uses `CreateMembers` to enable organization accounts as member accounts.
 *
 * For invited accounts, `CreateMembers` sends a request to invite the specified Amazon Web Services accounts to be member accounts in the behavior graph. This operation can only be called by the administrator account for a behavior graph.
 *
 * `CreateMembers` verifies the accounts and then invites the verified accounts. The administrator can optionally specify to not send invitation emails to the member accounts. This would be used when the administrator manages their member accounts centrally.
 *
 * For organization accounts in the organization behavior graph, `CreateMembers` attempts to enable the accounts. The organization accounts do not receive invitations.
 *
 * The request provides the behavior graph ARN and the list of accounts to invite or to enable.
 *
 * The response separates the requested accounts into two lists:
 * + The accounts that `CreateMembers` was able to process. For invited accounts, includes member accounts that are being verified, that have passed verification and are to be invited, and that have failed verification. For organization accounts in the organization behavior graph, includes accounts that can be enabled and that cannot be enabled.
 * + The accounts that `CreateMembers` was unable to process. This list includes accounts that were already invited to be member accounts in the behavior graph.
 */
public suspend inline fun DetectiveClient.createMembers(crossinline block: CreateMembersRequest.Builder.() -> Unit): CreateMembersResponse = createMembers(CreateMembersRequest.Builder().apply(block).build())

/**
 * Disables the specified behavior graph and queues it to be deleted. This operation removes the behavior graph from each member account's list of behavior graphs.
 *
 * `DeleteGraph` can only be called by the administrator account for a behavior graph.
 */
public suspend inline fun DetectiveClient.deleteGraph(crossinline block: DeleteGraphRequest.Builder.() -> Unit): DeleteGraphResponse = deleteGraph(DeleteGraphRequest.Builder().apply(block).build())

/**
 * Removes the specified member accounts from the behavior graph. The removed accounts no longer contribute data to the behavior graph. This operation can only be called by the administrator account for the behavior graph.
 *
 * For invited accounts, the removed accounts are deleted from the list of accounts in the behavior graph. To restore the account, the administrator account must send another invitation.
 *
 * For organization accounts in the organization behavior graph, the Detective administrator account can always enable the organization account again. Organization accounts that are not enabled as member accounts are not included in the `ListMembers` results for the organization behavior graph.
 *
 * An administrator account cannot use `DeleteMembers` to remove their own account from the behavior graph. To disable a behavior graph, the administrator account uses the `DeleteGraph` API method.
 */
public suspend inline fun DetectiveClient.deleteMembers(crossinline block: DeleteMembersRequest.Builder.() -> Unit): DeleteMembersResponse = deleteMembers(DeleteMembersRequest.Builder().apply(block).build())

/**
 * Returns information about the configuration for the organization behavior graph. Currently indicates whether to automatically enable new organization accounts as member accounts.
 *
 * Can only be called by the Detective administrator account for the organization.
 */
public suspend inline fun DetectiveClient.describeOrganizationConfiguration(crossinline block: DescribeOrganizationConfigurationRequest.Builder.() -> Unit): DescribeOrganizationConfigurationResponse = describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.Builder().apply(block).build())

/**
 * Removes the Detective administrator account in the current Region. Deletes the organization behavior graph.
 *
 * Can only be called by the organization management account.
 *
 * Removing the Detective administrator account does not affect the delegated administrator account for Detective in Organizations.
 *
 * To remove the delegated administrator account in Organizations, use the Organizations API. Removing the delegated administrator account also removes the Detective administrator account in all Regions, except for Regions where the Detective administrator account is the organization management account.
 */
public suspend inline fun DetectiveClient.disableOrganizationAdminAccount(crossinline block: DisableOrganizationAdminAccountRequest.Builder.() -> Unit): DisableOrganizationAdminAccountResponse = disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.Builder().apply(block).build())

/**
 * Removes the member account from the specified behavior graph. This operation can only be called by an invited member account that has the `ENABLED` status.
 *
 * `DisassociateMembership` cannot be called by an organization account in the organization behavior graph. For the organization behavior graph, the Detective administrator account determines which organization accounts to enable or disable as member accounts.
 */
public suspend inline fun DetectiveClient.disassociateMembership(crossinline block: DisassociateMembershipRequest.Builder.() -> Unit): DisassociateMembershipResponse = disassociateMembership(DisassociateMembershipRequest.Builder().apply(block).build())

/**
 * Designates the Detective administrator account for the organization in the current Region.
 *
 * If the account does not have Detective enabled, then enables Detective for that account and creates a new behavior graph.
 *
 * Can only be called by the organization management account.
 *
 * If the organization has a delegated administrator account in Organizations, then the Detective administrator account must be either the delegated administrator account or the organization management account.
 *
 * If the organization does not have a delegated administrator account in Organizations, then you can choose any account in the organization. If you choose an account other than the organization management account, Detective calls Organizations to make that account the delegated administrator account for Detective. The organization management account cannot be the delegated administrator account.
 */
public suspend inline fun DetectiveClient.enableOrganizationAdminAccount(crossinline block: EnableOrganizationAdminAccountRequest.Builder.() -> Unit): EnableOrganizationAdminAccountResponse = enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.Builder().apply(block).build())

/**
 * Detective investigations lets you investigate IAM users and IAM roles using indicators of compromise. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. `GetInvestigation` returns the investigation results of an investigation for a behavior graph.
 */
public suspend inline fun DetectiveClient.getInvestigation(crossinline block: GetInvestigationRequest.Builder.() -> Unit): GetInvestigationResponse = getInvestigation(GetInvestigationRequest.Builder().apply(block).build())

/**
 * Returns the membership details for specified member accounts for a behavior graph.
 */
public suspend inline fun DetectiveClient.getMembers(crossinline block: GetMembersRequest.Builder.() -> Unit): GetMembersResponse = getMembers(GetMembersRequest.Builder().apply(block).build())

/**
 * Lists data source packages in the behavior graph.
 */
public suspend inline fun DetectiveClient.listDatasourcePackages(crossinline block: ListDatasourcePackagesRequest.Builder.() -> Unit): ListDatasourcePackagesResponse = listDatasourcePackages(ListDatasourcePackagesRequest.Builder().apply(block).build())

/**
 * Returns the list of behavior graphs that the calling account is an administrator account of. This operation can only be called by an administrator account.
 *
 * Because an account can currently only be the administrator of one behavior graph within a Region, the results always contain a single behavior graph.
 */
public suspend inline fun DetectiveClient.listGraphs(crossinline block: ListGraphsRequest.Builder.() -> Unit): ListGraphsResponse = listGraphs(ListGraphsRequest.Builder().apply(block).build())

/**
 * Gets the indicators from an investigation. You can use the information from the indicators to determine if an IAM user and/or IAM role is involved in an unusual activity that could indicate malicious behavior and its impact.
 */
public suspend inline fun DetectiveClient.listIndicators(crossinline block: ListIndicatorsRequest.Builder.() -> Unit): ListIndicatorsResponse = listIndicators(ListIndicatorsRequest.Builder().apply(block).build())

/**
 * Detective investigations lets you investigate IAM users and IAM roles using indicators of compromise. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. `ListInvestigations` lists all active Detective investigations.
 */
public suspend inline fun DetectiveClient.listInvestigations(crossinline block: ListInvestigationsRequest.Builder.() -> Unit): ListInvestigationsResponse = listInvestigations(ListInvestigationsRequest.Builder().apply(block).build())

/**
 * Retrieves the list of open and accepted behavior graph invitations for the member account. This operation can only be called by an invited member account.
 *
 * Open invitations are invitations that the member account has not responded to.
 *
 * The results do not include behavior graphs for which the member account declined the invitation. The results also do not include behavior graphs that the member account resigned from or was removed from.
 */
public suspend inline fun DetectiveClient.listInvitations(crossinline block: ListInvitationsRequest.Builder.() -> Unit): ListInvitationsResponse = listInvitations(ListInvitationsRequest.Builder().apply(block).build())

/**
 * Retrieves the list of member accounts for a behavior graph.
 *
 * For invited accounts, the results do not include member accounts that were removed from the behavior graph.
 *
 * For the organization behavior graph, the results do not include organization accounts that the Detective administrator account has not enabled as member accounts.
 */
public suspend inline fun DetectiveClient.listMembers(crossinline block: ListMembersRequest.Builder.() -> Unit): ListMembersResponse = listMembers(ListMembersRequest.Builder().apply(block).build())

/**
 * Returns information about the Detective administrator account for an organization. Can only be called by the organization management account.
 */
public suspend inline fun DetectiveClient.listOrganizationAdminAccounts(crossinline block: ListOrganizationAdminAccountsRequest.Builder.() -> Unit): ListOrganizationAdminAccountsResponse = listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.Builder().apply(block).build())

/**
 * Returns the tag values that are assigned to a behavior graph.
 */
public suspend inline fun DetectiveClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Rejects an invitation to contribute the account data to a behavior graph. This operation must be called by an invited member account that has the `INVITED` status.
 *
 * `RejectInvitation` cannot be called by an organization account in the organization behavior graph. In the organization behavior graph, organization accounts do not receive an invitation.
 */
public suspend inline fun DetectiveClient.rejectInvitation(crossinline block: RejectInvitationRequest.Builder.() -> Unit): RejectInvitationResponse = rejectInvitation(RejectInvitationRequest.Builder().apply(block).build())

/**
 * Detective investigations lets you investigate IAM users and IAM roles using indicators of compromise. An indicator of compromise (IOC) is an artifact observed in or on a network, system, or environment that can (with a high level of confidence) identify malicious activity or a security incident. `StartInvestigation` initiates an investigation on an entity in a behavior graph.
 */
public suspend inline fun DetectiveClient.startInvestigation(crossinline block: StartInvestigationRequest.Builder.() -> Unit): StartInvestigationResponse = startInvestigation(StartInvestigationRequest.Builder().apply(block).build())

/**
 * Sends a request to enable data ingest for a member account that has a status of `ACCEPTED_BUT_DISABLED`.
 *
 * For valid member accounts, the status is updated as follows.
 * + If Detective enabled the member account, then the new status is `ENABLED`.
 * + If Detective cannot enable the member account, the status remains `ACCEPTED_BUT_DISABLED`.
 */
public suspend inline fun DetectiveClient.startMonitoringMember(crossinline block: StartMonitoringMemberRequest.Builder.() -> Unit): StartMonitoringMemberResponse = startMonitoringMember(StartMonitoringMemberRequest.Builder().apply(block).build())

/**
 * Applies tag values to a behavior graph.
 */
public suspend inline fun DetectiveClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a behavior graph.
 */
public suspend inline fun DetectiveClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Starts a data source package for the Detective behavior graph.
 */
public suspend inline fun DetectiveClient.updateDatasourcePackages(crossinline block: UpdateDatasourcePackagesRequest.Builder.() -> Unit): UpdateDatasourcePackagesResponse = updateDatasourcePackages(UpdateDatasourcePackagesRequest.Builder().apply(block).build())

/**
 * Updates the state of an investigation.
 */
public suspend inline fun DetectiveClient.updateInvestigationState(crossinline block: UpdateInvestigationStateRequest.Builder.() -> Unit): UpdateInvestigationStateResponse = updateInvestigationState(UpdateInvestigationStateRequest.Builder().apply(block).build())

/**
 * Updates the configuration for the Organizations integration in the current Region. Can only be called by the Detective administrator account for the organization.
 */
public suspend inline fun DetectiveClient.updateOrganizationConfiguration(crossinline block: UpdateOrganizationConfigurationRequest.Builder.() -> Unit): UpdateOrganizationConfigurationResponse = updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.Builder().apply(block).build())
