// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.DataSourceConfigurationOutput
import aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage
import aws.sdk.kotlin.services.datazone.model.DataSourceRunStatus
import aws.sdk.kotlin.services.datazone.model.DataSourceStatus
import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.EnableSetting
import aws.sdk.kotlin.services.datazone.model.FormOutput
import aws.sdk.kotlin.services.datazone.model.RecommendationConfiguration
import aws.sdk.kotlin.services.datazone.model.ScheduleConfiguration
import aws.sdk.kotlin.services.datazone.model.UpdateDataSourceResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class UpdateDataSourceOperationDeserializer: HttpDeserializer.NonStreaming<UpdateDataSourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateDataSourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateDataSourceError(context, call, payload)
        }
        val builder = UpdateDataSourceResponse.Builder()

        if (payload != null) {
            deserializeUpdateDataSourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateDataSourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDataSourceOperationBody(builder: UpdateDataSourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSETFORMSOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assetFormsOutput"))
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configuration"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val ENABLESETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("enableSetting"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("environmentId"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("errorMessage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LASTRUNAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastRunAt"))
    val LASTRUNERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("lastRunErrorMessage"))
    val LASTRUNSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("lastRunStatus"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectId"))
    val PUBLISHONIMPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("publishOnImport"))
    val RECOMMENDATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("recommendation"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("schedule"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("type"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSETFORMSOUTPUT_DESCRIPTOR)
        field(CONFIGURATION_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(ENABLESETTING_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LASTRUNAT_DESCRIPTOR)
        field(LASTRUNERRORMESSAGE_DESCRIPTOR)
        field(LASTRUNSTATUS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROJECTID_DESCRIPTOR)
        field(PUBLISHONIMPORT_DESCRIPTOR)
        field(RECOMMENDATION_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSETFORMSOUTPUT_DESCRIPTOR.index -> builder.assetFormsOutput =
                    deserializer.deserializeList(ASSETFORMSOUTPUT_DESCRIPTOR) {
                        val col0 = mutableListOf<FormOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFormOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CONFIGURATION_DESCRIPTOR.index -> builder.configuration = deserializeDataSourceConfigurationOutputDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                ENABLESETTING_DESCRIPTOR.index -> builder.enableSetting = deserializeString().let { EnableSetting.fromValue(it) }
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeDataSourceErrorMessageDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LASTRUNAT_DESCRIPTOR.index -> builder.lastRunAt = deserializeString().let { Instant.fromIso8601(it) }
                LASTRUNERRORMESSAGE_DESCRIPTOR.index -> builder.lastRunErrorMessage = deserializeDataSourceErrorMessageDocument(deserializer)
                LASTRUNSTATUS_DESCRIPTOR.index -> builder.lastRunStatus = deserializeString().let { DataSourceRunStatus.fromValue(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PROJECTID_DESCRIPTOR.index -> builder.projectId = deserializeString()
                PUBLISHONIMPORT_DESCRIPTOR.index -> builder.publishOnImport = deserializeBoolean()
                RECOMMENDATION_DESCRIPTOR.index -> builder.recommendation = deserializeRecommendationConfigurationDocument(deserializer)
                SCHEDULE_DESCRIPTOR.index -> builder.schedule = deserializeScheduleConfigurationDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { DataSourceStatus.fromValue(it) }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
