// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.DataSourceErrorMessage
import aws.sdk.kotlin.services.datazone.model.DataSourceRunStatus
import aws.sdk.kotlin.services.datazone.model.DataSourceRunType
import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.RunStatisticsForAssets
import aws.sdk.kotlin.services.datazone.model.StartDataSourceRunResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class StartDataSourceRunOperationDeserializer: HttpDeserializer.NonStreaming<StartDataSourceRunResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartDataSourceRunResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartDataSourceRunError(context, call, payload)
        }
        val builder = StartDataSourceRunResponse.Builder()

        if (payload != null) {
            deserializeStartDataSourceRunOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartDataSourceRunError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartDataSourceRunOperationBody(builder: StartDataSourceRunResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DATASOURCECONFIGURATIONSNAPSHOT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataSourceConfigurationSnapshot"))
    val DATASOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataSourceId"))
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("errorMessage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val PROJECTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectId"))
    val RUNSTATISTICSFORASSETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("runStatisticsForAssets"))
    val STARTEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startedAt"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STOPPEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("stoppedAt"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(DATASOURCECONFIGURATIONSNAPSHOT_DESCRIPTOR)
        field(DATASOURCEID_DESCRIPTOR)
        field(DOMAINID_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(PROJECTID_DESCRIPTOR)
        field(RUNSTATISTICSFORASSETS_DESCRIPTOR)
        field(STARTEDAT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STOPPEDAT_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                DATASOURCECONFIGURATIONSNAPSHOT_DESCRIPTOR.index -> builder.dataSourceConfigurationSnapshot = deserializeString()
                DATASOURCEID_DESCRIPTOR.index -> builder.dataSourceId = deserializeString()
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeDataSourceErrorMessageDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                PROJECTID_DESCRIPTOR.index -> builder.projectId = deserializeString()
                RUNSTATISTICSFORASSETS_DESCRIPTOR.index -> builder.runStatisticsForAssets = deserializeRunStatisticsForAssetsDocument(deserializer)
                STARTEDAT_DESCRIPTOR.index -> builder.startedAt = deserializeString().let { Instant.fromIso8601(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { DataSourceRunStatus.fromValue(it) }
                STOPPEDAT_DESCRIPTOR.index -> builder.stoppedAt = deserializeString().let { Instant.fromIso8601(it) }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { DataSourceRunType.fromValue(it) }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromIso8601(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
