// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.FilterClause
import aws.sdk.kotlin.services.datazone.model.SearchInItem
import aws.sdk.kotlin.services.datazone.model.SearchListingsRequest
import aws.sdk.kotlin.services.datazone.model.SearchOutputAdditionalAttribute
import aws.sdk.kotlin.services.datazone.model.SearchSort
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SearchListingsOperationSerializer: HttpSerializer.NonStreaming<SearchListingsRequest> {
    override fun serialize(context: ExecutionContext, input: SearchListingsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode(input.domainIdentifier))
                add(PercentEncoding.Path.encode("listings"))
                add(PercentEncoding.Path.encode("search"))
            }
        }

        val payload = serializeSearchListingsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchListingsOperationBody(context: ExecutionContext, input: SearchListingsRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDITIONALATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalAttributes"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("filters"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SEARCHIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("searchIn"))
    val SEARCHTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("searchText"))
    val SORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sort"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALATTRIBUTES_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SEARCHIN_DESCRIPTOR)
        field(SEARCHTEXT_DESCRIPTOR)
        field(SORT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.additionalAttributes != null) {
            listField(ADDITIONALATTRIBUTES_DESCRIPTOR) {
                for (el0 in input.additionalAttributes) {
                    serializeString(el0.value)
                }
            }
        }
        input.filters?.let { field(FILTERS_DESCRIPTOR, it, ::serializeFilterClauseDocument) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        if (input.searchIn != null) {
            listField(SEARCHIN_DESCRIPTOR) {
                for (el0 in input.searchIn) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSearchInItemDocument))
                }
            }
        }
        input.searchText?.let { field(SEARCHTEXT_DESCRIPTOR, it) }
        input.sort?.let { field(SORT_DESCRIPTOR, it, ::serializeSearchSortDocument) }
    }
    return serializer.toByteArray()
}
