// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.GroupSearchType
import aws.sdk.kotlin.services.datazone.model.SearchGroupProfilesRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SearchGroupProfilesOperationSerializer: HttpSerializer.NonStreaming<SearchGroupProfilesRequest> {
    override fun serialize(context: ExecutionContext, input: SearchGroupProfilesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode(input.domainIdentifier))
                add(PercentEncoding.Path.encode("search-group-profiles"))
            }
        }

        val payload = serializeSearchGroupProfilesOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchGroupProfilesOperationBody(context: ExecutionContext, input: SearchGroupProfilesRequest): ByteArray {
    val serializer = JsonSerializer()
    val GROUPTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("groupType"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("maxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SEARCHTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("searchText"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GROUPTYPE_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SEARCHTEXT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.groupType?.let { field(GROUPTYPE_DESCRIPTOR, it.value) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.searchText?.let { field(SEARCHTEXT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
