// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.RejectChoice
import aws.sdk.kotlin.services.datazone.model.RejectPredictionsRequest
import aws.sdk.kotlin.services.datazone.model.RejectRule
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class RejectPredictionsOperationSerializer: HttpSerializer.NonStreaming<RejectPredictionsRequest> {
    override fun serialize(context: ExecutionContext, input: RejectPredictionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.domainIdentifier) { "domainIdentifier is bound to the URI and must not be null" }
            requireNotNull(input.identifier) { "identifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v2"))
                add(PercentEncoding.Path.encode("domains"))
                add(PercentEncoding.SmithyLabel.encode(input.domainIdentifier))
                add(PercentEncoding.Path.encode("assets"))
                add(PercentEncoding.SmithyLabel.encode(input.identifier))
                add(PercentEncoding.Path.encode("reject-predictions"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.revision != null) add("revision", input.revision)
            }
        }

        val payload = serializeRejectPredictionsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeRejectPredictionsOperationBody(context: ExecutionContext, input: RejectPredictionsRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val REJECTCHOICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("rejectChoices"))
    val REJECTRULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("rejectRule"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(REJECTCHOICES_DESCRIPTOR)
        field(REJECTRULE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        if (input.rejectChoices != null) {
            listField(REJECTCHOICES_DESCRIPTOR) {
                for (el0 in input.rejectChoices) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeRejectChoiceDocument))
                }
            }
        }
        input.rejectRule?.let { field(REJECTRULE_DESCRIPTOR, it, ::serializeRejectRuleDocument) }
    }
    return serializer.toByteArray()
}
