// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.datazone.serde

import aws.sdk.kotlin.services.datazone.model.DataZoneException
import aws.sdk.kotlin.services.datazone.model.PostTimeSeriesDataPointsResponse
import aws.sdk.kotlin.services.datazone.model.TimeSeriesDataPointFormOutput
import aws.sdk.kotlin.services.datazone.model.TimeSeriesEntityType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PostTimeSeriesDataPointsOperationDeserializer: HttpDeserializer.NonStreaming<PostTimeSeriesDataPointsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PostTimeSeriesDataPointsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPostTimeSeriesDataPointsError(context, call, payload)
        }
        val builder = PostTimeSeriesDataPointsResponse.Builder()

        if (payload != null) {
            deserializePostTimeSeriesDataPointsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPostTimeSeriesDataPointsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw DataZoneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> DataZoneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePostTimeSeriesDataPointsOperationBody(builder: PostTimeSeriesDataPointsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DOMAINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("domainId"))
    val ENTITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("entityId"))
    val ENTITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("entityType"))
    val FORMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("forms"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DOMAINID_DESCRIPTOR)
        field(ENTITYID_DESCRIPTOR)
        field(ENTITYTYPE_DESCRIPTOR)
        field(FORMS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DOMAINID_DESCRIPTOR.index -> builder.domainId = deserializeString()
                ENTITYID_DESCRIPTOR.index -> builder.entityId = deserializeString()
                ENTITYTYPE_DESCRIPTOR.index -> builder.entityType = deserializeString().let { TimeSeriesEntityType.fromValue(it) }
                FORMS_DESCRIPTOR.index -> builder.forms =
                    deserializer.deserializeList(FORMS_DESCRIPTOR) {
                        val col0 = mutableListOf<TimeSeriesDataPointFormOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTimeSeriesDataPointFormOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
